/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.typeinfo.TypeInfoVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.NamespaceFactory;
import org.jetbrains.jet.lang.resolve.NamespaceFactoryImpl;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.AlternativeSignatureParsing;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolverHelper;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JdkNames;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.JetSignatureUtils;
import org.jetbrains.jet.lang.resolve.java.JetTypeJetSignatureReader;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.PropertyAccessorData;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.java.TypeSource;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolvers;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.rt.signature.JetSignatureAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureExceptionsAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureReader;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public class JavaDescriptorResolver
implements DependencyClassByQualifiedNameResolver {
    public static final Name JAVA_ROOT = Name.special("<java_root>");
    public static final ModuleDescriptor FAKE_ROOT_MODULE = new ModuleDescriptor(JAVA_ROOT);
    static final DeclarationDescriptor JAVA_METHOD_TYPE_PARAMETER_PARENT = new DeclarationDescriptorImpl(null, Collections.emptyList(), Name.special("<java_generic_method>")){

        @Override
        public DeclarationDescriptor substitute(TypeSubstitutor substitutor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
            return visitor.visitDeclarationDescriptor(this, data);
        }
    };
    static final DeclarationDescriptor JAVA_CLASS_OBJECT = new DeclarationDescriptorImpl(null, Collections.emptyList(), Name.special("<java_class_object_emulation>")){

        @Override
        @NotNull
        public DeclarationDescriptor substitute(TypeSubstitutor substitutor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
            return visitor.visitDeclarationDescriptor(this, data);
        }
    };
    private static Visibility PACKAGE_VISIBILITY = new Visibility("package", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            NamespaceDescriptor parentPackage = DescriptorUtils.getParentOfType(what, NamespaceDescriptor.class);
            NamespaceDescriptor fromPackage = DescriptorUtils.getParentOfType(from, NamespaceDescriptor.class, false);
            assert (parentPackage != null);
            return parentPackage.equals(fromPackage);
        }

        @Override
        protected Integer compareTo(@NotNull Visibility visibility) {
            if (this == visibility) {
                return 0;
            }
            if (visibility == Visibilities.PRIVATE) {
                return 1;
            }
            return -1;
        }
    };
    protected final Map<FqName, ResolverBinaryClassData> classDescriptorCache = Maps.newHashMap();
    protected final Map<FqName, ResolverNamespaceData> namespaceDescriptorCacheByFqn = Maps.newHashMap();
    protected Project project;
    protected JavaSemanticServices semanticServices;
    private NamespaceFactory namespaceFactory;
    private BindingTrace trace;
    private PsiClassFinder psiClassFinder;
    private static final FqName JL_OBJECT = new FqName("java.lang.Object");

    @Inject
    public void setProject(Project project) {
        this.project = project;
    }

    @Inject
    public void setNamespaceFactory(NamespaceFactoryImpl namespaceFactory) {
        this.namespaceFactory = namespaceFactory;
    }

    @Inject
    public void setSemanticServices(JavaSemanticServices semanticServices) {
        this.semanticServices = semanticServices;
    }

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Inject
    public void setPsiClassFinder(PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    @Nullable
    private ClassDescriptor resolveJavaLangObject() {
        ClassDescriptor clazz = this.resolveClass(JdkNames.JL_OBJECT.getFqName(), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
        if (clazz == null) {
            // empty if block
        }
        return clazz;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        ArrayList<Runnable> tasks = Lists.newArrayList();
        ClassDescriptor clazz = this.resolveClass(qualifiedName, searchRule, tasks);
        for (Runnable task : tasks) {
            task.run();
        }
        return clazz;
    }

    @Override
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName) {
        return this.resolveClass(qualifiedName, DescriptorSearchRule.ERROR_IF_FOUND_IN_KOTLIN);
    }

    private ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule, @NotNull List<Runnable> tasks) {
        if (qualifiedName.getFqName().endsWith("$$TImpl")) {
            return null;
        }
        ClassDescriptor builtinClassDescriptor = this.semanticServices.getKotlinBuiltinClassDescriptor(qualifiedName);
        if (builtinClassDescriptor != null) {
            return builtinClassDescriptor;
        }
        ClassDescriptor kotlinClassDescriptor = this.semanticServices.getKotlinClassDescriptor(qualifiedName);
        if (kotlinClassDescriptor != null) {
            if (searchRule == DescriptorSearchRule.ERROR_IF_FOUND_IN_KOTLIN) {
                throw new IllegalStateException("class must not be found in kotlin: " + qualifiedName);
            }
            if (searchRule == DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN) {
                return null;
            }
            if (searchRule == DescriptorSearchRule.INCLUDE_KOTLIN) {
                return kotlinClassDescriptor;
            }
            throw new IllegalStateException("unknown searchRule: " + (Object)((Object)searchRule));
        }
        ResolverBinaryClassData classData = this.classDescriptorCache.get(qualifiedName);
        if (classData == null) {
            PsiClass psiClass = this.psiClassFinder.findPsiClass(qualifiedName, PsiClassFinder.RuntimeClassesHandleMode.THROW);
            if (psiClass == null) {
                ResolverBinaryClassData oldValue = this.classDescriptorCache.put(qualifiedName, ResolverBinaryClassData.NEGATIVE);
                if (oldValue != null) {
                    throw new IllegalStateException("rewrite at " + qualifiedName);
                }
                return null;
            }
            classData = this.createJavaClassDescriptor(psiClass, tasks);
        }
        return classData.classDescriptor;
    }

    @NotNull
    private ResolverBinaryClassData createJavaClassDescriptor(@NotNull PsiClass psiClass, List<Runnable> taskList) {
        MutableClassDescriptorLite classObject;
        FqName fqName = new FqName(psiClass.getQualifiedName());
        if (this.classDescriptorCache.containsKey(fqName)) {
            throw new IllegalStateException(psiClass.getQualifiedName());
        }
        JavaDescriptorResolver.checkPsiClassIsNotJet(psiClass);
        Name name = Name.identifier(psiClass.getName());
        ClassKind kind = psiClass.isInterface() ? (psiClass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ClassKind.TRAIT) : ClassKind.CLASS;
        ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(psiClass);
        ResolverBinaryClassData classData = this.classDescriptorCache.get(fqName);
        if (classData != null) {
            return classData;
        }
        classData = new ResolverBinaryClassData(psiClass, fqName, new MutableClassDescriptorLite(containingDeclaration, kind));
        this.classDescriptorCache.put(fqName, classData);
        classData.classDescriptor.setName(name);
        classData.classDescriptor.setAnnotations(this.resolveAnnotations(psiClass, taskList));
        ArrayList<JetType> supertypes = new ArrayList<JetType>();
        classData.typeParameters = this.createUninitializedClassTypeParameters(psiClass, classData);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>();
        for (TypeParameterDescriptorInitialization typeParameter : classData.typeParameters) {
            typeParameters.add(typeParameter.descriptor);
        }
        classData.classDescriptor.setTypeParameterDescriptors(typeParameters);
        classData.classDescriptor.setSupertypes(supertypes);
        classData.classDescriptor.setVisibility(JavaDescriptorResolver.resolveVisibilityFromPsiModifiers(psiClass));
        Modality modality = classData.classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS ? Modality.FINAL : Modality.convertFromFlags(psiClass.hasModifierProperty("abstract") || psiClass.isInterface(), !psiClass.hasModifierProperty("final"));
        classData.classDescriptor.setModality(modality);
        classData.classDescriptor.createTypeConstructor();
        classData.classDescriptor.setScopeForMemberLookup(new JavaClassMembersScope(this.semanticServices, classData));
        this.initializeTypeParameters(classData.typeParameters, classData.classDescriptor, "class " + psiClass.getQualifiedName());
        TypeVariableResolver resolverForTypeParameters = TypeVariableResolvers.classTypeVariableResolver(classData.classDescriptor, "class " + psiClass.getQualifiedName());
        supertypes.addAll(this.getSupertypes(new PsiClassWrapper(psiClass), classData, classData.getTypeParameters()));
        PsiMethod[] psiConstructors = psiClass.getConstructors();
        boolean isStatic = psiClass.hasModifierProperty("static");
        if (psiConstructors.length == 0) {
            ConstructorDescriptorImpl constructorDescriptor;
            if (!psiClass.isInterface()) {
                constructorDescriptor = new ConstructorDescriptorImpl(classData.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
                constructorDescriptor.initialize(typeParameters, Collections.<ValueParameterDescriptor>emptyList(), classData.classDescriptor.getVisibility(), isStatic);
                constructorDescriptor.setReturnType(classData.classDescriptor.getDefaultType());
                classData.classDescriptor.addConstructor(constructorDescriptor, null);
                this.trace.record(BindingContext.CONSTRUCTOR, psiClass, constructorDescriptor);
            }
            if (psiClass.isAnnotationType()) {
                constructorDescriptor = new ConstructorDescriptorImpl(classData.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
                ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
                PsiMethod[] methods = psiClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    PsiMethod method = methods[i];
                    if (!(method instanceof PsiAnnotationMethod)) continue;
                    PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)method;
                    assert (annotationMethod.getParameterList().getParameters().length == 0);
                    PsiType returnType = annotationMethod.getReturnType();
                    JetType varargElementType = null;
                    if (i == methods.length - 1 && returnType instanceof PsiArrayType) {
                        varargElementType = this.semanticServices.getTypeTransformer().transformToType(((PsiArrayType)returnType).getComponentType(), resolverForTypeParameters);
                    }
                    valueParameters.add(new ValueParameterDescriptorImpl(constructorDescriptor, i, Collections.<AnnotationDescriptor>emptyList(), Name.identifier(method.getName()), false, this.semanticServices.getTypeTransformer().transformToType(returnType, resolverForTypeParameters), annotationMethod.getDefaultValue() != null, varargElementType));
                }
                constructorDescriptor.initialize(typeParameters, valueParameters, classData.classDescriptor.getVisibility(), isStatic);
                constructorDescriptor.setReturnType(classData.classDescriptor.getDefaultType());
                classData.classDescriptor.addConstructor(constructorDescriptor, null);
                this.trace.record(BindingContext.CONSTRUCTOR, psiClass, constructorDescriptor);
            }
        } else {
            for (PsiMethod psiConstructor : psiConstructors) {
                this.resolveConstructor(psiClass, classData, isStatic, psiConstructor);
            }
        }
        if ((classObject = this.createClassObjectDescriptor(classData.classDescriptor, psiClass)) != null) {
            classData.classDescriptor.getBuilder().setClassObjectDescriptor(classObject);
        }
        this.trace.record(BindingContext.CLASS, psiClass, classData.classDescriptor);
        return classData;
    }

    private void resolveConstructor(PsiClass psiClass, ResolverBinaryClassData classData, boolean aStatic, PsiMethod psiConstructor) {
        PsiMethodWrapper constructor = new PsiMethodWrapper(psiConstructor);
        if (constructor.getJetConstructor().hidden()) {
            return;
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classData.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
        String context = "constructor of class " + psiClass.getQualifiedName();
        ValueParameterDescriptors valueParameterDescriptors = this.resolveParameterDescriptors(constructorDescriptor, constructor.getParameters(), TypeVariableResolvers.classTypeVariableResolver(classData.classDescriptor, context));
        if (valueParameterDescriptors.receiverType != null) {
            throw new IllegalStateException();
        }
        constructorDescriptor.initialize(classData.classDescriptor.getTypeConstructor().getParameters(), valueParameterDescriptors.descriptors, JavaDescriptorResolver.resolveVisibilityFromPsiModifiers(psiConstructor), aStatic);
        constructorDescriptor.setReturnType(classData.classDescriptor.getDefaultType());
        classData.classDescriptor.addConstructor(constructorDescriptor, null);
        this.trace.record(BindingContext.CONSTRUCTOR, psiConstructor, constructorDescriptor);
    }

    static void checkPsiClassIsNotJet(PsiClass psiClass) {
        if (psiClass instanceof JetJavaMirrorMarker) {
            throw new IllegalStateException("trying to resolve fake jet PsiClass as regular PsiClass: " + psiClass.getQualifiedName());
        }
    }

    @Nullable
    private PsiClass getInnerClassClassObject(@NotNull PsiClass outer) {
        for (PsiClass inner : outer.getInnerClasses()) {
            if (!inner.getName().equals("ClassObject$")) continue;
            return inner;
        }
        return null;
    }

    @Nullable
    private MutableClassDescriptorLite createClassObjectDescriptor(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        PsiClass classObjectPsiClass = this.getInnerClassClassObject(psiClass);
        if (classObjectPsiClass == null) {
            return null;
        }
        JavaDescriptorResolver.checkPsiClassIsNotJet(psiClass);
        FqName fqName = new FqName(classObjectPsiClass.getQualifiedName());
        ResolverBinaryClassData classData = new ResolverBinaryClassData(classObjectPsiClass, fqName, new MutableClassDescriptorLite(containing, ClassKind.OBJECT));
        this.classDescriptorCache.put(fqName, classData);
        classData.classDescriptor.setSupertypes(this.getSupertypes(new PsiClassWrapper(classObjectPsiClass), classData, new ArrayList<TypeParameterDescriptor>(0)));
        classData.classDescriptor.setName(JetPsiUtil.NO_NAME_PROVIDED);
        classData.classDescriptor.setModality(Modality.FINAL);
        classData.classDescriptor.setVisibility(containing.getVisibility());
        classData.classDescriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
        classData.classDescriptor.createTypeConstructor();
        classData.classDescriptor.setScopeForMemberLookup(new JavaClassMembersScope(this.semanticServices, classData));
        ConstructorDescriptorImpl constructor = new ConstructorDescriptorImpl(classData.classDescriptor, new ArrayList<AnnotationDescriptor>(0), true);
        constructor.setReturnType(classData.classDescriptor.getDefaultType());
        constructor.initialize(new ArrayList<TypeParameterDescriptor>(0), new ArrayList<ValueParameterDescriptor>(0), Visibilities.PUBLIC);
        classData.classDescriptor.addConstructor(constructor, null);
        return classData.classDescriptor;
    }

    private List<TypeParameterDescriptorInitialization> createUninitializedClassTypeParameters(PsiClass psiClass, ResolverBinaryClassData classData) {
        JetClassAnnotation jetClassAnnotation = JetClassAnnotation.get(psiClass);
        if (jetClassAnnotation.signature().length() > 0) {
            return this.resolveClassTypeParametersFromJetSignature(jetClassAnnotation.signature(), psiClass, classData.classDescriptor);
        }
        return this.makeUninitializedTypeParameters(classData.classDescriptor, psiClass.getTypeParameters());
    }

    @NotNull
    private PsiTypeParameter getPsiTypeParameterByName(PsiTypeParameterListOwner clazz, String name) {
        for (PsiTypeParameter typeParameter : clazz.getTypeParameters()) {
            if (!typeParameter.getName().equals(name)) continue;
            return typeParameter;
        }
        throw new IllegalStateException("PsiTypeParameter '" + name + "' is not found");
    }

    private boolean isJavaLangObject(JetType type) {
        ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor instanceof ClassDescriptor && DescriptorUtils.getFQName(classifierDescriptor).equals(JL_OBJECT.toUnsafe());
    }

    private List<TypeParameterDescriptorInitialization> resolveClassTypeParametersFromJetSignature(String jetSignature, PsiClass clazz, ClassDescriptor classDescriptor) {
        String context = "class " + clazz.getQualifiedName();
        JetSignatureTypeParametersVisitor jetSignatureTypeParametersVisitor = new JetSignatureTypeParametersVisitor(classDescriptor, clazz, context){

            @Override
            public JetSignatureVisitor visitSuperclass() {
                return new JetSignatureAdapter();
            }

            @Override
            public JetSignatureVisitor visitInterface() {
                return new JetSignatureAdapter();
            }
        };
        new JetSignatureReader(jetSignature).accept(jetSignatureTypeParametersVisitor);
        return jetSignatureTypeParametersVisitor.r;
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentDescriptor(@NotNull PsiClass psiClass) {
        FqName fqName = new FqName(psiClass.getQualifiedName());
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null) {
            FqName containerFqName = new FqName(containingClass.getQualifiedName());
            ClassDescriptor clazz = this.resolveClass(containerFqName, DescriptorSearchRule.INCLUDE_KOTLIN);
            if (clazz == null) {
                throw new IllegalStateException("PsiClass not found by name " + containerFqName + ", required to be container declaration of " + fqName);
            }
            return clazz;
        }
        NamespaceDescriptor ns = this.resolveNamespace(fqName.parent(), DescriptorSearchRule.INCLUDE_KOTLIN);
        if (ns == null) {
            throw new IllegalStateException("cannot resolve namespace " + fqName.parent() + ", required to be container for " + fqName);
        }
        return ns;
    }

    private List<TypeParameterDescriptorInitialization> makeUninitializedTypeParameters(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter[] typeParameters) {
        ArrayList<TypeParameterDescriptorInitialization> result = Lists.newArrayList();
        for (PsiTypeParameter typeParameter : typeParameters) {
            TypeParameterDescriptorInitialization typeParameterDescriptor = this.makeUninitializedTypeParameter(containingDeclaration, typeParameter);
            result.add(typeParameterDescriptor);
        }
        return result;
    }

    @NotNull
    private TypeParameterDescriptorInitialization makeUninitializedTypeParameter(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter psiTypeParameter) {
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), false, Variance.INVARIANT, Name.identifier(psiTypeParameter.getName()), psiTypeParameter.getIndex());
        return new TypeParameterDescriptorInitialization(typeParameterDescriptor, psiTypeParameter);
    }

    private void initializeTypeParameter(TypeParameterDescriptorInitialization typeParameter, TypeVariableResolver typeVariableByPsiResolver) {
        TypeParameterDescriptorImpl typeParameterDescriptor = typeParameter.descriptor;
        if (typeParameter.origin == TypeParameterDescriptorOrigin.KOTLIN) {
            List upperBounds = typeParameter.upperBoundsForKotlin;
            if (upperBounds.size() == 0) {
                typeParameterDescriptor.addUpperBound(JetStandardClasses.getNullableAnyType());
            } else {
                for (JetType upperBound : typeParameter.upperBoundsForKotlin) {
                    typeParameterDescriptor.addUpperBound(upperBound);
                }
            }
        } else {
            PsiClassType[] referencedTypes = typeParameter.psiTypeParameter.getExtendsList().getReferencedTypes();
            if (referencedTypes.length == 0) {
                typeParameterDescriptor.addUpperBound(JetStandardClasses.getNullableAnyType());
            } else if (referencedTypes.length == 1) {
                typeParameterDescriptor.addUpperBound(this.semanticServices.getTypeTransformer().transformToType(referencedTypes[0], JavaTypeTransformer.TypeUsage.UPPER_BOUND, typeVariableByPsiResolver));
            } else {
                for (PsiClassType referencedType : referencedTypes) {
                    typeParameterDescriptor.addUpperBound(this.semanticServices.getTypeTransformer().transformToType(referencedType, JavaTypeTransformer.TypeUsage.UPPER_BOUND, typeVariableByPsiResolver));
                }
            }
        }
        typeParameterDescriptor.setInitialized();
    }

    private void initializeTypeParameters(List<TypeParameterDescriptorInitialization> typeParametersInitialization, @NotNull DeclarationDescriptor typeParametersOwner, @NotNull String context) {
        ArrayList<TypeParameterDescriptorImpl> prevTypeParameters = new ArrayList<TypeParameterDescriptorImpl>();
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        for (TypeParameterDescriptorInitialization typeParameterDescriptor : typeParametersInitialization) {
            typeParameters.add(typeParameterDescriptor.descriptor);
        }
        for (TypeParameterDescriptorInitialization psiTypeParameter : typeParametersInitialization) {
            prevTypeParameters.add(psiTypeParameter.descriptor);
            this.initializeTypeParameter(psiTypeParameter, TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, typeParametersOwner, context));
        }
    }

    private Collection<JetType> getSupertypes(PsiClassWrapper psiClass, ResolverBinaryClassData classData, List<TypeParameterDescriptor> typeParameters) {
        MutableClassDescriptorLite classDescriptor = classData.classDescriptor;
        final ArrayList<JetType> result = new ArrayList<JetType>();
        String context = "class " + psiClass.getQualifiedName();
        if (psiClass.getJetClass().signature().length() > 0) {
            final TypeVariableResolver typeVariableResolver = TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, classDescriptor, context);
            new JetSignatureReader(psiClass.getJetClass().signature()).accept(new JetSignatureExceptionsAdapter(){

                @Override
                public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
                    return new JetSignatureAdapter();
                }

                @Override
                public JetSignatureVisitor visitSuperclass() {
                    return new JetTypeJetSignatureReader(JavaDescriptorResolver.this.semanticServices, JetStandardLibrary.getInstance(), typeVariableResolver){

                        @Override
                        protected void done(@NotNull JetType jetType) {
                            if (!((Object)jetType).equals(JetStandardClasses.getAnyType())) {
                                result.add(jetType);
                            }
                        }
                    };
                }

                @Override
                public JetSignatureVisitor visitInterface() {
                    return this.visitSuperclass();
                }
            });
        } else {
            TypeVariableResolver typeVariableResolverForSupertypes = TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, classDescriptor, context);
            this.transformSupertypeList(result, psiClass.getPsiClass().getExtendsListTypes(), typeVariableResolverForSupertypes, classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS);
            this.transformSupertypeList(result, psiClass.getPsiClass().getImplementsListTypes(), typeVariableResolverForSupertypes, classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS);
        }
        for (JetType supertype : result) {
            if (!ErrorUtils.isErrorType(supertype)) continue;
            this.trace.record(BindingContext.INCOMPLETE_HIERARCHY, classDescriptor);
        }
        if (result.isEmpty()) {
            if (classData.kotlin || psiClass.getQualifiedName().equals(JdkNames.JL_OBJECT.getFqName().getFqName()) || classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
                result.add(JetStandardClasses.getAnyType());
            } else {
                ClassDescriptor object = this.resolveJavaLangObject();
                if (object != null) {
                    result.add(object.getDefaultType());
                } else {
                    result.add(JetStandardClasses.getAnyType());
                }
            }
        }
        return result;
    }

    private void transformSupertypeList(List<JetType> result, PsiClassType[] extendsListTypes, TypeVariableResolver typeVariableResolver, boolean annotation) {
        for (PsiClassType type : extendsListTypes) {
            JetType transform;
            PsiClass resolved = type.resolve();
            if (resolved != null && resolved.getQualifiedName().equals(JvmStdlibNames.JET_OBJECT.getFqName().getFqName()) || resolved != null && annotation && resolved.getQualifiedName().equals("java.lang.annotation.Annotation") || ErrorUtils.isErrorType(transform = this.semanticServices.getTypeTransformer().transformToType(type, JavaTypeTransformer.TypeUsage.SUPERTYPE, typeVariableResolver))) continue;
            result.add(TypeUtils.makeNotNullable(transform));
        }
    }

    @Nullable
    public NamespaceDescriptor resolveNamespace(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        NamespaceDescriptor kotlinNamespaceDescriptor = this.semanticServices.getKotlinNamespaceDescriptor(qualifiedName);
        if (kotlinNamespaceDescriptor != null) {
            if (searchRule == DescriptorSearchRule.ERROR_IF_FOUND_IN_KOTLIN) {
                throw new IllegalStateException("class must not be found in kotlin: " + qualifiedName);
            }
            if (searchRule == DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN) {
                return null;
            }
            if (searchRule == DescriptorSearchRule.INCLUDE_KOTLIN) {
                return kotlinNamespaceDescriptor;
            }
            throw new IllegalStateException("unknown searchRule: " + (Object)((Object)searchRule));
        }
        ResolverNamespaceData namespaceData = this.namespaceDescriptorCacheByFqn.get(qualifiedName);
        if (namespaceData != null) {
            return namespaceData.namespaceDescriptor;
        }
        NamespaceDescriptorParent parentNs = this.resolveParentNamespace(qualifiedName);
        if (parentNs == null) {
            return null;
        }
        JavaNamespaceDescriptor ns = new JavaNamespaceDescriptor(parentNs, Collections.<AnnotationDescriptor>emptyList(), qualifiedName.isRoot() ? FqNameUnsafe.ROOT_NAME : qualifiedName.shortName(), qualifiedName);
        ResolverNamespaceData scopeData = this.createNamespaceResolverScopeData(qualifiedName, ns);
        if (scopeData == null) {
            return null;
        }
        this.trace.record(BindingContext.NAMESPACE, scopeData.getPsiPackageOrPsiClass(), ns);
        ns.setMemberScope(scopeData.memberScope);
        return scopeData.namespaceDescriptor;
    }

    @Override
    public NamespaceDescriptor resolveNamespace(@NotNull FqName qualifiedName) {
        return this.resolveNamespace(qualifiedName, DescriptorSearchRule.ERROR_IF_FOUND_IN_KOTLIN);
    }

    private NamespaceDescriptorParent resolveParentNamespace(FqName fqName) {
        if (fqName.isRoot()) {
            return FAKE_ROOT_MODULE;
        }
        return this.resolveNamespace(fqName.parent(), DescriptorSearchRule.INCLUDE_KOTLIN);
    }

    @Nullable
    private ResolverNamespaceData createNamespaceResolverScopeData(@NotNull FqName fqName, @NotNull NamespaceDescriptor ns) {
        PsiClass psiClass = this.getPsiClassForJavaPackageScope(fqName);
        PsiPackage psiPackage = this.semanticServices.getPsiClassFinder().findPsiPackage(fqName);
        if (psiClass != null || psiPackage != null) {
            this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, ns, JavaNamespaceKind.PROPER);
        } else {
            psiClass = this.psiClassFinder.findPsiClass(fqName, PsiClassFinder.RuntimeClassesHandleMode.IGNORE);
            if (psiClass != null) {
                this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, ns, JavaNamespaceKind.CLASS_STATICS);
            } else {
                ResolverNamespaceData oldValue = this.namespaceDescriptorCacheByFqn.put(fqName, ResolverNamespaceData.NEGATIVE);
                if (oldValue != null) {
                    throw new IllegalStateException("rewrite at " + fqName);
                }
                return null;
            }
        }
        ResolverNamespaceData namespaceData = new ResolverNamespaceData(psiClass, psiPackage, fqName, ns);
        namespaceData.memberScope = new JavaPackageScope(fqName, this.semanticServices, namespaceData);
        ResolverNamespaceData oldValue = this.namespaceDescriptorCacheByFqn.put(fqName, namespaceData);
        if (oldValue != null) {
            throw new IllegalStateException("rewrite at " + fqName);
        }
        return namespaceData;
    }

    @Nullable
    public JavaPackageScope getJavaPackageScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor ns) {
        ResolverNamespaceData resolverNamespaceData = this.namespaceDescriptorCacheByFqn.get(fqName);
        if (resolverNamespaceData == null) {
            resolverNamespaceData = this.createNamespaceResolverScopeData(fqName, ns);
        }
        if (resolverNamespaceData == null) {
            return null;
        }
        if (resolverNamespaceData == ResolverNamespaceData.NEGATIVE) {
            throw new IllegalStateException("This means that we are trying to create a Java package, but have a package with the same FQN defined in Kotlin: " + fqName);
        }
        JavaPackageScope scope = resolverNamespaceData.memberScope;
        if (scope == null) {
            throw new IllegalStateException("fqn: " + fqName);
        }
        return scope;
    }

    @Nullable
    private PsiClass getPsiClassForJavaPackageScope(@NotNull FqName packageFQN) {
        return this.psiClassFinder.findPsiClass(packageFQN.child(Name.identifier("namespace")), PsiClassFinder.RuntimeClassesHandleMode.IGNORE);
    }

    @NotNull
    private JvmMethodParameterMeaning resolveParameterDescriptor(DeclarationDescriptor containingDeclaration, int i, PsiParameterWrapper parameter, TypeVariableResolver typeVariableResolver) {
        JetType varargElementType;
        if (parameter.getJetTypeParameter().isDefined()) {
            return JvmMethodParameterMeaning.typeInfo(new Object());
        }
        PsiType psiType = parameter.getPsiParameter().getType();
        Name name = Name.identifier(parameter.getPsiParameter().getName() != null ? parameter.getPsiParameter().getName() : "p" + i);
        if (parameter.getJetValueParameter().name().length() > 0) {
            name = Name.identifier(parameter.getJetValueParameter().name());
        }
        String typeFromAnnotation = parameter.getJetValueParameter().type();
        boolean receiver = parameter.getJetValueParameter().receiver();
        boolean hasDefaultValue = parameter.getJetValueParameter().hasDefaultValue();
        JetType outType = typeFromAnnotation.length() > 0 ? this.semanticServices.getTypeTransformer().transformToType(typeFromAnnotation, typeVariableResolver) : this.semanticServices.getTypeTransformer().transformToType(psiType, typeVariableResolver);
        if (psiType instanceof PsiEllipsisType) {
            varargElementType = JetStandardLibrary.getInstance().getArrayElementType(TypeUtils.makeNotNullable(outType));
            outType = TypeUtils.makeNotNullable(outType);
        } else {
            varargElementType = null;
        }
        if (receiver) {
            return JvmMethodParameterMeaning.receiver(outType);
        }
        JetType transformedType = parameter.getJetValueParameter().nullable() ? TypeUtils.makeNullableAsSpecified(outType, parameter.getJetValueParameter().nullable()) : (parameter.getPsiParameter().getModifierList().findAnnotation(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().getFqName()) != null ? TypeUtils.makeNullableAsSpecified(outType, false) : outType);
        return JvmMethodParameterMeaning.regular(new ValueParameterDescriptorImpl(containingDeclaration, i, Collections.<AnnotationDescriptor>emptyList(), name, false, transformedType, hasDefaultValue, varargElementType));
    }

    public Set<VariableDescriptor> resolveFieldGroupByName(@NotNull Name fieldName, @NotNull ResolverScopeData scopeData) {
        if (scopeData.psiClass == null) {
            return Collections.emptySet();
        }
        this.getResolverScopeData(scopeData);
        NamedMembers namedMembers = (NamedMembers)scopeData.namedMembersMap.get(fieldName);
        if (namedMembers == null) {
            return Collections.emptySet();
        }
        this.resolveNamedGroupProperties(scopeData.classOrNamespaceDescriptor, scopeData, namedMembers, fieldName, "class or namespace " + scopeData.psiClass.getQualifiedName());
        return namedMembers.propertyDescriptors;
    }

    @NotNull
    public Set<VariableDescriptor> resolveFieldGroup(@NotNull ResolverScopeData scopeData) {
        this.getResolverScopeData(scopeData);
        HashSet<VariableDescriptor> descriptors = Sets.newHashSet();
        Map membersForProperties = scopeData.namedMembersMap;
        for (Map.Entry entry : membersForProperties.entrySet()) {
            NamedMembers namedMembers = (NamedMembers)entry.getValue();
            Name propertyName = (Name)entry.getKey();
            this.resolveNamedGroupProperties(scopeData.classOrNamespaceDescriptor, scopeData, namedMembers, propertyName, "class or namespace " + scopeData.psiClass.getQualifiedName());
            descriptors.addAll(namedMembers.propertyDescriptors);
        }
        return descriptors;
    }

    private Object key(TypeSource typeSource) {
        if (typeSource == null) {
            return "";
        }
        if (typeSource.getTypeString().length() > 0) {
            return typeSource.getTypeString();
        }
        return this.psiTypeToKey(typeSource.getPsiType());
    }

    private Object psiTypeToKey(PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            return ((PsiClassType)psiType).getClassName();
        }
        if (psiType instanceof PsiPrimitiveType) {
            return psiType.getPresentableText();
        }
        if (psiType instanceof PsiArrayType) {
            return Pair.create("[", this.psiTypeToKey(((PsiArrayType)psiType).getComponentType()));
        }
        throw new IllegalStateException("" + psiType.getClass());
    }

    private Object propertyKeyForGrouping(PropertyAccessorData propertyAccessor) {
        Object type = this.key(propertyAccessor.getType());
        Object receiverType = this.key(propertyAccessor.getReceiverType());
        return Pair.create(type, receiverType);
    }

    private void resolveNamedGroupProperties(@NotNull ClassOrNamespaceDescriptor owner, @NotNull ResolverScopeData scopeData, @NotNull NamedMembers namedMembers, @NotNull Name propertyName, @NotNull String context) {
        this.getResolverScopeData(scopeData);
        if (namedMembers.propertyDescriptors != null) {
            return;
        }
        if (namedMembers.propertyAccessors == null) {
            namedMembers.propertyAccessors = Collections.emptyList();
        }
        class GroupingValue {
            PropertyAccessorData getter;
            PropertyAccessorData setter;
            PropertyAccessorData field;
            boolean ext;

            GroupingValue() {
            }
        }
        HashMap<Object, GroupingValue> map = new HashMap<Object, GroupingValue>();
        for (PropertyAccessorData propertyAccessor : namedMembers.propertyAccessors) {
            Object key = this.propertyKeyForGrouping(propertyAccessor);
            GroupingValue value = (GroupingValue)map.get(key);
            if (value == null) {
                value = new GroupingValue();
                value.ext = propertyAccessor.getReceiverType() != null;
                map.put(key, value);
            }
            if (value.ext != (propertyAccessor.getReceiverType() != null)) {
                throw new IllegalStateException("internal error, incorrect key");
            }
            if (propertyAccessor.isGetter()) {
                if (value.getter != null) {
                    throw new IllegalStateException("oops, duplicate key");
                }
                value.getter = propertyAccessor;
                continue;
            }
            if (propertyAccessor.isSetter()) {
                if (value.setter != null) {
                    throw new IllegalStateException("oops, duplicate key");
                }
                value.setter = propertyAccessor;
                continue;
            }
            if (propertyAccessor.isField()) {
                if (value.field != null) {
                    throw new IllegalStateException("oops, duplicate key");
                }
                value.field = propertyAccessor;
                continue;
            }
            throw new IllegalStateException();
        }
        HashSet<PropertyDescriptor> propertiesFromCurrent = new HashSet<PropertyDescriptor>(1);
        int regularProperitesCount = 0;
        for (GroupingValue members : map.values()) {
            if (members.ext) continue;
            ++regularProperitesCount;
        }
        for (GroupingValue members : map.values()) {
            JetType propertyType;
            PsiMethodWrapper method;
            PropertyAccessorData anyMember;
            if (!members.ext && regularProperitesCount > 1) continue;
            boolean isFinal = !scopeData.kotlin ? true : (members.setter == null && members.getter == null ? false : (members.getter != null ? members.getter.getMember().isFinal() : (members.setter != null ? members.setter.getMember().isFinal() : false)));
            if (members.getter != null) {
                anyMember = members.getter;
            } else if (members.field != null) {
                anyMember = members.field;
            } else if (members.setter != null) {
                anyMember = members.setter;
            } else {
                throw new IllegalStateException();
            }
            boolean isVar = members.getter == null && members.setter == null ? !members.field.getMember().isFinal() : members.setter != null;
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(owner, this.resolveAnnotations(anyMember.getMember().psiMember), JavaDescriptorResolver.resolveModality(anyMember.getMember(), isFinal), JavaDescriptorResolver.resolveVisibilityFromPsiModifiers(anyMember.getMember().psiMember), isVar, false, propertyName, CallableMemberDescriptor.Kind.DECLARATION);
            PropertyGetterDescriptor getterDescriptor = null;
            PropertySetterDescriptor setterDescriptor = null;
            if (members.getter != null) {
                getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, this.resolveAnnotations(members.getter.getMember().psiMember), Modality.OPEN, Visibilities.PUBLIC, true, false, CallableMemberDescriptor.Kind.DECLARATION);
            }
            if (members.setter != null) {
                setterDescriptor = new PropertySetterDescriptor(propertyDescriptor, this.resolveAnnotations(members.setter.getMember().psiMember), Modality.OPEN, Visibilities.PUBLIC, true, false, CallableMemberDescriptor.Kind.DECLARATION);
            }
            propertyDescriptor.initialize(getterDescriptor, setterDescriptor);
            List<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(0);
            if (members.setter != null) {
                method = (PsiMethodWrapper)members.setter.getMember();
                if (anyMember == members.setter) {
                    typeParameters = this.resolveMethodTypeParameters(method, propertyDescriptor);
                }
            }
            if (members.getter != null) {
                method = (PsiMethodWrapper)members.getter.getMember();
                if (anyMember == members.getter) {
                    typeParameters = this.resolveMethodTypeParameters(method, propertyDescriptor);
                }
            }
            TypeVariableResolver typeVariableResolverForPropertyInternals = TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, propertyDescriptor, "property " + propertyName + " in " + context);
            if (anyMember.getType().getTypeString().length() > 0) {
                propertyType = this.semanticServices.getTypeTransformer().transformToType(anyMember.getType().getTypeString(), typeVariableResolverForPropertyInternals);
            } else {
                propertyType = this.semanticServices.getTypeTransformer().transformToType(anyMember.getType().getPsiType(), typeVariableResolverForPropertyInternals);
                if (anyMember.getType().getPsiNotNullOwner().getModifierList().findAnnotation(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().getFqName()) != null) {
                    propertyType = TypeUtils.makeNullableAsSpecified(propertyType, false);
                } else if (members.getter == null && members.setter == null && members.field.getMember().isFinal() && members.field.getMember().isStatic()) {
                    propertyType = TypeUtils.makeNotNullable(propertyType);
                }
            }
            JetType receiverType = anyMember.getReceiverType() == null ? null : (anyMember.getReceiverType().getTypeString().length() > 0 ? this.semanticServices.getTypeTransformer().transformToType(anyMember.getReceiverType().getTypeString(), typeVariableResolverForPropertyInternals) : this.semanticServices.getTypeTransformer().transformToType(anyMember.getReceiverType().getPsiType(), typeVariableResolverForPropertyInternals));
            propertyDescriptor.setType(propertyType, typeParameters, DescriptorUtils.getExpectedThisObjectIfNeeded(owner), receiverType);
            if (getterDescriptor != null) {
                getterDescriptor.initialize(propertyType);
            }
            if (setterDescriptor != null) {
                setterDescriptor.initialize(new ValueParameterDescriptorImpl(setterDescriptor, 0, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("p0"), false, propertyDescriptor.getType(), false, null));
            }
            this.trace.record(BindingContext.VARIABLE, anyMember.getMember().psiMember, propertyDescriptor);
            propertiesFromCurrent.add(propertyDescriptor);
        }
        Set<PropertyDescriptor> propertiesFromSupertypes = this.getPropertiesFromSupertypes(scopeData, propertyName);
        final HashSet<VariableDescriptor> properties = Sets.newHashSet();
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            OverrideResolver.generateOverridesInFunctionGroup(propertyName, propertiesFromSupertypes, propertiesFromCurrent, classDescriptor, new OverrideResolver.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    properties.add((PropertyDescriptor)fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
        }
        properties.addAll(propertiesFromCurrent);
        namedMembers.propertyDescriptors = properties;
    }

    private void resolveNamedGroupFunctions(@NotNull ClassOrNamespaceDescriptor owner, PsiClass psiClass, TypeSubstitutor typeSubstitutorForGenericSuperclasses, NamedMembers namedMembers, Name methodName, ResolverScopeData scopeData) {
        if (namedMembers.functionDescriptors != null) {
            return;
        }
        final HashSet<FunctionDescriptor> functions = new HashSet<FunctionDescriptor>();
        HashSet<SimpleFunctionDescriptor> functionsFromCurrent = Sets.newHashSet();
        for (PsiMethodWrapper method : namedMembers.methods) {
            FunctionDescriptorImpl function = this.resolveMethodToFunctionDescriptor(psiClass, method, scopeData);
            if (function == null) continue;
            functionsFromCurrent.add((SimpleFunctionDescriptor)((Object)function));
        }
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            Set<SimpleFunctionDescriptor> functionsFromSupertypes = this.getFunctionsFromSupertypes(scopeData, methodName);
            OverrideResolver.generateOverridesInFunctionGroup(methodName, functionsFromSupertypes, functionsFromCurrent, classDescriptor, new OverrideResolver.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    functions.add((FunctionDescriptor)fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
        }
        functions.addAll(functionsFromCurrent);
        namedMembers.functionDescriptors = functions;
    }

    private Set<SimpleFunctionDescriptor> getFunctionsFromSupertypes(ResolverScopeData scopeData, Name methodName) {
        HashSet<SimpleFunctionDescriptor> r = new HashSet<SimpleFunctionDescriptor>();
        for (JetType supertype : this.getSupertypes(scopeData)) {
            for (FunctionDescriptor function : supertype.getMemberScope().getFunctions(methodName)) {
                r.add((SimpleFunctionDescriptor)function);
            }
        }
        return r;
    }

    private Set<PropertyDescriptor> getPropertiesFromSupertypes(ResolverScopeData scopeData, Name propertyName) {
        HashSet<PropertyDescriptor> r = new HashSet<PropertyDescriptor>();
        for (JetType supertype : this.getSupertypes(scopeData)) {
            for (VariableDescriptor property : supertype.getMemberScope().getProperties(propertyName)) {
                r.add((PropertyDescriptor)property);
            }
        }
        return r;
    }

    private void getResolverScopeData(@NotNull ResolverScopeData scopeData) {
        if (scopeData.namedMembersMap == null) {
            scopeData.namedMembersMap = JavaDescriptorResolverHelper.getNamedMembers(scopeData);
        }
    }

    @NotNull
    public Set<FunctionDescriptor> resolveFunctionGroup(@NotNull Name methodName, @NotNull ResolverScopeData scopeData) {
        this.getResolverScopeData(scopeData);
        Map namedMembersMap = scopeData.namedMembersMap;
        NamedMembers namedMembers = (NamedMembers)namedMembersMap.get(methodName);
        if (namedMembers != null && namedMembers.methods != null) {
            TypeSubstitutor typeSubstitutor = this.typeSubstitutorForGenericSupertypes(scopeData);
            this.resolveNamedGroupFunctions(scopeData.classOrNamespaceDescriptor, scopeData.psiClass, typeSubstitutor, namedMembers, methodName, scopeData);
            return namedMembers.functionDescriptors;
        }
        return Collections.emptySet();
    }

    private TypeSubstitutor createSubstitutorForGenericSupertypes(@Nullable ClassDescriptor classDescriptor) {
        TypeSubstitutor typeSubstitutor = classDescriptor != null ? SubstitutionUtils.buildDeepSubstitutor(classDescriptor.getDefaultType()) : TypeSubstitutor.EMPTY;
        return typeSubstitutor;
    }

    private ValueParameterDescriptors resolveParameterDescriptors(DeclarationDescriptor containingDeclaration, List<PsiParameterWrapper> parameters, TypeVariableResolver typeVariableResolver) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        JetType receiverType = null;
        int indexDelta = 0;
        int parametersLength = parameters.size();
        for (int i = 0; i < parametersLength; ++i) {
            PsiParameterWrapper parameter = parameters.get(i);
            JvmMethodParameterMeaning meaning = this.resolveParameterDescriptor(containingDeclaration, i + indexDelta, parameter, typeVariableResolver);
            if (meaning.kind == JvmMethodParameterKind.TYPE_INFO) {
                --indexDelta;
                continue;
            }
            if (meaning.kind == JvmMethodParameterKind.REGULAR) {
                result.add(meaning.valueParameterDescriptor);
                continue;
            }
            if (meaning.kind != JvmMethodParameterKind.RECEIVER) continue;
            if (receiverType != null) {
                throw new IllegalStateException("more than one receiver");
            }
            --indexDelta;
            receiverType = meaning.receiverType;
        }
        return new ValueParameterDescriptors(receiverType, result);
    }

    @Nullable
    private FunctionDescriptorImpl resolveMethodToFunctionDescriptor(@NotNull PsiClass psiClass, PsiMethodWrapper method, @NotNull ResolverScopeData scopeData) {
        String ownerClassName;
        this.getResolverScopeData(scopeData);
        PsiType returnPsiType = method.getReturnType();
        if (returnPsiType == null) {
            return null;
        }
        if (method.getJetMethod().flags().get(0)) {
            return null;
        }
        if (scopeData.kotlin && (ownerClassName = method.getPsiMethod().getContainingClass().getQualifiedName()).equals("java.lang.Object")) {
            return null;
        }
        SimpleFunctionDescriptorImpl functionDescriptorImpl = new SimpleFunctionDescriptorImpl(scopeData.classOrNamespaceDescriptor, this.resolveAnnotations(method.getPsiMethod()), Name.identifier(method.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        String context = "method " + method.getName() + " in class " + psiClass.getQualifiedName();
        List<TypeParameterDescriptor> methodTypeParameters = this.resolveMethodTypeParameters(method, functionDescriptorImpl);
        TypeVariableResolver methodTypeVariableResolver = TypeVariableResolvers.typeVariableResolverFromTypeParameters(methodTypeParameters, functionDescriptorImpl, context);
        ValueParameterDescriptors valueParameterDescriptors = this.resolveParameterDescriptors(functionDescriptorImpl, method.getParameters(), methodTypeVariableResolver);
        JetType returnType = this.makeReturnType(returnPsiType, method, methodTypeVariableResolver);
        String signature = method.getSignatureAnnotation().signature();
        if (!signature.isEmpty()) {
            try {
                JetNamedFunction altFunDeclaration = JetPsiFactory.createFunction(this.project, signature);
                AlternativeSignatureParsing.checkForSyntaxErrors(method, altFunDeclaration);
                ValueParameterDescriptors altValueParameters = AlternativeSignatureParsing.computeAlternativeValueParameters(valueParameterDescriptors, altFunDeclaration);
                JetTypeReference returnTypeRef = altFunDeclaration.getReturnTypeRef();
                JetType altReturnType = returnTypeRef != null ? AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(returnTypeRef.getTypeElement(), returnType) : returnType;
                List<TypeParameterDescriptor> altTypeParameters = AlternativeSignatureParsing.computeAlternativeTypeParameters(methodTypeParameters, altFunDeclaration);
                valueParameterDescriptors = altValueParameters;
                returnType = altReturnType;
                methodTypeParameters = altTypeParameters;
            }
            catch (AlternativeSignatureMismatchException e) {
                scopeData.addAlternativeSignatureError(e.getMessage());
            }
        }
        functionDescriptorImpl.initialize(valueParameterDescriptors.receiverType, DescriptorUtils.getExpectedThisObjectIfNeeded(scopeData.classOrNamespaceDescriptor), methodTypeParameters, valueParameterDescriptors.descriptors, returnType, JavaDescriptorResolver.resolveModality(method, method.isFinal()), JavaDescriptorResolver.resolveVisibilityFromPsiModifiers(method.getPsiMethod()), false);
        this.trace.record(BindingContext.FUNCTION, method.getPsiMethod(), functionDescriptorImpl);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(this.trace, method.getPsiMethod(), functionDescriptorImpl);
        SimpleFunctionDescriptorImpl substitutedFunctionDescriptor = functionDescriptorImpl;
        if (method.getPsiMethod().getContainingClass() != psiClass && !method.isStatic()) {
            throw new IllegalStateException("non-static method in subclass");
        }
        return substitutedFunctionDescriptor;
    }

    private List<AnnotationDescriptor> resolveAnnotations(PsiModifierListOwner owner, @NotNull List<Runnable> tasks) {
        PsiAnnotation[] psiAnnotations = owner.getModifierList().getAnnotations();
        ArrayList<AnnotationDescriptor> r = Lists.newArrayListWithCapacity(psiAnnotations.length);
        for (PsiAnnotation psiAnnotation : psiAnnotations) {
            AnnotationDescriptor annotation = this.resolveAnnotation(psiAnnotation, tasks);
            if (annotation == null) continue;
            r.add(annotation);
        }
        return r;
    }

    private List<AnnotationDescriptor> resolveAnnotations(PsiModifierListOwner owner) {
        ArrayList<Runnable> tasks = Lists.newArrayList();
        List<AnnotationDescriptor> annotations = this.resolveAnnotations(owner, tasks);
        for (Runnable task : tasks) {
            task.run();
        }
        return annotations;
    }

    @Nullable
    private AnnotationDescriptor resolveAnnotation(PsiAnnotation psiAnnotation, @NotNull List<Runnable> taskList) {
        final AnnotationDescriptor annotation = new AnnotationDescriptor();
        String qname = psiAnnotation.getQualifiedName();
        if (qname.startsWith("java.lang.annotation.") || qname.startsWith("jet.runtime.typeinfo.") || qname.equals(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().getFqName())) {
            return null;
        }
        final ClassDescriptor clazz = this.resolveClass(new FqName(psiAnnotation.getQualifiedName()), DescriptorSearchRule.INCLUDE_KOTLIN, taskList);
        if (clazz == null) {
            return null;
        }
        taskList.add(new Runnable(){

            @Override
            public void run() {
                annotation.setAnnotationType(clazz.getDefaultType());
            }
        });
        ArrayList valueArguments = new ArrayList();
        PsiAnnotationParameterList parameterList = psiAnnotation.getParameterList();
        for (PsiNameValuePair psiNameValuePair : parameterList.getAttributes()) {
            PsiAnnotationMemberValue value = psiNameValuePair.getValue();
            if (!(value instanceof PsiLiteralExpression)) continue;
            Object literalValue = ((PsiLiteralExpression)value).getValue();
            if (literalValue instanceof String) {
                valueArguments.add(new StringValue((String)literalValue));
                continue;
            }
            if (literalValue instanceof Byte) {
                valueArguments.add(new ByteValue((Byte)literalValue));
                continue;
            }
            if (literalValue instanceof Short) {
                valueArguments.add(new ShortValue((Short)literalValue));
                continue;
            }
            if (literalValue instanceof Character) {
                valueArguments.add(new CharValue(((Character)literalValue).charValue()));
                continue;
            }
            if (literalValue instanceof Integer) {
                valueArguments.add(new IntValue((Integer)literalValue));
                continue;
            }
            if (literalValue instanceof Long) {
                valueArguments.add(new LongValue((Long)literalValue));
                continue;
            }
            if (literalValue instanceof Float) {
                valueArguments.add(new FloatValue(((Float)literalValue).floatValue()));
                continue;
            }
            if (literalValue instanceof Double) {
                valueArguments.add(new DoubleValue((Double)literalValue));
                continue;
            }
            if (literalValue != null) continue;
            valueArguments.add(NullValue.NULL);
        }
        annotation.setValueArguments(valueArguments);
        return annotation;
    }

    public List<FunctionDescriptor> resolveMethods(@NotNull ResolverScopeData scopeData) {
        this.getResolverScopeData(scopeData);
        TypeSubstitutor substitutorForGenericSupertypes = this.typeSubstitutorForGenericSupertypes(scopeData);
        ArrayList<FunctionDescriptor> functions = new ArrayList<FunctionDescriptor>();
        for (Map.Entry entry : scopeData.namedMembersMap.entrySet()) {
            Name methodName = (Name)entry.getKey();
            NamedMembers namedMembers = (NamedMembers)entry.getValue();
            this.resolveNamedGroupFunctions(scopeData.classOrNamespaceDescriptor, scopeData.psiClass, substitutorForGenericSupertypes, namedMembers, methodName, scopeData);
            functions.addAll(namedMembers.functionDescriptors);
        }
        return functions;
    }

    private Collection<JetType> getSupertypes(ResolverScopeData scope) {
        if (scope instanceof ResolverBinaryClassData) {
            return ((ResolverBinaryClassData)scope).classDescriptor.getSupertypes();
        }
        if (scope instanceof ResolverNamespaceData) {
            return Collections.emptyList();
        }
        throw new IllegalStateException();
    }

    private TypeSubstitutor typeSubstitutorForGenericSupertypes(ResolverScopeData scopeData) {
        if (scopeData instanceof ResolverBinaryClassData) {
            return this.createSubstitutorForGenericSupertypes(((ResolverBinaryClassData)scopeData).getClassDescriptor());
        }
        return TypeSubstitutor.EMPTY;
    }

    private List<TypeParameterDescriptor> resolveMethodTypeParameters(@NotNull PsiMethodWrapper method, @NotNull DeclarationDescriptor functionDescriptor) {
        List<TypeParameterDescriptorInitialization> typeParametersIntialization = method.getJetMethod().typeParameters().length() > 0 ? this.resolveMethodTypeParametersFromJetSignature(method.getJetMethod().typeParameters(), method.getPsiMethod(), functionDescriptor) : this.makeUninitializedTypeParameters(functionDescriptor, method.getPsiMethod().getTypeParameters());
        String context = "method " + method.getName() + " in class " + method.getPsiMethod().getContainingClass().getQualifiedName();
        this.initializeTypeParameters(typeParametersIntialization, functionDescriptor, context);
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayListWithCapacity(typeParametersIntialization.size());
        for (TypeParameterDescriptorInitialization tpdi : typeParametersIntialization) {
            typeParameters.add(tpdi.descriptor);
        }
        return typeParameters;
    }

    private List<TypeParameterDescriptorInitialization> resolveMethodTypeParametersFromJetSignature(String jetSignature, PsiMethod method, DeclarationDescriptor functionDescriptor) {
        String context = "method " + method.getName() + " in class " + method.getContainingClass().getQualifiedName();
        JetSignatureTypeParametersVisitor jetSignatureTypeParametersVisitor = new JetSignatureTypeParametersVisitor(functionDescriptor, method, context);
        new JetSignatureReader(jetSignature).acceptFormalTypeParametersOnly(jetSignatureTypeParametersVisitor);
        return jetSignatureTypeParametersVisitor.r;
    }

    private JetType makeReturnType(PsiType returnType, PsiMethodWrapper method, @NotNull TypeVariableResolver typeVariableResolver) {
        String returnTypeFromAnnotation = method.getJetMethod().returnType();
        JetType transformedType = returnTypeFromAnnotation.length() > 0 ? this.semanticServices.getTypeTransformer().transformToType(returnTypeFromAnnotation, typeVariableResolver) : this.semanticServices.getTypeTransformer().transformToType(returnType, typeVariableResolver);
        if (method.getJetMethod().returnTypeNullable()) {
            return TypeUtils.makeNullableAsSpecified(transformedType, true);
        }
        if (method.getPsiMethod().getModifierList().findAnnotation(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().getFqName()) != null) {
            return TypeUtils.makeNullableAsSpecified(transformedType, false);
        }
        return transformedType;
    }

    private static Modality resolveModality(PsiMemberWrapper memberWrapper, boolean isFinal) {
        if (memberWrapper instanceof PsiMethodWrapper) {
            PsiMethodWrapper method = (PsiMethodWrapper)memberWrapper;
            if (method.getJetMethod().flags().get(1)) {
                return Modality.OPEN;
            }
            if (method.getJetMethod().flags().get(2)) {
                return Modality.FINAL;
            }
        }
        return Modality.convertFromFlags(memberWrapper.isAbstract(), !isFinal);
    }

    private static Visibility resolveVisibilityFromPsiModifiers(PsiModifierListOwner modifierListOwner) {
        return modifierListOwner.hasModifierProperty("public") ? Visibilities.PUBLIC : (modifierListOwner.hasModifierProperty("private") ? Visibilities.PRIVATE : (modifierListOwner.hasModifierProperty("protected") ? Visibilities.PROTECTED : PACKAGE_VISIBILITY));
    }

    public List<ClassDescriptor> resolveInnerClasses(DeclarationDescriptor owner, PsiClass psiClass, boolean staticMembers) {
        if (staticMembers) {
            return new ArrayList<ClassDescriptor>(0);
        }
        PsiClass[] innerPsiClasses = psiClass.getInnerClasses();
        ArrayList<ClassDescriptor> r = new ArrayList<ClassDescriptor>(innerPsiClasses.length);
        for (PsiClass innerPsiClass : innerPsiClasses) {
            if (innerPsiClass.hasModifierProperty("private") || innerPsiClass.getName().equals("ClassObject$")) continue;
            r.add(this.resolveClass(new FqName(innerPsiClass.getQualifiedName()), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN));
        }
        return r;
    }

    private static class JvmMethodParameterMeaning {
        private final JvmMethodParameterKind kind;
        private final JetType receiverType;
        private final ValueParameterDescriptor valueParameterDescriptor;
        private final Object typeInfo;

        private JvmMethodParameterMeaning(JvmMethodParameterKind kind, JetType receiverType, ValueParameterDescriptor valueParameterDescriptor, Object typeInfo) {
            this.kind = kind;
            this.receiverType = receiverType;
            this.valueParameterDescriptor = valueParameterDescriptor;
            this.typeInfo = typeInfo;
        }

        public static JvmMethodParameterMeaning receiver(@NotNull JetType receiverType) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.RECEIVER, receiverType, null, null);
        }

        public static JvmMethodParameterMeaning regular(@NotNull ValueParameterDescriptor valueParameterDescriptor) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.REGULAR, null, valueParameterDescriptor, null);
        }

        public static JvmMethodParameterMeaning typeInfo(@NotNull Object typeInfo) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.TYPE_INFO, null, null, typeInfo);
        }
    }

    private static enum JvmMethodParameterKind {
        REGULAR,
        RECEIVER,
        TYPE_INFO;

    }

    static class ValueParameterDescriptors {
        final JetType receiverType;
        final List<ValueParameterDescriptor> descriptors;

        ValueParameterDescriptors(@Nullable JetType receiverType, List<ValueParameterDescriptor> descriptors) {
            this.receiverType = receiverType;
            this.descriptors = descriptors;
        }
    }

    private class JetSignatureTypeParametersVisitor
    extends JetSignatureExceptionsAdapter {
        @NotNull
        private final DeclarationDescriptor containingDeclaration;
        @NotNull
        private final PsiTypeParameterListOwner psiOwner;
        private final List<TypeParameterDescriptor> previousTypeParameters = new ArrayList<TypeParameterDescriptor>();
        private final TypeVariableResolver typeVariableResolver;
        private int formalTypeParameterIndex = 0;
        List<TypeParameterDescriptorInitialization> r = new ArrayList<TypeParameterDescriptorInitialization>();

        private JetSignatureTypeParametersVisitor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameterListOwner psiOwner, @NotNull String context) {
            this.containingDeclaration = containingDeclaration;
            this.psiOwner = psiOwner;
            this.typeVariableResolver = TypeVariableResolvers.typeVariableResolverFromTypeParameters(this.previousTypeParameters, containingDeclaration, context);
        }

        @Override
        public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
            TypeParameterDescriptorImpl typeParameter = TypeParameterDescriptorImpl.createForFurtherModification(this.containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), reified, JetSignatureUtils.translateVariance(variance), Name.identifier(name), this.formalTypeParameterIndex++);
            this.previousTypeParameters.add(typeParameter);
            return new JetSignatureTypeParameterVisitor(this.psiOwner, name, this.typeVariableResolver, typeParameter){

                @Override
                protected void done(@NotNull TypeParameterDescriptorInitialization typeParameterDescriptor) {
                    JetSignatureTypeParametersVisitor.this.r.add(typeParameterDescriptor);
                    JetSignatureTypeParametersVisitor.this.previousTypeParameters.add(typeParameterDescriptor.descriptor);
                }
            };
        }
    }

    private abstract class JetSignatureTypeParameterVisitor
    extends JetSignatureExceptionsAdapter {
        @NotNull
        private final PsiTypeParameterListOwner psiOwner;
        @NotNull
        private final String name;
        @NotNull
        private final TypeVariableResolver typeVariableResolver;
        @NotNull
        private final TypeParameterDescriptorImpl typeParameterDescriptor;
        List<JetType> upperBounds = new ArrayList<JetType>();
        List<JetType> lowerBounds = new ArrayList<JetType>();

        protected JetSignatureTypeParameterVisitor(PsiTypeParameterListOwner psiOwner, String name, TypeVariableResolver typeVariableResolver, TypeParameterDescriptorImpl typeParameterDescriptor) {
            if (name.isEmpty()) {
                throw new IllegalStateException();
            }
            this.psiOwner = psiOwner;
            this.name = name;
            this.typeVariableResolver = typeVariableResolver;
            this.typeParameterDescriptor = typeParameterDescriptor;
        }

        @Override
        public JetSignatureVisitor visitClassBound() {
            return new JetTypeJetSignatureReader(JavaDescriptorResolver.this.semanticServices, JetStandardLibrary.getInstance(), this.typeVariableResolver){

                @Override
                protected void done(@NotNull JetType jetType) {
                    if (JavaDescriptorResolver.this.isJavaLangObject(jetType)) {
                        return;
                    }
                    JetSignatureTypeParameterVisitor.this.upperBounds.add(jetType);
                }
            };
        }

        @Override
        public JetSignatureVisitor visitInterfaceBound() {
            return new JetTypeJetSignatureReader(JavaDescriptorResolver.this.semanticServices, JetStandardLibrary.getInstance(), this.typeVariableResolver){

                @Override
                protected void done(@NotNull JetType jetType) {
                    JetSignatureTypeParameterVisitor.this.upperBounds.add(jetType);
                }
            };
        }

        @Override
        public void visitFormalTypeParameterEnd() {
            PsiTypeParameter psiTypeParameter = JavaDescriptorResolver.this.getPsiTypeParameterByName(this.psiOwner, this.name);
            TypeParameterDescriptorInitialization typeParameterDescriptorInitialization = new TypeParameterDescriptorInitialization(this.typeParameterDescriptor, psiTypeParameter, this.upperBounds, this.lowerBounds);
            this.done(typeParameterDescriptorInitialization);
        }

        protected abstract void done(@NotNull TypeParameterDescriptorInitialization var1);
    }

    static class ResolverNamespaceData
    extends ResolverScopeData {
        private final NamespaceDescriptor namespaceDescriptor;
        static final ResolverNamespaceData NEGATIVE = new ResolverNamespaceData(true);
        private JavaPackageScope memberScope;

        ResolverNamespaceData(@Nullable PsiClass psiClass, @Nullable PsiPackage psiPackage, @NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor) {
            super(psiClass, psiPackage, fqName, true, namespaceDescriptor);
            this.namespaceDescriptor = namespaceDescriptor;
        }

        private ResolverNamespaceData(boolean negative) {
            super(negative);
            this.namespaceDescriptor = null;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return new ArrayList<TypeParameterDescriptor>(0);
        }
    }

    static class ResolverBinaryClassData
    extends ResolverScopeData {
        private final MutableClassDescriptorLite classDescriptor;
        static final ResolverBinaryClassData NEGATIVE = new ResolverBinaryClassData(true);
        List<TypeParameterDescriptorInitialization> typeParameters;

        ResolverBinaryClassData(@NotNull PsiClass psiClass, @NotNull FqName fqName, @NotNull MutableClassDescriptorLite classDescriptor) {
            super(psiClass, null, fqName, false, classDescriptor);
            this.classDescriptor = classDescriptor;
        }

        private ResolverBinaryClassData(boolean negative) {
            super(negative);
            this.classDescriptor = null;
        }

        @NotNull
        public ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return this.getClassDescriptor().getTypeConstructor().getParameters();
        }
    }

    static abstract class ResolverScopeData {
        @Nullable
        final PsiClass psiClass;
        @Nullable
        final PsiPackage psiPackage;
        final FqName fqName;
        final boolean staticMembers;
        final boolean kotlin;
        final ClassOrNamespaceDescriptor classOrNamespaceDescriptor;
        private List<String> alternativeSignatureErrors;
        private Map<Name, NamedMembers> namedMembersMap;

        protected ResolverScopeData(@Nullable PsiClass psiClass, @Nullable PsiPackage psiPackage, @NotNull FqName fqName, boolean staticMembers, @NotNull ClassOrNamespaceDescriptor descriptor) {
            JavaDescriptorResolver.checkPsiClassIsNotJet(psiClass);
            this.psiClass = psiClass;
            this.psiPackage = psiPackage;
            this.fqName = fqName;
            if (psiClass == null && psiPackage == null) {
                throw new IllegalStateException("both psiClass and psiPackage cannot be null");
            }
            this.staticMembers = staticMembers;
            this.kotlin = psiClass != null && (new PsiClassWrapper(psiClass).getJetClass().isDefined() || psiClass.getName().equals("namespace"));
            this.classOrNamespaceDescriptor = descriptor;
            if (fqName.lastSegmentIs(Name.identifier("namespace")) && psiClass != null && this.kotlin) {
                throw new IllegalStateException("Kotlin namespace cannot have last segment namespace: " + fqName);
            }
        }

        protected ResolverScopeData(boolean negative) {
            if (!negative) {
                throw new IllegalStateException();
            }
            this.psiClass = null;
            this.psiPackage = null;
            this.fqName = null;
            this.staticMembers = false;
            this.kotlin = false;
            this.classOrNamespaceDescriptor = null;
        }

        public boolean isPositive() {
            return this.classOrNamespaceDescriptor != null;
        }

        @NotNull
        public PsiElement getPsiPackageOrPsiClass() {
            if (this.psiPackage != null) {
                return this.psiPackage;
            }
            return this.psiClass;
        }

        public void addAlternativeSignatureError(@NotNull String errorMessage) {
            if (this.alternativeSignatureErrors == null) {
                this.alternativeSignatureErrors = new ArrayList<String>();
            }
            this.alternativeSignatureErrors.add(errorMessage);
        }

        @NotNull
        public abstract List<TypeParameterDescriptor> getTypeParameters();
    }

    public static class TypeParameterDescriptorInitialization {
        @NotNull
        private final TypeParameterDescriptorOrigin origin;
        @NotNull
        final TypeParameterDescriptorImpl descriptor;
        final PsiTypeParameter psiTypeParameter;
        @Nullable
        private final List<JetType> upperBoundsForKotlin;
        @Nullable
        private final List<JetType> lowerBoundsForKotlin;

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptorImpl descriptor, @NotNull PsiTypeParameter psiTypeParameter) {
            this.origin = TypeParameterDescriptorOrigin.JAVA;
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
            this.upperBoundsForKotlin = null;
            this.lowerBoundsForKotlin = null;
        }

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptorImpl descriptor, @NotNull PsiTypeParameter psiTypeParameter, List<JetType> upperBoundsForKotlin, List<JetType> lowerBoundsForKotlin) {
            this.origin = TypeParameterDescriptorOrigin.KOTLIN;
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
            this.upperBoundsForKotlin = upperBoundsForKotlin;
            this.lowerBoundsForKotlin = lowerBoundsForKotlin;
        }
    }

    private static enum TypeParameterDescriptorOrigin {
        JAVA,
        KOTLIN;

    }
}

