/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;

public abstract class JavaClassOrPackageScope
extends JetScopeImpl {
    @NotNull
    protected final JavaSemanticServices semanticServices;
    @NotNull
    protected final JavaDescriptorResolver.ResolverScopeData resolverScopeData;
    private Collection<DeclarationDescriptor> allDescriptors;

    protected JavaClassOrPackageScope(@NotNull JavaSemanticServices semanticServices, @NotNull JavaDescriptorResolver.ResolverScopeData resolverScopeData) {
        this.semanticServices = semanticServices;
        this.resolverScopeData = resolverScopeData;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.resolverScopeData.classOrNamespaceDescriptor;
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        return this.semanticServices.getDescriptorResolver().resolveFieldGroupByName(name, this.resolverScopeData);
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        return this.semanticServices.getDescriptorResolver().resolveFunctionGroup(name, this.resolverScopeData);
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            if (this.resolverScopeData.psiClass != null) {
                this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveMethods(this.resolverScopeData));
                this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveFieldGroup(this.resolverScopeData));
                if (this.getContainingDeclaration() instanceof JavaNamespaceDescriptor) {
                    this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveInnerClasses(this.resolverScopeData.classOrNamespaceDescriptor, this.resolverScopeData.psiClass, false));
                } else {
                    this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveInnerClasses(this.resolverScopeData.classOrNamespaceDescriptor, this.resolverScopeData.psiClass, this.resolverScopeData.staticMembers));
                }
            }
            if (this.resolverScopeData.psiPackage != null) {
                boolean isKotlinNamespace = this.semanticServices.getKotlinNamespaceDescriptor(this.resolverScopeData.fqName) != null;
                JavaDescriptorResolver descriptorResolver = this.semanticServices.getDescriptorResolver();
                for (PsiPackage psiPackage : this.resolverScopeData.psiPackage.getSubPackages()) {
                    NamespaceDescriptor childNs = descriptorResolver.resolveNamespace(new FqName(psiPackage.getQualifiedName()), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
                    if (childNs == null) continue;
                    this.allDescriptors.add(childNs);
                }
                for (PsiModifierListOwner psiModifierListOwner : this.resolverScopeData.psiPackage.getClasses()) {
                    ClassDescriptor classDescriptor;
                    if (isKotlinNamespace && "namespace".equals(psiModifierListOwner.getName()) || psiModifierListOwner instanceof JetJavaMirrorMarker || "namespace".equals(psiModifierListOwner.getName()) || !psiModifierListOwner.hasModifierProperty("public") || (classDescriptor = descriptorResolver.resolveClass(new FqName(psiModifierListOwner.getQualifiedName()), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN)) == null) continue;
                    this.allDescriptors.add(classDescriptor);
                }
            }
        }
        return this.allDescriptors;
    }
}

