/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaClassOrPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class JavaClassMembersScope
extends JavaClassOrPackageScope {
    private final Map<Name, ClassifierDescriptor> classifiers = Maps.newHashMap();

    public JavaClassMembersScope(@NotNull JavaSemanticServices semanticServices, @NotNull JavaDescriptorResolver.ResolverScopeData resolverScopeData) {
        super(semanticServices, resolverScopeData);
        if (resolverScopeData.psiClass == null) {
            throw new IllegalArgumentException("must pass PsiClass here");
        }
        if (resolverScopeData.staticMembers) {
            throw new IllegalArgumentException("static members should be resolved using " + JavaPackageScope.class);
        }
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassifierDescriptor classifierDescriptor = this.classifiers.get(name);
        if (classifierDescriptor == null) {
            classifierDescriptor = this.doGetClassifierDescriptor(name);
            this.classifiers.put(name, classifierDescriptor);
        }
        return classifierDescriptor;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        return Collections.emptySet();
    }

    private ClassifierDescriptor doGetClassifierDescriptor(Name name) {
        for (PsiClass innerClass : this.resolverScopeData.psiClass.getAllInnerClasses()) {
            if (!name.getName().equals(innerClass.getName())) continue;
            if (innerClass.hasModifierProperty("static") != this.resolverScopeData.staticMembers) {
                return null;
            }
            ClassDescriptor classDescriptor = this.semanticServices.getDescriptorResolver().resolveClass(new FqName(innerClass.getQualifiedName()), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
            if (classDescriptor == null) continue;
            return classDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        return ReceiverDescriptor.NO_RECEIVER;
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
    }
}

