/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.DefaultModuleConfiguration;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.java.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class JavaBridgeConfiguration
implements ModuleConfiguration {
    public static final ImportPath[] DEFAULT_JAVA_IMPORTS = new ImportPath[]{new ImportPath("java.lang.*")};
    @NotNull
    private Project project;
    @NotNull
    private JavaSemanticServices javaSemanticServices;
    @NotNull
    private ModuleConfiguration delegateConfiguration;
    @NotNull
    private CompilerSpecialMode mode;

    @Inject
    public void setProject(@NotNull Project project) {
        this.project = project;
    }

    @Inject
    public void setJavaSemanticServices(@NotNull JavaSemanticServices javaSemanticServices) {
        this.javaSemanticServices = javaSemanticServices;
    }

    @Inject
    public void setMode(@NotNull CompilerSpecialMode mode) {
        this.mode = mode;
    }

    @PostConstruct
    public void init() {
        this.delegateConfiguration = DefaultModuleConfiguration.createStandardConfiguration(this.project, this.mode == CompilerSpecialMode.BUILTINS);
    }

    @Override
    public void addDefaultImports(@NotNull Collection<JetImportDirective> directives) {
        for (ImportPath importPath : DEFAULT_JAVA_IMPORTS) {
            directives.add(JetPsiFactory.createImportDirective(this.project, importPath));
        }
        this.delegateConfiguration.addDefaultImports(directives);
    }

    @Override
    public void extendNamespaceScope(@NotNull BindingTrace trace, @NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
        JavaPackageScope javaPackageScope = this.javaSemanticServices.getDescriptorResolver().getJavaPackageScope(DescriptorUtils.getFQName(namespaceDescriptor).toSafe(), namespaceDescriptor);
        if (javaPackageScope != null) {
            namespaceMemberScope.importScope(javaPackageScope);
        }
        this.delegateConfiguration.extendNamespaceScope(trace, namespaceDescriptor, namespaceMemberScope);
    }
}

