/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.utils.PathUtil;

public class CompilerDependencies {
    @NotNull
    private final CompilerSpecialMode compilerSpecialMode;
    @Nullable
    private final File jdkJar;
    @Nullable
    private final File jdkHeadersJar;
    @Nullable
    private final File runtimeJar;

    public CompilerDependencies(@NotNull CompilerSpecialMode compilerSpecialMode, @Nullable File jdkJar, @Nullable File jdkHeadersJar, @Nullable File runtimeJar) {
        this.compilerSpecialMode = compilerSpecialMode;
        this.jdkJar = jdkJar;
        this.jdkHeadersJar = jdkHeadersJar;
        this.runtimeJar = runtimeJar;
        if (compilerSpecialMode.includeJdk() && jdkJar == null) {
            throw new IllegalArgumentException("jdk must be included for mode " + (Object)((Object)compilerSpecialMode));
        }
        if (compilerSpecialMode.includeJdkHeaders() && jdkHeadersJar == null) {
            throw new IllegalArgumentException("jdkHeaders must be included for mode " + (Object)((Object)compilerSpecialMode));
        }
        if (compilerSpecialMode.includeKotlinRuntime() && runtimeJar == null) {
            throw new IllegalArgumentException("runtime must be include for mode " + (Object)((Object)compilerSpecialMode));
        }
    }

    @NotNull
    public CompilerSpecialMode getCompilerSpecialMode() {
        return this.compilerSpecialMode;
    }

    @Nullable
    public File getJdkJar() {
        return this.jdkJar;
    }

    @Nullable
    public File getJdkHeadersJar() {
        return this.jdkHeadersJar;
    }

    @Nullable
    public File getRuntimeJar() {
        return this.runtimeJar;
    }

    @NotNull
    public List<VirtualFile> getJdkHeaderRoots() {
        if (this.compilerSpecialMode.includeJdkHeaders()) {
            return Collections.singletonList(PathUtil.jarFileOrDirectoryToVirtualFile(this.jdkHeadersJar));
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<VirtualFile> getRuntimeRoots() {
        if (this.compilerSpecialMode.includeKotlinRuntime()) {
            return Collections.singletonList(PathUtil.jarFileOrDirectoryToVirtualFile(this.runtimeJar));
        }
        return Collections.emptyList();
    }

    @NotNull
    public static CompilerDependencies compilerDependenciesForProduction(@NotNull CompilerSpecialMode compilerSpecialMode) {
        return new CompilerDependencies(compilerSpecialMode, compilerSpecialMode.includeJdk() ? CompilerDependencies.findRtJar() : null, compilerSpecialMode.includeJdkHeaders() ? PathUtil.getAltHeadersPath() : null, compilerSpecialMode.includeKotlinRuntime() ? PathUtil.getDefaultRuntimePath() : null);
    }

    public static File findRtJar() {
        File rtJar;
        String javaHome = System.getProperty("java.home");
        if ("jre".equals(new File(javaHome).getName())) {
            javaHome = new File(javaHome).getParent();
        }
        if ((rtJar = CompilerDependencies.findRtJar(javaHome)) == null || !rtJar.exists()) {
            throw new IllegalArgumentException("No JDK rt.jar found under " + javaHome);
        }
        return rtJar;
    }

    private static File findRtJar(String javaHome) {
        File rtJar = new File(javaHome, "jre/lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        File classesJar = new File(new File(javaHome).getParentFile().getAbsolutePath(), "Classes/classes.jar");
        if (classesJar.exists()) {
            return classesJar;
        }
        return null;
    }
}

