/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.analyzer.AnalyzerFacade;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.base.Predicates;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.CachedBodiesResolveContext;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public final class AnalyzerFacadeForJVM
extends Enum<AnalyzerFacadeForJVM>
implements AnalyzerFacade {
    public static final /* enum */ AnalyzerFacadeForJVM INSTANCE = new AnalyzerFacadeForJVM();
    private static final /* synthetic */ AnalyzerFacadeForJVM[] $VALUES;

    public static AnalyzerFacadeForJVM[] values() {
        return (AnalyzerFacadeForJVM[])$VALUES.clone();
    }

    public static AnalyzerFacadeForJVM valueOf(String name) {
        return Enum.valueOf(AnalyzerFacadeForJVM.class, name);
    }

    @Override
    @NotNull
    public AnalyzeExhaust analyzeFiles(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull List<AnalyzerScriptParameter> scriptParameters, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely) {
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, CompilerDependencies.compilerDependenciesForProduction(CompilerSpecialMode.REGULAR), true);
    }

    @Override
    @NotNull
    public AnalyzeExhaust analyzeBodiesInFiles(@NotNull Project project, @NotNull List<AnalyzerScriptParameter> scriptParameters, @NotNull Predicate<PsiFile> filesForBodiesResolve, @NotNull BindingTrace headersTraceContext, @NotNull BodiesResolveContext bodiesResolveContext) {
        return AnalyzerFacadeForJVM.analyzeBodiesInFilesWithJavaIntegration(project, scriptParameters, filesForBodiesResolve, CompilerDependencies.compilerDependenciesForProduction(CompilerSpecialMode.REGULAR), headersTraceContext, bodiesResolveContext);
    }

    public static AnalyzeExhaust analyzeOneFileWithJavaIntegrationAndCheckForErrors(JetFile file, List<AnalyzerScriptParameter> scriptParameters, @NotNull CompilerDependencies compilerDependencies) {
        AnalyzingUtils.checkForSyntacticErrors(file);
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeOneFileWithJavaIntegration(file, scriptParameters, compilerDependencies);
        AnalyzingUtils.throwExceptionOnErrors(analyzeExhaust.getBindingContext());
        return analyzeExhaust;
    }

    public static AnalyzeExhaust analyzeOneFileWithJavaIntegration(JetFile file, List<AnalyzerScriptParameter> scriptParameters, @NotNull CompilerDependencies compilerDependencies) {
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(file.getProject(), Collections.singleton(file), scriptParameters, Predicates.<PsiFile>alwaysTrue(), compilerDependencies);
    }

    public static AnalyzeExhaust analyzeFilesWithJavaIntegrationAndCheckForErrors(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull CompilerDependencies compilerDependencies) {
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, compilerDependencies, false);
        AnalyzingUtils.throwExceptionOnErrors(analyzeExhaust.getBindingContext());
        return analyzeExhaust;
    }

    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull CompilerDependencies compilerDependencies) {
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, compilerDependencies, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull CompilerDependencies compilerDependencies, boolean storeContextForBodiesResolve) {
        BindingTraceContext bindingTraceContext = new BindingTraceContext();
        ModuleDescriptor owner = new ModuleDescriptor(Name.special("<module>"));
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(filesToAnalyzeCompletely, false, false, scriptParameters);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, new ObservableBindingTrace(bindingTraceContext), owner, compilerDependencies);
        try {
            injector.getTopDownAnalyzer().analyzeFiles(files, scriptParameters);
            CachedBodiesResolveContext bodiesResolveContext = storeContextForBodiesResolve ? new CachedBodiesResolveContext(injector.getTopDownAnalysisContext()) : null;
            AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(bindingTraceContext.getBindingContext(), JetStandardLibrary.getInstance(), bodiesResolveContext);
            return analyzeExhaust;
        }
        finally {
            injector.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyzeExhaust analyzeBodiesInFilesWithJavaIntegration(Project project, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull CompilerDependencies compilerDependencies, @NotNull BindingTrace traceContext, @NotNull BodiesResolveContext bodiesResolveContext) {
        ModuleDescriptor owner = new ModuleDescriptor(Name.special("<module>"));
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(filesToAnalyzeCompletely, false, false, scriptParameters);
        bodiesResolveContext.setTopDownAnalysisParameters(topDownAnalysisParameters);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, new ObservableBindingTrace(traceContext), owner, compilerDependencies);
        try {
            injector.getTopDownAnalyzer().doProcessForBodies(bodiesResolveContext);
            AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(traceContext.getBindingContext(), JetStandardLibrary.getInstance());
            return analyzeExhaust;
        }
        finally {
            injector.destroy();
        }
    }

    public static AnalyzeExhaust shallowAnalyzeFiles(Collection<JetFile> files, @NotNull CompilerSpecialMode compilerSpecialMode, @NotNull CompilerDependencies compilerDependencies) {
        assert (files.size() > 0);
        Project project = files.iterator().next().getProject();
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, Collections.<AnalyzerScriptParameter>emptyList(), Predicates.<PsiFile>alwaysFalse(), compilerDependencies);
    }

    static {
        $VALUES = new AnalyzerFacadeForJVM[]{INSTANCE};
    }
}

