/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiErrorElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetSelfType;
import org.jetbrains.jet.lang.psi.JetTupleType;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.java.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

class AlternativeSignatureParsing {
    AlternativeSignatureParsing() {
    }

    static JetType computeAlternativeTypeFromAnnotation(JetTypeElement alternativeTypeElement, final JetType autoType) throws AlternativeSignatureMismatchException {
        final Ref exception = new Ref();
        JetType result = alternativeTypeElement.accept(new JetVisitor<JetType, Void>(){

            @Override
            public JetType visitNullableType(JetNullableType nullableType, Void data) {
                try {
                    return TypeUtils.makeNullable(AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(nullableType.getInnerType(), autoType));
                }
                catch (AlternativeSignatureMismatchException e) {
                    exception.set(e);
                    return null;
                }
            }

            @Override
            public JetType visitFunctionType(JetFunctionType type, Void data) {
                return this.visitCommonType(type);
            }

            @Override
            public JetType visitTupleType(JetTupleType type, Void data) {
                return this.visitCommonType(type);
            }

            @Override
            public JetType visitUserType(JetUserType type, Void data) {
                return this.visitCommonType(type);
            }

            private JetType visitCommonType(JetTypeElement type) {
                try {
                    List<TypeProjection> arguments = autoType.getArguments();
                    ArrayList<TypeProjection> altArguments = new ArrayList<TypeProjection>();
                    int size = arguments.size();
                    for (int i = 0; i < size; ++i) {
                        JetTypeElement argumentAlternativeTypeElement = type.getTypeArgumentsAsTypes().get(i).getTypeElement();
                        TypeProjection argument = arguments.get(i);
                        JetType alternativeType = AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(argumentAlternativeTypeElement, argument.getType());
                        altArguments.add(new TypeProjection(argument.getProjectionKind(), alternativeType));
                    }
                    return new JetTypeImpl(autoType.getAnnotations(), autoType.getConstructor(), false, altArguments, autoType.getMemberScope());
                }
                catch (AlternativeSignatureMismatchException e) {
                    exception.set(e);
                    return null;
                }
            }

            @Override
            public JetType visitSelfType(JetSelfType type, Void data) {
                throw new UnsupportedOperationException("Self-types are not supported yet");
            }
        }, null);
        if (exception.get() != null) {
            throw (AlternativeSignatureMismatchException)exception.get();
        }
        return result;
    }

    static JavaDescriptorResolver.ValueParameterDescriptors computeAlternativeValueParameters(JavaDescriptorResolver.ValueParameterDescriptors valueParameterDescriptors, JetNamedFunction altFunDeclaration) throws AlternativeSignatureMismatchException {
        List<ValueParameterDescriptor> parameterDescriptors = valueParameterDescriptors.descriptors;
        ArrayList<ValueParameterDescriptor> altParamDescriptors = new ArrayList<ValueParameterDescriptor>();
        int size = parameterDescriptors.size();
        for (int i = 0; i < size; ++i) {
            JetType alternativeVarargElementType;
            JetType alternativeType;
            ValueParameterDescriptor pd = parameterDescriptors.get(i);
            JetTypeElement alternativeTypeElement = altFunDeclaration.getValueParameters().get(i).getTypeReference().getTypeElement();
            if (pd.getVarargElementType() == null) {
                alternativeType = AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(alternativeTypeElement, pd.getType());
                alternativeVarargElementType = null;
            } else {
                alternativeVarargElementType = AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(alternativeTypeElement, pd.getVarargElementType());
                alternativeType = JetStandardLibrary.getInstance().getArrayType(alternativeVarargElementType);
            }
            altParamDescriptors.add(new ValueParameterDescriptorImpl(pd.getContainingDeclaration(), pd.getIndex(), pd.getAnnotations(), pd.getName(), pd.isVar(), alternativeType, pd.declaresDefaultValue(), alternativeVarargElementType));
        }
        JetType altReceiverType = null;
        if (valueParameterDescriptors.receiverType != null) {
            altReceiverType = AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(altFunDeclaration.getReceiverTypeRef().getTypeElement(), valueParameterDescriptors.receiverType);
        }
        return new JavaDescriptorResolver.ValueParameterDescriptors(altReceiverType, altParamDescriptors);
    }

    static List<TypeParameterDescriptor> computeAlternativeTypeParameters(List<TypeParameterDescriptor> typeParameterDescriptors, JetNamedFunction altFunDeclaration) throws AlternativeSignatureMismatchException {
        ArrayList<TypeParameterDescriptor> altParamDescriptors = new ArrayList<TypeParameterDescriptor>();
        int size = typeParameterDescriptors.size();
        for (int i = 0; i < size; ++i) {
            TypeParameterDescriptor pd = typeParameterDescriptors.get(i);
            DeclarationDescriptor containingDeclaration = pd.getContainingDeclaration();
            assert (containingDeclaration != null);
            TypeParameterDescriptorImpl altParamDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, pd.getAnnotations(), pd.isReified(), pd.getVariance(), pd.getName(), pd.getIndex());
            int upperBoundIndex = 0;
            for (JetType upperBound : pd.getUpperBounds()) {
                JetTypeElement altTypeElement;
                JetTypeParameter parameter = altFunDeclaration.getTypeParameters().get(i);
                if (upperBoundIndex == 0) {
                    JetTypeReference extendsBound = parameter.getExtendsBound();
                    if (extendsBound == null) {
                        assert (pd.getUpperBounds().size() == 1);
                        altParamDescriptor.addDefaultUpperBound();
                        break;
                    }
                    altTypeElement = extendsBound.getTypeElement();
                } else {
                    altTypeElement = AlternativeSignatureParsing.findTypeParameterConstraint(altFunDeclaration, parameter.getNameAsName(), upperBoundIndex).getBoundTypeReference().getTypeElement();
                }
                altParamDescriptor.addUpperBound(AlternativeSignatureParsing.computeAlternativeTypeFromAnnotation(altTypeElement, upperBound));
                ++upperBoundIndex;
            }
            altParamDescriptor.setInitialized();
            altParamDescriptors.add(altParamDescriptor);
        }
        return altParamDescriptors;
    }

    @Nullable
    private static JetTypeConstraint findTypeParameterConstraint(@NotNull JetFunction function, @NotNull Name typeParameterName, int index) {
        if (index != 0) {
            int currentIndex = 0;
            for (JetTypeConstraint constraint : function.getTypeConstraints()) {
                if (typeParameterName.equals(constraint.getSubjectTypeParameterName().getReferencedNameAsName())) {
                    ++currentIndex;
                }
                if (currentIndex != index) continue;
                return constraint;
            }
        }
        return null;
    }

    static void checkForSyntaxErrors(PsiMethodWrapper method, JetNamedFunction altFunDeclaration) throws AlternativeSignatureMismatchException {
        List<PsiErrorElement> syntaxErrors = AnalyzingUtils.getSyntaxErrorRanges(altFunDeclaration);
        if (!syntaxErrors.isEmpty()) {
            String textSignature = String.format("%s(%s)", method.getName(), StringUtil.join(method.getPsiMethod().getSignature(PsiSubstitutor.EMPTY).getParameterTypes(), new Function<PsiType, String>(){

                @Override
                public String fun(PsiType psiType) {
                    return psiType.getPresentableText();
                }
            }, ", "));
            int errorOffset = syntaxErrors.get(0).getTextOffset();
            String syntaxErrorDescription = syntaxErrors.get(0).getErrorDescription();
            String errorText = syntaxErrors.size() == 1 ? String.format("Alternative signature for %s has syntax error at %d: %s", textSignature, errorOffset, syntaxErrorDescription) : String.format("Alternative signature for %s has %d syntax errors, first is at %d: %s", textSignature, syntaxErrors.size(), errorOffset, syntaxErrorDescription);
            throw new AlternativeSignatureMismatchException(errorText);
        }
    }
}

