/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Function;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class IntValue
implements CompileTimeConstant<Integer> {
    public static final Function<Long, IntValue> CREATE = new Function<Long, IntValue>(){

        @Override
        public IntValue apply(@Nullable Long input) {
            assert (input != null);
            return new IntValue(input.intValue());
        }
    };
    private final int value;

    public IntValue(int value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull JetStandardLibrary standardLibrary) {
        return standardLibrary.getIntType();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitIntValue(this, data);
    }

    public String toString() {
        return this.value + ".toInt()";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntValue intValue = (IntValue)o;
        return this.value == intValue.value;
    }

    public int hashCode() {
        return this.value;
    }
}

