/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Function;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class CompileTimeConstantResolver {
    public static final ErrorValue OUT_OF_RANGE = new ErrorValue("The value is out of range");
    private final JetStandardLibrary standardLibrary = JetStandardLibrary.getInstance();

    @NotNull
    public CompileTimeConstant<?> getIntegerValue(@NotNull String text, @NotNull JetType expectedType) {
        long upperBound;
        long lowerBound;
        Function<Long, CompileTimeConstant<Integer>> create;
        if (this.noExpectedType(expectedType)) {
            Long value = CompileTimeConstantResolver.parseLongValue(text);
            if (value == null) {
                return OUT_OF_RANGE;
            }
            if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
                return new IntValue(value.intValue());
            }
            return new LongValue(value);
        }
        TypeConstructor constructor = expectedType.getConstructor();
        if (constructor == this.standardLibrary.getInt().getTypeConstructor()) {
            create = IntValue.CREATE;
            lowerBound = Integer.MIN_VALUE;
            upperBound = Integer.MAX_VALUE;
        } else if (constructor == this.standardLibrary.getLong().getTypeConstructor()) {
            create = LongValue.CREATE;
            lowerBound = Long.MIN_VALUE;
            upperBound = Long.MAX_VALUE;
        } else if (constructor == this.standardLibrary.getShort().getTypeConstructor()) {
            create = ShortValue.CREATE;
            lowerBound = -32768L;
            upperBound = 32767L;
        } else if (constructor == this.standardLibrary.getByte().getTypeConstructor()) {
            create = ByteValue.CREATE;
            lowerBound = -128L;
            upperBound = 127L;
        } else {
            JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
            JetType intType = this.standardLibrary.getIntType();
            JetType longType = this.standardLibrary.getLongType();
            if (typeChecker.isSubtypeOf(intType, expectedType)) {
                return this.getIntegerValue(text, intType);
            }
            if (typeChecker.isSubtypeOf(longType, expectedType)) {
                return this.getIntegerValue(text, longType);
            }
            return new ErrorValue("An integer literal does not conform to the expected type " + expectedType);
        }
        Long value = CompileTimeConstantResolver.parseLongValue(text);
        if (value != null && lowerBound <= value && value <= upperBound) {
            return create.apply(value);
        }
        return new ErrorValue("An integer literal does not conform to the expected type " + expectedType);
    }

    @Nullable
    private static Long parseLongValue(String text) {
        try {
            long value;
            if (text.startsWith("0x") || text.startsWith("0X")) {
                String hexString = text.substring(2);
                value = Long.parseLong(hexString, 16);
            } else if (text.startsWith("0b") || text.startsWith("0B")) {
                String binString = text.substring(2);
                value = Long.parseLong(binString, 2);
            } else {
                value = Long.parseLong(text);
            }
            return value;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public CompileTimeConstant<?> getFloatValue(@NotNull String text, @NotNull JetType expectedType) {
        if (this.noExpectedType(expectedType) || JetTypeChecker.INSTANCE.isSubtypeOf(this.standardLibrary.getDoubleType(), expectedType)) {
            try {
                return new DoubleValue(Double.parseDouble(text));
            }
            catch (NumberFormatException e) {
                return OUT_OF_RANGE;
            }
        }
        if (JetTypeChecker.INSTANCE.isSubtypeOf(this.standardLibrary.getFloatType(), expectedType)) {
            try {
                return new DoubleValue(Float.parseFloat(text));
            }
            catch (NumberFormatException e) {
                return OUT_OF_RANGE;
            }
        }
        return new ErrorValue("A floating-point literal does not conform to the expected type " + expectedType);
    }

    @Nullable
    private CompileTimeConstant<?> checkNativeType(String text, JetType expectedType, String title, JetType nativeType) {
        if (!this.noExpectedType(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(nativeType, expectedType)) {
            return new ErrorValue("A " + title + " literal " + text + " does not conform to the expected type " + expectedType);
        }
        return null;
    }

    @NotNull
    public CompileTimeConstant<?> getBooleanValue(@NotNull String text, @NotNull JetType expectedType) {
        CompileTimeConstant<?> error = this.checkNativeType(text, expectedType, "boolean", this.standardLibrary.getBooleanType());
        if (error != null) {
            return error;
        }
        if ("true".equals(text)) {
            return BooleanValue.TRUE;
        }
        if ("false".equals(text)) {
            return BooleanValue.FALSE;
        }
        throw new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @NotNull
    public CompileTimeConstant<?> getCharValue(@NotNull String text, @NotNull JetType expectedType) {
        CompileTimeConstant<?> error = this.checkNativeType(text, expectedType, "character", this.standardLibrary.getCharType());
        if (error != null) {
            return error;
        }
        if (text.length() < 2 || text.charAt(0) != '\'' || text.charAt(text.length() - 1) != '\'') {
            return new ErrorValue("Incorrect character literal");
        }
        if ((text = text.substring(1, text.length() - 1)).length() == 0) {
            return new ErrorValue("Empty character literal");
        }
        if (text.charAt(0) != '\\') {
            if (text.length() == 1) {
                return new CharValue(text.charAt(0));
            }
            return new ErrorValue("Too many characters in a character literal '" + text + "'");
        }
        return CompileTimeConstantResolver.escapedStringToCharValue(text);
    }

    @NotNull
    public static CompileTimeConstant<?> escapedStringToCharValue(@NotNull String text) {
        assert (text.length() > 0 && text.charAt(0) == '\\') : "Only escaped sequences must be passed to this routine: " + text;
        String escape = text.substring(1);
        switch (escape.length()) {
            case 0: {
                return CompileTimeConstantResolver.illegalEscape(text);
            }
            case 1: {
                Character escaped = CompileTimeConstantResolver.translateEscape(escape.charAt(0));
                if (escaped == null) {
                    return CompileTimeConstantResolver.illegalEscape(text);
                }
                return new CharValue(escaped.charValue());
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    Integer intValue = Integer.valueOf(escape.substring(1), 16);
                    return new CharValue((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return CompileTimeConstantResolver.illegalEscape(text);
    }

    private static ErrorValue illegalEscape(String text) {
        return new ErrorValue("Illegal escape: " + text);
    }

    @Nullable
    public static Character translateEscape(char c) {
        switch (c) {
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'n': {
                return Character.valueOf('\n');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '$': {
                return Character.valueOf('$');
            }
        }
        return null;
    }

    @NotNull
    public CompileTimeConstant<?> getRawStringValue(@NotNull String unescapedText, @NotNull JetType expectedType) {
        CompileTimeConstant<?> error = this.checkNativeType("\"\"\"...\"\"\"", expectedType, "string", this.standardLibrary.getStringType());
        if (error != null) {
            return error;
        }
        return new StringValue(unescapedText.substring(3, unescapedText.length() - 3));
    }

    @NotNull
    public CompileTimeConstant<?> getEscapedStringValue(@NotNull List<JetStringTemplateEntry> entries, @NotNull JetType expectedType) {
        CompileTimeConstant<?> error = this.checkNativeType("\"...\"", expectedType, "string", this.standardLibrary.getStringType());
        if (error != null) {
            return error;
        }
        final StringBuilder builder = new StringBuilder();
        final CompileTimeConstant[] result = new CompileTimeConstant[1];
        for (JetStringTemplateEntry entry : entries) {
            entry.accept(new JetVisitorVoid(){

                @Override
                public void visitStringTemplateEntry(JetStringTemplateEntry entry) {
                    result[0] = new ErrorValue("String templates are not allowed in compile-time constants");
                }

                @Override
                public void visitLiteralStringTemplateEntry(JetLiteralStringTemplateEntry entry) {
                    builder.append(entry.getText());
                }

                @Override
                public void visitEscapeStringTemplateEntry(JetEscapeStringTemplateEntry entry) {
                    String text = entry.getText();
                    assert (text.length() == 2 && text.charAt(0) == '\\');
                    Character character = CompileTimeConstantResolver.translateEscape(text.charAt(1));
                    if (character != null) {
                        builder.append(character);
                    }
                }
            });
            if (result[0] == null) continue;
            return result[0];
        }
        return new StringValue(builder.toString());
    }

    @NotNull
    public CompileTimeConstant<?> getNullValue(@NotNull JetType expectedType) {
        if (this.noExpectedType(expectedType) || expectedType.isNullable()) {
            return NullValue.NULL;
        }
        return new ErrorValue("Null can not be a value of a non-null type " + expectedType);
    }

    private boolean noExpectedType(JetType expectedType) {
        return expectedType == TypeUtils.NO_EXPECTED_TYPE || JetStandardClasses.isUnit(expectedType) || ErrorUtils.isErrorType(expectedType);
    }
}

