/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class CharValue
implements CompileTimeConstant<Character> {
    private final char value;

    public CharValue(char value) {
        this.value = value;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.value);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull JetStandardLibrary standardLibrary) {
        return standardLibrary.getCharType();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitCharValue(this, data);
    }

    public String toString() {
        return "#" + this.value + "(" + this.value + ")";
    }
}

