/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.util.Set;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.BoundsOwner;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeValue;
import org.jetbrains.jet.lang.types.JetType;

public class PrintingConstraintResolutionListener
implements ConstraintResolutionListener {
    @Override
    public void constraintsForUnknown(TypeParameterDescriptor typeParameterDescriptor, BoundsOwner typeValue) {
        PrintingConstraintResolutionListener.println("Constraints for " + typeParameterDescriptor);
        this.printTypeValue(typeValue);
    }

    @Override
    public void constraintsForKnownType(JetType type, BoundsOwner typeValue) {
        PrintingConstraintResolutionListener.println("Constraints for " + type);
        this.printTypeValue(typeValue);
    }

    @Override
    public void done(ConstraintSystemSolution solution, Set<TypeParameterDescriptor> typeParameterDescriptors) {
        PrintingConstraintResolutionListener.println("==================================================");
        PrintingConstraintResolutionListener.println("");
        PrintingConstraintResolutionListener.println("");
    }

    @Override
    public void log(Object ... messageFragments) {
        for (Object fragment : messageFragments) {
            PrintingConstraintResolutionListener.println(fragment);
        }
    }

    @Override
    public void error(Object ... messageFragments) {
        for (Object fragment : messageFragments) {
            PrintingConstraintResolutionListener.println(fragment);
        }
    }

    private void printTypeValue(BoundsOwner typeValue) {
        for (TypeValue bound : typeValue.getUpperBounds()) {
            PrintingConstraintResolutionListener.println(" :< " + bound);
        }
        for (TypeValue bound : typeValue.getLowerBounds()) {
            PrintingConstraintResolutionListener.println(" :> " + bound);
        }
    }

    private static void println(Object message) {
        ResolutionDebugInfo.println(message);
    }
}

