/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.inference.BoundsOwner;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.types.JetType;

public class DebugConstraintResolutionListener
implements ConstraintResolutionListener {
    private final ResolutionDebugInfo.Data debugInfo;
    private final ResolvedCall<? extends CallableDescriptor> candidateCall;

    public DebugConstraintResolutionListener(@NotNull ResolvedCall<? extends CallableDescriptor> candidateCall, @NotNull ResolutionDebugInfo.Data debugInfo) {
        this.debugInfo = debugInfo;
        this.candidateCall = candidateCall;
    }

    @Override
    public void constraintsForUnknown(TypeParameterDescriptor typeParameterDescriptor, BoundsOwner typeValue) {
        if (!ResolutionDebugInfo.isResolutionDebugEnabled()) {
            return;
        }
        Map<TypeParameterDescriptor, BoundsOwner> map = this.debugInfo.getByKey(ResolutionDebugInfo.BOUNDS_FOR_UNKNOWNS, this.candidateCall);
        if (map == null) {
            map = Maps.newLinkedHashMap();
            this.debugInfo.putByKey(ResolutionDebugInfo.BOUNDS_FOR_UNKNOWNS, this.candidateCall, map);
        }
        map.put(typeParameterDescriptor, typeValue);
    }

    @Override
    public void constraintsForKnownType(JetType type, BoundsOwner typeValue) {
        if (!ResolutionDebugInfo.isResolutionDebugEnabled()) {
            return;
        }
        Map<JetType, BoundsOwner> map = this.debugInfo.getByKey(ResolutionDebugInfo.BOUNDS_FOR_KNOWNS, this.candidateCall);
        if (map == null) {
            map = Maps.newLinkedHashMap();
            this.debugInfo.putByKey(ResolutionDebugInfo.BOUNDS_FOR_KNOWNS, this.candidateCall, map);
        }
        map.put(type, typeValue);
    }

    @Override
    public void done(ConstraintSystemSolution solution, Set<TypeParameterDescriptor> typeParameterDescriptors) {
        if (!ResolutionDebugInfo.isResolutionDebugEnabled()) {
            return;
        }
        this.debugInfo.putByKey(ResolutionDebugInfo.SOLUTION, this.candidateCall, solution);
        this.debugInfo.putByKey(ResolutionDebugInfo.UNKNOWNS, this.candidateCall, typeParameterDescriptors);
    }

    @Override
    public void log(Object ... messageFragments) {
        if (!ResolutionDebugInfo.isResolutionDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = this.debugInfo.getByKey(ResolutionDebugInfo.LOG, this.candidateCall);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            this.debugInfo.putByKey(ResolutionDebugInfo.LOG, this.candidateCall, stringBuilder);
        }
        for (Object m : messageFragments) {
            stringBuilder.append(m);
        }
        stringBuilder.append("\n");
    }

    @Override
    public void error(Object ... messageFragments) {
        if (!ResolutionDebugInfo.isResolutionDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = this.debugInfo.getByKey(ResolutionDebugInfo.ERRORS, this.candidateCall);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            this.debugInfo.putByKey(ResolutionDebugInfo.ERRORS, this.candidateCall, stringBuilder);
        }
        for (Object m : messageFragments) {
            stringBuilder.append(m);
        }
        stringBuilder.append("\n");
    }
}

