/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.inference.SubtypingConstraint;
import org.jetbrains.jet.lang.types.JetType;

public enum ConstraintType implements Comparable<ConstraintType>
{
    RECEIVER("{0} is not a subtype of the expected receiver type {1}"),
    VALUE_ARGUMENT("Type mismatch: argument type is {0}, but {1} was expected"),
    EXPECTED_TYPE("Resulting type is {0} but {1} was expected"),
    PARAMETER_BOUND("Type parameter bound is not satisfied: {0} is not a subtype of {1}");

    private final String errorMessageTemplate;

    private ConstraintType(@NotNull String errorMessageTemplate) {
        this.errorMessageTemplate = errorMessageTemplate;
    }

    @NotNull
    public SubtypingConstraint assertSubtyping(@NotNull JetType subtype, @NotNull JetType supertype) {
        return new SubtypingConstraint(this, subtype, supertype);
    }

    @NotNull
    public String makeErrorMessage(@NotNull SubtypingConstraint constraint) {
        return MessageFormat.format(this.errorMessageTemplate, constraint.getSubtype(), constraint.getSupertype());
    }
}

