/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.resolve.calls.inference.SolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.SubtypingConstraint;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeValue;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;

public class ConstraintSystemWithPriorities
implements ConstraintSystem {
    public static final Comparator<SubtypingConstraint> SUBTYPING_CONSTRAINT_ORDER = new Comparator<SubtypingConstraint>(){

        @Override
        public int compare(SubtypingConstraint o1, SubtypingConstraint o2) {
            return o1.getType().compareTo(o2.getType());
        }
    };
    private final Map<JetType, TypeValue> knownTypes = Maps.newLinkedHashMap();
    private final Map<TypeParameterDescriptor, TypeValue> unknownTypes = Maps.newLinkedHashMap();
    private final Set<TypeValue> unsolvedUnknowns = Sets.newLinkedHashSet();
    private final PriorityQueue<SubtypingConstraint> constraintQueue = new PriorityQueue<SubtypingConstraint>(10, SUBTYPING_CONSTRAINT_ORDER);
    private final JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
    private final TypeCheckingProcedure constraintExpander;
    private final ConstraintResolutionListener listener;
    private final Set<TypeValue> beingComputed = Sets.newHashSet();

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors, JetType type) {
        final HashSet<TypeConstructor> constructors = Sets.newHashSet();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            constructors.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjection projection = new TypeProjection(type);
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (constructors.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }

    public ConstraintSystemWithPriorities(ConstraintResolutionListener listener) {
        this.listener = listener;
        this.constraintExpander = this.createConstraintExpander();
    }

    @NotNull
    private TypeValue getTypeValueFor(@NotNull JetType type) {
        TypeValue unknownType;
        TypeParameterDescriptor typeParameterDescriptor;
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor && (typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor).getDefaultType().isNullable() == type.isNullable() && (unknownType = this.unknownTypes.get(typeParameterDescriptor)) != null) {
            return unknownType;
        }
        TypeValue typeValue = this.knownTypes.get(type);
        if (typeValue == null) {
            typeValue = new TypeValue(type);
            this.knownTypes.put(type, typeValue);
        }
        return typeValue;
    }

    @Override
    public void registerTypeVariable(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Variance positionVariance) {
        assert (!this.unknownTypes.containsKey(typeParameterDescriptor));
        TypeValue typeValue = new TypeValue(typeParameterDescriptor, positionVariance);
        this.unknownTypes.put(typeParameterDescriptor, typeValue);
        this.unsolvedUnknowns.add(typeValue);
    }

    @NotNull
    private TypeValue getTypeVariable(TypeParameterDescriptor typeParameterDescriptor) {
        TypeValue unknownType = this.unknownTypes.get(typeParameterDescriptor);
        if (unknownType == null) {
            throw new IllegalArgumentException("This type parameter is not an unknown in this constraint system: " + typeParameterDescriptor);
        }
        return unknownType;
    }

    @Override
    public void addSubtypingConstraint(@NotNull SubtypingConstraint constraint) {
        this.constraintQueue.add(constraint);
    }

    private TypeCheckingProcedure createConstraintExpander() {
        return new TypeCheckingProcedure(new TypeConstraintBuilderAdapter(new TypingConstraints(){

            @Override
            public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                TypeValue aValue = ConstraintSystemWithPriorities.this.getTypeValueFor(a);
                TypeValue bValue = ConstraintSystemWithPriorities.this.getTypeValueFor(b);
                return ConstraintSystemWithPriorities.this.expandEqualityConstraint(aValue, bValue);
            }

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                return a.equals(b) || ConstraintSystemWithPriorities.this.unknownTypes.containsKey(a.getDeclarationDescriptor()) || ConstraintSystemWithPriorities.this.unknownTypes.containsKey(b.getDeclarationDescriptor());
            }

            @Override
            public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                TypeValue supertypeValue;
                TypeValue subtypeValue = ConstraintSystemWithPriorities.this.getTypeValueFor(subtype);
                if (this.someUnknown(subtypeValue, supertypeValue = ConstraintSystemWithPriorities.this.getTypeValueFor(supertype))) {
                    ConstraintSystemWithPriorities.this.expandSubtypingConstraint(subtypeValue, supertypeValue);
                }
                return true;
            }

            @Override
            public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
                TypeValue superTypeValue;
                TypeValue subTypeValue = ConstraintSystemWithPriorities.this.getTypeValueFor(subtype);
                boolean someUnknown = this.someUnknown(subTypeValue, superTypeValue = ConstraintSystemWithPriorities.this.getTypeValueFor(supertype));
                if (someUnknown) {
                    ConstraintSystemWithPriorities.this.expandSubtypingConstraint(subTypeValue, superTypeValue);
                }
                return someUnknown;
            }

            private boolean someUnknown(TypeValue subtypeValue, TypeValue supertypeValue) {
                return !subtypeValue.isKnown() || !supertypeValue.isKnown();
            }
        }, this.listener));
    }

    private boolean assignValueTo(TypeValue unknown, JetType value) {
        if (unknown.hasValue()) {
            return TypeUtils.equalTypes(unknown.getType(), value);
        }
        this.unsolvedUnknowns.remove(unknown);
        unknown.setValue(value);
        return true;
    }

    private boolean mergeUnknowns(@NotNull TypeValue a, @NotNull TypeValue b) {
        assert (!a.isKnown() && !b.isKnown());
        this.listener.error("!!!mergeUnknowns() is not implemented!!!");
        return false;
    }

    public boolean expandEqualityConstraint(TypeValue a, TypeValue b) {
        if (a.isKnown() && b.isKnown()) {
            return this.constraintExpander.equalTypes(a.getType(), b.getType());
        }
        if (a.isKnown()) {
            TypeValue tmp = a;
            a = b;
            b = tmp;
        }
        if (b.isKnown()) {
            return this.assignValueTo(a, b.getType());
        }
        return this.mergeUnknowns(a, b);
    }

    private boolean expandSubtypingConstraint(TypeValue lower, TypeValue upper) {
        this.listener.log("Constraint added: ", lower, " :< ", upper);
        if (lower == upper) {
            return true;
        }
        lower.addUpperBound(upper);
        upper.addLowerBound(lower);
        if (lower.isKnown() && upper.isKnown()) {
            return this.constraintExpander.isSubtypeOf(lower.getType(), upper.getType());
        }
        if (!lower.isKnown() && !upper.isKnown()) {
            return this.mergeUnknowns(lower, upper);
        }
        if (upper.isKnown()) {
            if (!TypeUtils.canHaveSubtypes(this.typeChecker, upper.getType())) {
                return this.expandEqualityConstraint(lower, upper);
            }
            if (lower.getLowerBounds().contains(upper)) {
                return this.expandEqualityConstraint(lower, upper);
            }
        } else if (upper.getUpperBounds().contains(lower)) {
            return this.expandEqualityConstraint(lower, upper);
        }
        return true;
    }

    @Override
    @NotNull
    public ConstraintSystemSolution solve() {
        Solution solution = new Solution();
        PriorityQueue<SubtypingConstraint> constraintsToEnsureAfterInference = new PriorityQueue<SubtypingConstraint>(this.constraintQueue);
        while (!this.constraintQueue.isEmpty()) {
            TypeValue upper;
            SubtypingConstraint constraint = this.constraintQueue.poll();
            TypeValue typeValue = this.getTypeValueFor(constraint.getSubtype());
            boolean success = this.expandSubtypingConstraint(typeValue, upper = this.getTypeValueFor(constraint.getSupertype()));
            if (!success) {
                solution.registerError(constraint.getErrorMessage());
            }
            if (!this.unsolvedUnknowns.isEmpty()) continue;
            break;
        }
        assert (this.constraintQueue.isEmpty() || this.unsolvedUnknowns.isEmpty()) : this.constraintQueue + " " + this.unsolvedUnknowns;
        for (TypeValue typeValue : Sets.newLinkedHashSet(this.unsolvedUnknowns)) {
            if (this.computeValueFor(typeValue)) continue;
            this.listener.error("Not enough data to compute value for ", typeValue);
            solution.registerError("Not enough data to compute value for " + typeValue + ". Please, specify type arguments explicitly");
        }
        for (TypeValue typeValue : this.unknownTypes.values()) {
            this.listener.constraintsForUnknown(typeValue.getTypeParameterDescriptor(), typeValue);
        }
        for (TypeValue typeValue : this.knownTypes.values()) {
            this.listener.constraintsForKnownType(typeValue.getType(), typeValue);
        }
        for (Map.Entry entry : Sets.newHashSet(this.unknownTypes.entrySet())) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)entry.getKey();
            TypeValue unknown = (TypeValue)entry.getValue();
            for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
                constraintsToEnsureAfterInference.add(ConstraintType.PARAMETER_BOUND.assertSubtyping(unknown.getOriginalType(), this.getTypeValueFor(upperBound).getOriginalType()));
            }
            for (JetType lowerBound : typeParameterDescriptor.getLowerBounds()) {
                constraintsToEnsureAfterInference.add(ConstraintType.PARAMETER_BOUND.assertSubtyping(this.getTypeValueFor(lowerBound).getOriginalType(), unknown.getOriginalType()));
            }
        }
        for (SubtypingConstraint subtypingConstraint : constraintsToEnsureAfterInference) {
            JetType substitutedSupertype;
            JetType substitutedSubtype = solution.getSubstitutor().substitute(subtypingConstraint.getSubtype(), Variance.INVARIANT);
            if (substitutedSubtype == null || (substitutedSupertype = solution.getSubstitutor().substitute(subtypingConstraint.getSupertype(), Variance.INVARIANT)) == null || this.typeChecker.isSubtypeOf(substitutedSubtype, substitutedSupertype)) continue;
            solution.registerError(subtypingConstraint.getErrorMessage());
            this.listener.error("Constraint violation: ", substitutedSubtype, " :< ", substitutedSupertype, " message: ", subtypingConstraint.getErrorMessage());
        }
        this.listener.done(solution, this.unknownTypes.keySet());
        return solution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean computeValueFor(TypeValue unknown) {
        block13: {
            assert (!unknown.isKnown());
            if (this.beingComputed.contains(unknown)) {
                throw new LoopInTypeVariableConstraintsException();
            }
            if (!unknown.hasValue()) {
                this.beingComputed.add(unknown);
                try {
                    if (unknown.getPositionVariance() == Variance.IN_VARIANCE) {
                        throw new UnsupportedOperationException();
                    }
                    Set<TypeValue> lowerBounds = unknown.getLowerBounds();
                    Set<TypeValue> upperBounds = unknown.getUpperBounds();
                    if (!lowerBounds.isEmpty()) {
                        Set<JetType> types = ConstraintSystemWithPriorities.getTypes(lowerBounds);
                        JetType commonSupertype = CommonSupertypes.commonSupertype(types);
                        for (TypeValue upperBound : upperBounds) {
                            if (this.typeChecker.isSubtypeOf(commonSupertype, upperBound.getType())) continue;
                            boolean bl = false;
                            return bl;
                        }
                        this.listener.log("minimal solution from lower bounds for ", this, " is ", commonSupertype);
                        this.assignValueTo(unknown, commonSupertype);
                        break block13;
                    }
                    if (!upperBounds.isEmpty()) {
                        Set<JetType> types = ConstraintSystemWithPriorities.getTypes(upperBounds);
                        JetType intersect = TypeUtils.intersect(this.typeChecker, types);
                        if (intersect == null) {
                            boolean bl = false;
                            return bl;
                        }
                        this.assignValueTo(unknown, intersect);
                        break block13;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.beingComputed.remove(unknown);
                }
            }
        }
        return true;
    }

    private static Set<JetType> getTypes(Set<TypeValue> lowerBounds) {
        HashSet<JetType> types = Sets.newHashSet();
        for (TypeValue lowerBound : lowerBounds) {
            types.add(lowerBound.getType());
        }
        return types;
    }

    private static final class TypeConstraintBuilderAdapter
    implements TypingConstraints {
        private final TypingConstraints delegate;
        private final ConstraintResolutionListener listener;

        private TypeConstraintBuilderAdapter(TypingConstraints delegate, ConstraintResolutionListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        @Override
        public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            boolean result = this.delegate.assertEqualTypes(a, b, typeCheckingProcedure);
            if (!result) {
                this.listener.error("-- Failed to equate ", a, " and ", b);
            }
            return result;
        }

        @Override
        public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
            boolean result = this.delegate.assertEqualTypeConstructors(a, b);
            if (!result) {
                this.listener.error("-- Type constructors are not equal: ", a, " and ", b);
            }
            return result;
        }

        @Override
        public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            boolean result = this.delegate.assertSubtype(subtype, supertype, typeCheckingProcedure);
            if (!result) {
                this.listener.error("-- " + subtype + " can't be a subtype of " + supertype);
            }
            return result;
        }

        @Override
        public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
            boolean result = this.delegate.noCorrespondingSupertype(subtype, supertype);
            if (!result) {
                this.listener.error("-- " + subtype + " has no supertype corresponding to " + supertype);
            }
            return result;
        }
    }

    public class Solution
    implements ConstraintSystemSolution {
        private final TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                ClassifierDescriptor declarationDescriptor = key.getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor descriptor = (TypeParameterDescriptor)declarationDescriptor;
                    if (!ConstraintSystemWithPriorities.this.unknownTypes.containsKey(descriptor)) {
                        return null;
                    }
                    JetType value = Solution.this.getValue(descriptor);
                    if (value == null) {
                        return null;
                    }
                    TypeProjection typeProjection = new TypeProjection(value);
                    ConstraintSystemWithPriorities.this.listener.log(descriptor, " |-> ", typeProjection);
                    return typeProjection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            public String toString() {
                return ConstraintSystemWithPriorities.this.unknownTypes.toString();
            }
        });
        private SolutionStatus status = SolutionStatus.SUCCESS;

        private Solution registerError(String message) {
            this.status = new Error(message);
            return this;
        }

        @Override
        @NotNull
        public SolutionStatus getStatus() {
            return this.status;
        }

        @Override
        public JetType getValue(TypeParameterDescriptor typeParameterDescriptor) {
            TypeValue typeVariable = ConstraintSystemWithPriorities.this.getTypeVariable(typeParameterDescriptor);
            return typeVariable.hasValue() ? typeVariable.getType() : null;
        }

        @Override
        @NotNull
        public TypeSubstitutor getSubstitutor() {
            return this.typeSubstitutor;
        }
    }

    private static class Error
    implements SolutionStatus {
        private final String message;

        private Error(String message) {
            this.message = message;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        public String toString() {
            return this.message;
        }
    }

    private static class LoopInTypeVariableConstraintsException
    extends RuntimeException {
    }
}

