/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootNamespaceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class DataFlowValueFactory {
    public static final DataFlowValueFactory INSTANCE = new DataFlowValueFactory();

    private DataFlowValueFactory() {
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull JetExpression expression, @NotNull JetType type, @NotNull BindingContext bindingContext) {
        JetConstantExpression constantExpression;
        if (expression instanceof JetConstantExpression && (constantExpression = (JetConstantExpression)expression).getNode().getElementType() == JetNodeTypes.NULL) {
            return DataFlowValue.NULL;
        }
        if (TypeUtils.equalTypes(type, JetStandardClasses.getNullableNothingType())) {
            return DataFlowValue.NULL;
        }
        Pair<Object, Boolean> result = DataFlowValueFactory.getIdForStableIdentifier(expression, bindingContext, false);
        return new DataFlowValue(result.first == null ? expression : result.first, type, (Boolean)result.second, this.getImmanentNullability(type));
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ThisReceiverDescriptor receiver) {
        JetType type = receiver.getType();
        return new DataFlowValue(receiver.getDeclarationDescriptor(), type, true, this.getImmanentNullability(type));
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull VariableDescriptor variableDescriptor) {
        JetType type = variableDescriptor.getType();
        return new DataFlowValue(variableDescriptor, type, DataFlowValueFactory.isStableVariable(variableDescriptor), this.getImmanentNullability(type));
    }

    private Nullability getImmanentNullability(JetType type) {
        return type.isNullable() ? Nullability.UNKNOWN : Nullability.NOT_NULL;
    }

    @NotNull
    private static Pair<Object, Boolean> getIdForStableIdentifier(@NotNull JetExpression expression, @NotNull BindingContext bindingContext, boolean allowNamespaces) {
        if (expression instanceof JetParenthesizedExpression) {
            JetParenthesizedExpression parenthesizedExpression = (JetParenthesizedExpression)expression;
            JetExpression innerExpression = parenthesizedExpression.getExpression();
            if (innerExpression == null) {
                return Pair.create(null, false);
            }
            return DataFlowValueFactory.getIdForStableIdentifier(innerExpression, bindingContext, allowNamespaces);
        }
        if (expression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)expression;
            JetExpression selectorExpression = qualifiedExpression.getSelectorExpression();
            if (selectorExpression == null) {
                return Pair.create(null, false);
            }
            Pair<Object, Boolean> receiverId = DataFlowValueFactory.getIdForStableIdentifier(qualifiedExpression.getReceiverExpression(), bindingContext, true);
            Pair<Object, Boolean> selectorId = DataFlowValueFactory.getIdForStableIdentifier(selectorExpression, bindingContext, allowNamespaces);
            return (Boolean)receiverId.second != false ? selectorId : Pair.create(receiverId.first, false);
        }
        if (expression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression simpleNameExpression = (JetSimpleNameExpression)expression;
            DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
            if (declarationDescriptor instanceof VariableDescriptor) {
                return Pair.create(declarationDescriptor, DataFlowValueFactory.isStableVariable((VariableDescriptor)declarationDescriptor));
            }
            if (declarationDescriptor instanceof NamespaceDescriptor) {
                return Pair.create(declarationDescriptor, allowNamespaces);
            }
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                return Pair.create(classDescriptor, classDescriptor.isClassObjectAValue());
            }
        } else {
            if (expression instanceof JetThisExpression) {
                JetThisExpression thisExpression = (JetThisExpression)expression;
                DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
                if (declarationDescriptor instanceof CallableDescriptor) {
                    return Pair.create(((CallableDescriptor)declarationDescriptor).getReceiverParameter(), true);
                }
                if (declarationDescriptor instanceof ClassDescriptor) {
                    return Pair.create(((ClassDescriptor)declarationDescriptor).getImplicitReceiver(), true);
                }
                return Pair.create(null, true);
            }
            if (expression instanceof JetRootNamespaceExpression) {
                return Pair.create(JetModuleUtil.getRootNamespaceType(expression), allowNamespaces);
            }
        }
        return Pair.create(null, false);
    }

    public static boolean isStableVariable(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor.isVar()) {
            return false;
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (!DataFlowValueFactory.isInternal(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.isFinal(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.hasDefaultGetter(propertyDescriptor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFinal(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable() && propertyDescriptor.getModality().isOverridable()) {
                return false;
            }
        } else if (propertyDescriptor.getModality().isOverridable()) {
            throw new IllegalStateException("Property outside a class must not be overridable: " + propertyDescriptor.getName());
        }
        return true;
    }

    private static boolean isInternal(@NotNull DeclarationDescriptorWithVisibility descriptor) {
        if (Visibilities.INTERNAL_VISIBILITIES.contains(descriptor.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof DeclarationDescriptorWithVisibility)) {
            return false;
        }
        return DataFlowValueFactory.isInternal((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        return getter == null || getter.isDefault();
    }
}

