/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableMap;
import org.jetbrains.jet.internal.com.google.common.collect.ListMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Multimaps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.util.CommonSuppliers;

public class DataFlowInfo {
    public static final CompositionOperator AND = new CompositionOperator(){

        @Override
        public DataFlowInfo compose(DataFlowInfo a, DataFlowInfo b) {
            return a.and(b);
        }
    };
    public static final CompositionOperator OR = new CompositionOperator(){

        @Override
        public DataFlowInfo compose(DataFlowInfo a, DataFlowInfo b) {
            return a.or(b);
        }
    };
    public static DataFlowInfo EMPTY = new DataFlowInfo(ImmutableMap.<DataFlowValue, Nullability>of(), Multimaps.newListMultimap(Collections.emptyMap(), CommonSuppliers.getArrayListSupplier()));
    private final ImmutableMap<DataFlowValue, Nullability> nullabilityInfo;
    private final ListMultimap<DataFlowValue, JetType> typeInfo;

    private DataFlowInfo(ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, ListMultimap<DataFlowValue, JetType> typeInfo) {
        this.nullabilityInfo = nullabilityInfo;
        this.typeInfo = typeInfo;
    }

    @NotNull
    private Nullability getNullability(@NotNull DataFlowValue a) {
        if (!a.isStableIdentifier()) {
            return a.getImmanentNullability();
        }
        Nullability nullability = this.nullabilityInfo.get(a);
        if (nullability == null) {
            nullability = a.getImmanentNullability();
        }
        return nullability;
    }

    private boolean putNullability(@NotNull Map<DataFlowValue, Nullability> map, @NotNull DataFlowValue value, @NotNull Nullability nullability) {
        if (!value.isStableIdentifier()) {
            return false;
        }
        return map.put(value, nullability) != nullability;
    }

    @NotNull
    public List<JetType> getPossibleTypes(DataFlowValue key) {
        JetType originalType = key.getType();
        List<JetType> types = this.typeInfo.get(key);
        Nullability nullability = this.getNullability(key);
        if (nullability.canBeNull()) {
            return types;
        }
        ArrayList<JetType> enrichedTypes = Lists.newArrayListWithCapacity(types.size());
        if (originalType.isNullable()) {
            enrichedTypes.add(TypeUtils.makeNotNullable(originalType));
        }
        for (JetType type : types) {
            if (type.isNullable()) {
                enrichedTypes.add(TypeUtils.makeNotNullable(type));
                continue;
            }
            enrichedTypes.add(type);
        }
        return enrichedTypes;
    }

    @NotNull
    public DataFlowInfo equate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap(this.nullabilityInfo);
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB));
        return (changed |= this.putNullability(builder, b, nullabilityOfA.refine(nullabilityOfA))) ? new DataFlowInfo(ImmutableMap.copyOf(builder), this.typeInfo) : this;
    }

    @NotNull
    public DataFlowInfo disequate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap(this.nullabilityInfo);
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB.invert()));
        return (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA.invert()))) ? new DataFlowInfo(ImmutableMap.copyOf(builder), this.typeInfo) : this;
    }

    @NotNull
    public DataFlowInfo establishSubtyping(@NotNull DataFlowValue[] values, @NotNull JetType type) {
        ListMultimap<DataFlowValue, JetType> newTypeInfo = this.copyTypeInfo();
        HashMap<DataFlowValue, Nullability> newNullabilityInfo = Maps.newHashMap(this.nullabilityInfo);
        boolean changed = false;
        for (DataFlowValue value : values) {
            changed = true;
            newTypeInfo.put(value, type);
            if (type.isNullable()) continue;
            this.putNullability(newNullabilityInfo, value, Nullability.NOT_NULL);
        }
        if (!changed) {
            return this;
        }
        return new DataFlowInfo(ImmutableMap.copyOf(newNullabilityInfo), newTypeInfo);
    }

    private ListMultimap<DataFlowValue, JetType> copyTypeInfo() {
        ListMultimap<DataFlowValue, JetType> newTypeInfo = Multimaps.newListMultimap(Maps.newHashMap(), CommonSuppliers.getArrayListSupplier());
        newTypeInfo.putAll(this.typeInfo);
        return newTypeInfo;
    }

    public DataFlowInfo and(DataFlowInfo other) {
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        nullabilityMapBuilder.putAll(this.nullabilityInfo);
        for (Map.Entry entry : other.nullabilityInfo.entrySet()) {
            DataFlowValue key = (DataFlowValue)entry.getKey();
            Nullability otherFlags = (Nullability)((Object)entry.getValue());
            Nullability thisFlags = this.nullabilityInfo.get(key);
            if (thisFlags != null) {
                nullabilityMapBuilder.put(key, thisFlags.and(otherFlags));
                continue;
            }
            nullabilityMapBuilder.put(key, otherFlags);
        }
        ListMultimap<DataFlowValue, JetType> newTypeInfo = this.copyTypeInfo();
        newTypeInfo.putAll(other.typeInfo);
        return new DataFlowInfo(ImmutableMap.copyOf(nullabilityMapBuilder), newTypeInfo);
    }

    public DataFlowInfo or(DataFlowInfo other) {
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap(this.nullabilityInfo);
        builder.keySet().retainAll(other.nullabilityInfo.keySet());
        for (Map.Entry entry : builder.entrySet()) {
            DataFlowValue key = (DataFlowValue)entry.getKey();
            Nullability thisFlags = (Nullability)((Object)entry.getValue());
            Nullability otherFlags = other.nullabilityInfo.get(key);
            assert (otherFlags != null);
            builder.put(key, thisFlags.or(otherFlags));
        }
        ListMultimap<DataFlowValue, JetType> newTypeInfo = Multimaps.newListMultimap(Maps.newHashMap(), CommonSuppliers.getArrayListSupplier());
        Set keys = newTypeInfo.keySet();
        keys.retainAll(other.typeInfo.keySet());
        for (DataFlowValue key : keys) {
            List<JetType> thisTypes = this.typeInfo.get(key);
            List<JetType> otherTypes = other.typeInfo.get(key);
            HashSet<JetType> newTypes = Sets.newHashSet(thisTypes);
            newTypes.retainAll(otherTypes);
            newTypeInfo.putAll(key, newTypes);
        }
        return new DataFlowInfo(ImmutableMap.copyOf(builder), newTypeInfo);
    }

    public boolean hasTypeInfoConstraints() {
        return !this.typeInfo.isEmpty();
    }

    public static abstract class CompositionOperator {
        public abstract DataFlowInfo compose(DataFlowInfo var1, DataFlowInfo var2);
    }
}

