/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastService;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class AutoCastServiceImpl
implements AutoCastService {
    private final DataFlowInfo dataFlowInfo;
    private final BindingContext bindingContext;

    public AutoCastServiceImpl(DataFlowInfo dataFlowInfo, BindingContext bindingContext) {
        this.dataFlowInfo = dataFlowInfo;
        this.bindingContext = bindingContext;
    }

    @Override
    @NotNull
    public List<ReceiverDescriptor> getVariantsForReceiver(@NotNull ReceiverDescriptor receiverDescriptor) {
        ArrayList<ReceiverDescriptor> variants = Lists.newArrayList(AutoCastUtils.getAutoCastVariants(this.bindingContext, this.dataFlowInfo, receiverDescriptor));
        variants.add(receiverDescriptor);
        return variants;
    }

    @Override
    @NotNull
    public DataFlowInfo getDataFlowInfo() {
        return this.dataFlowInfo;
    }

    @Override
    public boolean isNotNull(@NotNull ReceiverDescriptor receiver) {
        if (!receiver.getType().isNullable()) {
            return true;
        }
        List<ReceiverDescriptor> autoCastVariants = AutoCastUtils.getAutoCastVariants(this.bindingContext, this.dataFlowInfo, receiver);
        for (ReceiverDescriptor autoCastVariant : autoCastVariants) {
            if (autoCastVariant.getType().isNullable()) continue;
            return true;
        }
        return false;
    }
}

