/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;

public class VariableAsFunctionResolvedCall
implements ResolvedCallWithTrace<FunctionDescriptor> {
    private final ResolvedCallWithTrace<FunctionDescriptor> functionCall;
    private final ResolvedCallWithTrace<VariableDescriptor> variableCall;

    public VariableAsFunctionResolvedCall(@NotNull ResolvedCallWithTrace<FunctionDescriptor> functionCall, @NotNull ResolvedCallWithTrace<VariableDescriptor> variableCall) {
        this.functionCall = functionCall;
        this.variableCall = variableCall;
    }

    public ResolvedCallWithTrace<FunctionDescriptor> getFunctionCall() {
        return this.functionCall;
    }

    public ResolvedCallWithTrace<VariableDescriptor> getVariableCall() {
        return this.variableCall;
    }

    @Override
    @NotNull
    public FunctionDescriptor getCandidateDescriptor() {
        return (FunctionDescriptor)this.functionCall.getResultingDescriptor();
    }

    @Override
    @NotNull
    public FunctionDescriptor getResultingDescriptor() {
        return (FunctionDescriptor)this.functionCall.getResultingDescriptor();
    }

    @Override
    @NotNull
    public ReceiverDescriptor getReceiverArgument() {
        return this.variableCall.getReceiverArgument();
    }

    @Override
    @NotNull
    public ReceiverDescriptor getThisObject() {
        return this.variableCall.getThisObject();
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.variableCall.getExplicitReceiverKind();
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        return this.functionCall.getValueArguments();
    }

    @Override
    @NotNull
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        return this.functionCall.getValueArgumentsByIndex();
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        return this.functionCall.getTypeArguments();
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        if (this.variableCall.getStatus() == ResolutionStatus.SUCCESS) {
            return this.functionCall.getStatus();
        }
        return this.variableCall.getStatus();
    }

    @Override
    public boolean isDirty() {
        return this.functionCall.isDirty();
    }

    @Override
    public TemporaryBindingTrace getTrace() {
        return this.variableCall.getTrace();
    }

    @Override
    public boolean isSafeCall() {
        return this.variableCall.isSafeCall();
    }
}

