/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;

public class VarargValueArgument
implements ResolvedValueArgument {
    private final List<ValueArgument> arguments = Lists.newArrayList();

    public void addArgument(@NotNull ValueArgument argument) {
        this.arguments.add(argument);
    }

    @Override
    @NotNull
    public List<ValueArgument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("vararg:{");
        Iterator<ValueArgument> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ValueArgument valueArgument = iterator.next();
            JetExpression expression = valueArgument.getArgumentExpression();
            builder.append(expression == null ? "no expression" : expression.getText());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

