/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

class ValueArgumentsToParametersMapper {
    ValueArgumentsToParametersMapper() {
    }

    public static <D extends CallableDescriptor> Status mapValueArgumentsToParameters(@NotNull Call call, @NotNull TracingStrategy tracing, @NotNull ResolvedCallImpl<D> candidateCall, @NotNull Set<ValueArgument> unmappedArguments) {
        ValueParameterDescriptor valueParameterDescriptor;
        TemporaryBindingTrace temporaryTrace = candidateCall.getTrace();
        HashMap<ValueParameterDescriptor, VarargValueArgument> varargs = Maps.newHashMap();
        HashSet<ValueParameterDescriptor> usedParameters = Sets.newHashSet();
        D candidate = candidateCall.getCandidateDescriptor();
        List<ValueParameterDescriptor> valueParameters = candidate.getValueParameters();
        HashMap<Name, ValueParameterDescriptor> parameterByName = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            parameterByName.put(valueParameter.getName(), valueParameter);
        }
        List<? extends ValueArgument> valueArguments = call.getValueArguments();
        Status status = Status.OK;
        boolean someNamed = false;
        boolean somePositioned = false;
        for (int i = 0; i < valueArguments.size(); ++i) {
            ValueArgument valueArgument = valueArguments.get(i);
            if (valueArgument.isNamed()) {
                someNamed = true;
                JetSimpleNameExpression nameReference = valueArgument.getArgumentName().getReferenceExpression();
                valueParameterDescriptor = (ValueParameterDescriptor)parameterByName.get(nameReference.getReferencedNameAsName());
                if (valueParameterDescriptor == null) {
                    temporaryTrace.report(Errors.NAMED_PARAMETER_NOT_FOUND.on(nameReference));
                    unmappedArguments.add(valueArgument);
                    status = Status.WEAK_ERROR;
                } else {
                    temporaryTrace.record(BindingContext.REFERENCE_TARGET, nameReference, valueParameterDescriptor);
                    if (!usedParameters.add(valueParameterDescriptor)) {
                        temporaryTrace.report(Errors.ARGUMENT_PASSED_TWICE.on(nameReference));
                        unmappedArguments.add(valueArgument);
                        status = Status.WEAK_ERROR;
                    } else {
                        status = status.compose(ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, valueArgument, varargs));
                    }
                }
                if (!somePositioned) continue;
                temporaryTrace.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(nameReference));
                status = Status.WEAK_ERROR;
                continue;
            }
            somePositioned = true;
            if (someNamed) {
                temporaryTrace.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(valueArgument.asElement()));
                status = Status.WEAK_ERROR;
                continue;
            }
            int parameterCount = valueParameters.size();
            if (i < parameterCount) {
                valueParameterDescriptor = valueParameters.get(i);
                usedParameters.add(valueParameterDescriptor);
                status = status.compose(ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, valueArgument, varargs));
                continue;
            }
            if (!valueParameters.isEmpty()) {
                valueParameterDescriptor = valueParameters.get(valueParameters.size() - 1);
                if (valueParameterDescriptor.getVarargElementType() != null) {
                    status = status.compose(ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, valueArgument, varargs));
                    usedParameters.add(valueParameterDescriptor);
                    continue;
                }
                temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on(valueArgument.asElement(), (CallableDescriptor)candidate));
                unmappedArguments.add(valueArgument);
                status = Status.WEAK_ERROR;
                continue;
            }
            temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on(valueArgument.asElement(), (CallableDescriptor)candidate));
            unmappedArguments.add(valueArgument);
            status = Status.ERROR;
        }
        List<JetExpression> functionLiteralArguments = call.getFunctionLiteralArguments();
        if (!functionLiteralArguments.isEmpty()) {
            JetExpression possiblyLabeledFunctionLiteral = functionLiteralArguments.get(0);
            if (valueParameters.isEmpty()) {
                temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on(possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                status = Status.ERROR;
            } else {
                JetFunctionLiteralExpression functionLiteral;
                if (possiblyLabeledFunctionLiteral instanceof JetLabelQualifiedExpression) {
                    JetLabelQualifiedExpression labeledFunctionLiteral = (JetLabelQualifiedExpression)possiblyLabeledFunctionLiteral;
                    functionLiteral = (JetFunctionLiteralExpression)labeledFunctionLiteral.getLabeledExpression();
                } else {
                    functionLiteral = (JetFunctionLiteralExpression)possiblyLabeledFunctionLiteral;
                }
                valueParameterDescriptor = valueParameters.get(valueParameters.size() - 1);
                if (valueParameterDescriptor.getVarargElementType() != null) {
                    temporaryTrace.report(Errors.VARARG_OUTSIDE_PARENTHESES.on(possiblyLabeledFunctionLiteral));
                    status = Status.ERROR;
                } else if (!usedParameters.add(valueParameterDescriptor)) {
                    temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on(possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                    status = Status.WEAK_ERROR;
                } else {
                    status = status.compose(ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, CallMaker.makeValueArgument(functionLiteral), varargs));
                }
            }
            for (int i = 1; i < functionLiteralArguments.size(); ++i) {
                JetExpression argument = functionLiteralArguments.get(i);
                temporaryTrace.report(Errors.MANY_FUNCTION_LITERAL_ARGUMENTS.on(argument));
                status = Status.WEAK_ERROR;
            }
        }
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            if (usedParameters.contains(valueParameter)) continue;
            if (valueParameter.hasDefaultValue()) {
                candidateCall.recordValueArgument(valueParameter, DefaultValueArgument.DEFAULT);
                continue;
            }
            if (valueParameter.getVarargElementType() != null) {
                candidateCall.recordValueArgument(valueParameter, new VarargValueArgument());
                continue;
            }
            tracing.noValueForParameter(temporaryTrace, valueParameter);
            status = Status.ERROR;
        }
        ReceiverDescriptor receiverParameter = candidate.getReceiverParameter();
        ReceiverDescriptor receiverArgument = candidateCall.getReceiverArgument();
        if (receiverParameter.exists() && !receiverArgument.exists()) {
            tracing.missingReceiver(temporaryTrace, receiverParameter);
            status = Status.ERROR;
        }
        if (!receiverParameter.exists() && receiverArgument.exists()) {
            tracing.noReceiverAllowed(temporaryTrace);
            status = call.getCalleeExpression() instanceof JetSimpleNameExpression ? Status.STRONG_ERROR : Status.ERROR;
        }
        assert (candidateCall.getThisObject().exists() == candidateCall.getResultingDescriptor().getExpectedThisObject().exists()) : "Shouldn't happen because of TaskPrioritizer: " + candidateCall.getCandidateDescriptor();
        return status;
    }

    private static <D extends CallableDescriptor> Status put(ResolvedCallImpl<D> candidateCall, ValueParameterDescriptor valueParameterDescriptor, ValueArgument valueArgument, Map<ValueParameterDescriptor, VarargValueArgument> varargs) {
        Status error = Status.OK;
        if (valueParameterDescriptor.getVarargElementType() != null) {
            VarargValueArgument vararg = varargs.get(valueParameterDescriptor);
            if (vararg == null) {
                vararg = new VarargValueArgument();
                varargs.put(valueParameterDescriptor, vararg);
                candidateCall.recordValueArgument(valueParameterDescriptor, vararg);
            }
            vararg.addArgument(valueArgument);
        } else {
            LeafPsiElement spread = valueArgument.getSpreadElement();
            if (spread != null) {
                candidateCall.getTrace().report(Errors.NON_VARARG_SPREAD.on(spread));
                error = Status.WEAK_ERROR;
            }
            ExpressionValueArgument argument = new ExpressionValueArgument(valueArgument);
            candidateCall.recordValueArgument(valueParameterDescriptor, argument);
        }
        return error;
    }

    public static enum Status {
        STRONG_ERROR(false),
        ERROR(false),
        WEAK_ERROR(false),
        OK(true);

        private final boolean success;

        private Status(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Status compose(Status other) {
            if (this == STRONG_ERROR || other == STRONG_ERROR) {
                return STRONG_ERROR;
            }
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == WEAK_ERROR || other == WEAK_ERROR) {
                return WEAK_ERROR;
            }
            return this;
        }
    }
}

