/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.BasicResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.calls.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTaskHolder;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

abstract class TaskPrioritizer {
    TaskPrioritizer() {
    }

    public static <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@NotNull Collection<ResolutionCandidate<D>> allDescriptors, @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @NotNull Collection<ResolutionCandidate<D>> local, @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        for (ResolutionCandidate<D> resolvedCall : allDescriptors) {
            if (DescriptorUtils.isLocal(containerOfTheCurrentLocality, resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @Nullable
    static JetSuperExpression getReceiverSuper(@NotNull ReceiverDescriptor receiver) {
        ExpressionReceiver expressionReceiver;
        JetExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = (expressionReceiver = (ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    @NotNull
    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@NotNull BasicResolutionContext context, @NotNull Name name, @NotNull JetReferenceExpression functionReference, @NotNull List<CallableDescriptorCollector<? extends D>> callableDescriptorCollectors) {
        JetScope scope;
        ReceiverDescriptor explicitReceiver = context.call.getExplicitReceiver();
        if (explicitReceiver.exists() && explicitReceiver.getType() instanceof NamespaceType) {
            scope = explicitReceiver.getType().getMemberScope();
            explicitReceiver = ReceiverDescriptor.NO_RECEIVER;
        } else {
            scope = context.scope;
        }
        Predicate visibleStrategy = new Predicate<ResolutionCandidate<D>>(){

            @Override
            public boolean apply(@Nullable ResolutionCandidate<D> call) {
                if (call == null) {
                    return false;
                }
                Object candidateDescriptor = call.getDescriptor();
                if (ErrorUtils.isError(candidateDescriptor)) {
                    return true;
                }
                return Visibilities.isVisible(candidateDescriptor, scope.getContainingDeclaration());
            }
        };
        ResolutionTaskHolder result = new ResolutionTaskHolder(functionReference, context, visibleStrategy);
        for (CallableDescriptorCollector<D> callableDescriptorCollector : callableDescriptorCollectors) {
            TaskPrioritizer.doComputeTasks(scope, explicitReceiver, name, result, context, callableDescriptorCollector);
        }
        return result.getTasks();
    }

    private static <D extends CallableDescriptor, F extends D> void doComputeTasks(@NotNull JetScope scope, @NotNull ReceiverDescriptor receiver, @NotNull Name name, @NotNull ResolutionTaskHolder<D, F> result, @NotNull BasicResolutionContext context, @NotNull CallableDescriptorCollector<? extends D> callableDescriptorCollector) {
        AutoCastServiceImpl autoCastService = new AutoCastServiceImpl(context.dataFlowInfo, context.trace.getBindingContext());
        ArrayList<ReceiverDescriptor> implicitReceivers = Lists.newArrayList();
        scope.getImplicitReceiversHierarchy(implicitReceivers);
        boolean hasExplicitThisObject = context.call.getThisObject().exists();
        if (hasExplicitThisObject) {
            implicitReceivers.add(context.call.getThisObject());
        }
        if (receiver.exists()) {
            List<ReceiverDescriptor> variantsForExplicitReceiver = autoCastService.getVariantsForReceiver(receiver);
            Collection<ResolutionCandidate<D>> extensionFunctions = TaskPrioritizer.convertWithImpliedThis(scope, variantsForExplicitReceiver, callableDescriptorCollector.getNonMembersByName(scope, name));
            ArrayList<ResolutionCandidate<D>> nonlocals = Lists.newArrayList();
            ArrayList<ResolutionCandidate<D>> locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(extensionFunctions, scope.getContainingDeclaration(), locals, nonlocals);
            ArrayList members = Lists.newArrayList();
            for (ReceiverDescriptor variant : variantsForExplicitReceiver) {
                Collection<? extends D> membersForThisVariant = callableDescriptorCollector.getMembersByName(variant.getType(), name);
                TaskPrioritizer.convertWithReceivers(membersForThisVariant, Collections.singletonList(variant), Collections.singletonList(ReceiverDescriptor.NO_RECEIVER), members, hasExplicitThisObject);
            }
            result.addLocalExtensions(locals);
            result.addMembers(members);
            for (ReceiverDescriptor implicitReceiver : implicitReceivers) {
                Collection<? extends D> memberExtensions = callableDescriptorCollector.getNonMembersByName(implicitReceiver.getType().getMemberScope(), name);
                List<ReceiverDescriptor> variantsForImplicitReceiver = autoCastService.getVariantsForReceiver(implicitReceiver);
                result.addNonLocalExtensions(TaskPrioritizer.convertWithReceivers(memberExtensions, variantsForImplicitReceiver, variantsForExplicitReceiver, hasExplicitThisObject));
            }
            result.addNonLocalExtensions(nonlocals);
        } else {
            Collection<ResolutionCandidate<D>> functions = TaskPrioritizer.convertWithImpliedThis(scope, Collections.singletonList(receiver), callableDescriptorCollector.getNonExtensionsByName(scope, name));
            ArrayList<ResolutionCandidate<D>> nonlocals = Lists.newArrayList();
            ArrayList<ResolutionCandidate<D>> locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(functions, scope.getContainingDeclaration(), locals, nonlocals);
            result.addLocalExtensions(locals);
            result.addNonLocalExtensions(nonlocals);
            for (ReceiverDescriptor implicitReceiver : implicitReceivers) {
                TaskPrioritizer.doComputeTasks(scope, implicitReceiver, name, result, context, callableDescriptorCollector);
            }
        }
    }

    private static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(Collection<? extends D> descriptors, Iterable<ReceiverDescriptor> thisObjects, Iterable<ReceiverDescriptor> receiverParameters, boolean hasExplicitThisObject) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        TaskPrioritizer.convertWithReceivers(descriptors, thisObjects, receiverParameters, result, hasExplicitThisObject);
        return result;
    }

    private static <D extends CallableDescriptor> void convertWithReceivers(Collection<? extends D> descriptors, Iterable<ReceiverDescriptor> thisObjects, Iterable<ReceiverDescriptor> receiverParameters, Collection<ResolutionCandidate<D>> result, boolean hasExplicitThisObject) {
        for (ReceiverDescriptor thisObject : thisObjects) {
            for (ReceiverDescriptor receiverParameter : receiverParameters) {
                for (CallableDescriptor extension : descriptors) {
                    ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(extension);
                    candidate.setThisObject(thisObject);
                    candidate.setReceiverArgument(receiverParameter);
                    candidate.setExplicitReceiverKind(hasExplicitThisObject ? ExplicitReceiverKind.BOTH_RECEIVERS : ExplicitReceiverKind.THIS_OBJECT);
                    result.add(candidate);
                }
            }
        }
    }

    public static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(JetScope scope, Collection<ReceiverDescriptor> receiverParameters, Collection<? extends D> descriptors) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        for (ReceiverDescriptor receiverParameter : receiverParameters) {
            for (CallableDescriptor descriptor : descriptors) {
                ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(descriptor);
                candidate.setReceiverArgument(receiverParameter);
                candidate.setExplicitReceiverKind(receiverParameter.exists() ? ExplicitReceiverKind.RECEIVER_ARGUMENT : ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
                if (!TaskPrioritizer.setImpliedThis(scope, candidate)) continue;
                result.add(candidate);
            }
        }
        if (receiverParameters.size() == 1 && !receiverParameters.iterator().next().exists()) {
            for (CallableDescriptor descriptor : descriptors) {
                if (!descriptor.getExpectedThisObject().exists() || descriptor.getReceiverParameter().exists()) continue;
                DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
                if (descriptor instanceof ConstructorDescriptor) {
                    assert (containingDeclaration != null);
                    containingDeclaration = containingDeclaration.getContainingDeclaration();
                }
                if (!(containingDeclaration instanceof ClassDescriptor) || !DescriptorUtils.isClassObject(containingDeclaration)) continue;
                ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(descriptor);
                candidate.setThisObject(new ClassReceiver((ClassDescriptor)containingDeclaration));
                candidate.setExplicitReceiverKind(ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
                result.add(candidate);
            }
        }
        return result;
    }

    private static <D extends CallableDescriptor> boolean setImpliedThis(@NotNull JetScope scope, ResolutionCandidate<D> candidate) {
        ReceiverDescriptor expectedThisObject = candidate.getDescriptor().getExpectedThisObject();
        if (!expectedThisObject.exists()) {
            return true;
        }
        ArrayList<ReceiverDescriptor> receivers = Lists.newArrayList();
        scope.getImplicitReceiversHierarchy(receivers);
        for (ReceiverDescriptor receiver : receivers) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(receiver.getType(), expectedThisObject.getType())) continue;
            candidate.setThisObject(expectedThisObject);
            return true;
        }
        return false;
    }
}

