/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements ResolvedCallWithTrace<D> {
    public static final Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_CANDIDATE = new Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor>(){

        @Override
        public CallableDescriptor fun(ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getCandidateDescriptor();
        }
    };
    public static final Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_RESULT = new Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor>(){

        @Override
        public CallableDescriptor fun(ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getResultingDescriptor();
        }
    };
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private final ReceiverDescriptor thisObject;
    private final ReceiverDescriptor receiverArgument;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final boolean isSafeCall;
    private final Map<TypeParameterDescriptor, JetType> typeArguments = Maps.newLinkedHashMap();
    private final Map<ValueParameterDescriptor, JetType> autoCasts = Maps.newHashMap();
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = Maps.newHashMap();
    private boolean someArgumentHasNoType = false;
    private TemporaryBindingTrace trace;
    private ResolutionStatus status = ResolutionStatus.UNKNOWN_STATUS;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull ResolutionCandidate<D> candidate, @NotNull TemporaryBindingTrace trace) {
        return new ResolvedCallImpl<D>(candidate, trace);
    }

    private ResolvedCallImpl(@NotNull ResolutionCandidate<D> candidate, @NotNull TemporaryBindingTrace trace) {
        this.candidateDescriptor = candidate.getDescriptor();
        this.thisObject = candidate.getThisObject();
        this.receiverArgument = candidate.getReceiverArgument();
        this.explicitReceiverKind = candidate.getExplicitReceiverKind();
        this.isSafeCall = candidate.isSafeCall();
        this.trace = trace;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        return this.status;
    }

    public void addStatus(@NotNull ResolutionStatus status) {
        this.status = this.status.combine(status);
    }

    @Override
    @NotNull
    public TemporaryBindingTrace getTrace() {
        return this.trace;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        return this.candidateDescriptor;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
    }

    public ResolvedCallImpl<D> setResultingDescriptor(@NotNull D resultingDescriptor) {
        this.resultingDescriptor = resultingDescriptor;
        return this;
    }

    public void recordTypeArgument(@NotNull TypeParameterDescriptor typeParameter, @NotNull JetType typeArgument) {
        assert (!this.typeArguments.containsKey(typeParameter)) : typeParameter + " -> " + typeArgument;
        this.typeArguments.put(typeParameter, typeArgument);
    }

    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        assert (!this.valueArguments.containsKey(valueParameter)) : valueParameter + " -> " + valueArgument;
        this.valueArguments.put(valueParameter, valueArgument);
    }

    public void autoCastValueArgument(@NotNull ValueParameterDescriptor parameter, @NotNull JetType target) {
        assert (!this.autoCasts.containsKey(parameter));
        this.autoCasts.put(parameter, target);
    }

    @Override
    @NotNull
    public ReceiverDescriptor getReceiverArgument() {
        return this.receiverArgument;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getThisObject() {
        return this.thisObject;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        return this.valueArguments;
    }

    @Override
    @NotNull
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            if (arguments.set(entry.getKey().getIndex(), entry.getValue()) == null) continue;
            throw new IllegalStateException();
        }
        for (ResolvedValueArgument o : arguments) {
            if (o != null) continue;
            throw new IllegalStateException();
        }
        return arguments;
    }

    public void argumentHasNoType() {
        this.someArgumentHasNoType = true;
    }

    @Override
    public boolean isDirty() {
        return this.someArgumentHasNoType;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public boolean isSafeCall() {
        return this.isSafeCall;
    }
}

