/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.base.Predicates;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.calls.BasicResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.TaskPrioritizer;

public class ResolutionTaskHolder<D extends CallableDescriptor, F extends D> {
    private final JetReferenceExpression reference;
    private final BasicResolutionContext basicResolutionContext;
    private final Predicate<ResolutionCandidate<D>> visibleStrategy;
    private final boolean isSafeCall;
    private final Collection<Collection<ResolutionCandidate<D>>> localExtensions = Sets.newLinkedHashSet();
    private final Collection<Collection<ResolutionCandidate<D>>> members = Sets.newLinkedHashSet();
    private final Collection<Collection<ResolutionCandidate<D>>> nonLocalExtensions = Sets.newLinkedHashSet();
    private List<ResolutionTask<D, F>> tasks = null;

    public ResolutionTaskHolder(@NotNull JetReferenceExpression reference, @NotNull BasicResolutionContext basicResolutionContext, @NotNull Predicate<ResolutionCandidate<D>> visibleStrategy) {
        this.reference = reference;
        this.basicResolutionContext = basicResolutionContext;
        this.visibleStrategy = visibleStrategy;
        this.isSafeCall = JetPsiUtil.isSafeCall(basicResolutionContext.call);
    }

    public Collection<ResolutionCandidate<D>> setIsSafeCall(@NotNull Collection<ResolutionCandidate<D>> candidates) {
        for (ResolutionCandidate<D> candidate : candidates) {
            candidate.setSafeCall(this.isSafeCall);
        }
        return candidates;
    }

    public void addLocalExtensions(@NotNull Collection<ResolutionCandidate<D>> candidates) {
        if (!candidates.isEmpty()) {
            this.localExtensions.add(this.setIsSafeCall(candidates));
        }
    }

    public void addMembers(@NotNull Collection<ResolutionCandidate<D>> candidates) {
        if (!candidates.isEmpty()) {
            this.members.add(this.setIsSafeCall(candidates));
        }
    }

    public void addNonLocalExtensions(@NotNull Collection<ResolutionCandidate<D>> candidates) {
        if (!candidates.isEmpty()) {
            this.nonLocalExtensions.add(this.setIsSafeCall(candidates));
        }
    }

    public List<ResolutionTask<D, F>> getTasks() {
        if (this.tasks == null) {
            this.tasks = Lists.newArrayList();
            ArrayList<Collection<ResolutionCandidate<D>>> candidateList = Lists.newArrayList();
            if (TaskPrioritizer.getReceiverSuper(this.basicResolutionContext.call.getExplicitReceiver()) != null) {
                candidateList.addAll(this.members);
                candidateList.addAll(this.localExtensions);
            } else {
                candidateList.addAll(this.localExtensions);
                candidateList.addAll(this.members);
            }
            candidateList.addAll(this.nonLocalExtensions);
            for (Predicate visibilityStrategy : Lists.newArrayList(this.visibleStrategy, Predicates.not(this.visibleStrategy))) {
                for (Collection collection : candidateList) {
                    Collection filteredCandidates = Collections2.filter(collection, visibilityStrategy);
                    if (filteredCandidates.isEmpty()) continue;
                    this.tasks.add(new ResolutionTask(filteredCandidates, this.reference, this.basicResolutionContext));
                }
            }
        }
        return this.tasks;
    }
}

