/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.BasicResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.SolutionStatus;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class ResolutionTask<D extends CallableDescriptor, F extends D>
extends ResolutionContext {
    private final Collection<ResolutionCandidate<D>> candidates;
    private final Set<ResolvedCallWithTrace<F>> resolvedCalls = Sets.newLinkedHashSet();
    final JetReferenceExpression reference;
    private DescriptorCheckStrategy checkingStrategy;
    public final TracingStrategy tracing = new TracingStrategy(){

        @Override
        public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
            Object descriptor = resolvedCall.getResultingDescriptor();
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                descriptor = ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall().getResultingDescriptor();
            }
            trace.record(BindingContext.REFERENCE_TARGET, ResolutionTask.this.reference, descriptor);
        }

        @Override
        public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
            trace.record(BindingContext.RESOLVED_CALL, ResolutionTask.this.call.getCalleeExpression(), resolvedCall);
        }

        @Override
        public <D extends CallableDescriptor> void recordAmbiguity(BindingTrace trace, Collection<ResolvedCallWithTrace<D>> candidates) {
            HashSet descriptors = Sets.newHashSet();
            for (ResolvedCallWithTrace<D> candidate : candidates) {
                descriptors.add(candidate.getCandidateDescriptor());
            }
            trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, ResolutionTask.this.reference, descriptors);
        }

        @Override
        public void unresolvedReference(@NotNull BindingTrace trace) {
            trace.report(Errors.UNRESOLVED_REFERENCE.on(ResolutionTask.this.reference));
        }

        @Override
        public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
            JetValueArgumentList valueArgumentList = ResolutionTask.this.call.getValueArgumentList();
            JetElement reportOn = valueArgumentList != null ? valueArgumentList : ResolutionTask.this.reference;
            trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter));
        }

        @Override
        public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverDescriptor expectedReceiver) {
            trace.report(Errors.MISSING_RECEIVER.on(ResolutionTask.this.reference, expectedReceiver.getType()));
        }

        @Override
        public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverDescriptor receiverParameter, @NotNull ReceiverDescriptor receiverArgument) {
            if (receiverArgument instanceof ExpressionReceiver) {
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverArgument;
                trace.report(Errors.TYPE_MISMATCH.on(expressionReceiver.getExpression(), receiverParameter.getType(), receiverArgument.getType()));
            } else {
                trace.report(Errors.TYPE_MISMATCH.on(ResolutionTask.this.reference, receiverParameter.getType(), receiverArgument.getType()));
            }
        }

        @Override
        public void noReceiverAllowed(@NotNull BindingTrace trace) {
            trace.report(Errors.NO_RECEIVER_ADMITTED.on(ResolutionTask.this.reference));
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
            JetTypeArgumentList typeArgumentList = ResolutionTask.this.call.getTypeArgumentList();
            if (typeArgumentList != null) {
                trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList, expectedTypeArgumentCount));
            } else {
                trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(ResolutionTask.this.reference, expectedTypeArgumentCount));
            }
        }

        @Override
        public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
            trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(ResolutionTask.this.call.getCallElement(), descriptors));
        }

        @Override
        public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
            trace.report(Errors.NONE_APPLICABLE.on(ResolutionTask.this.reference, descriptors));
        }

        @Override
        public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
            trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(ResolutionTask.this.call.getCallElement()));
        }

        @Override
        public void typeInferenceFailed(@NotNull BindingTrace trace, SolutionStatus status) {
            assert (!status.isSuccessful());
            trace.report(Errors.TYPE_INFERENCE_FAILED.on(ResolutionTask.this.call.getCallElement(), status));
        }

        @Override
        public void unsafeCall(@NotNull BindingTrace trace, @NotNull JetType type, boolean isCallForImplicitInvoke) {
            ASTNode callOperationNode = ResolutionTask.this.call.getCallOperationNode();
            if (callOperationNode != null && !isCallForImplicitInvoke) {
                trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type));
            } else {
                PsiElement callElement = ResolutionTask.this.call.getCallElement();
                if (callElement instanceof JetBinaryExpression) {
                    JetBinaryExpression binaryExpression = (JetBinaryExpression)callElement;
                    JetSimpleNameExpression operationReference = binaryExpression.getOperationReference();
                    Name operationString = operationReference.getReferencedNameElementType() == JetTokens.IDENTIFIER ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((JetToken)operationReference.getReferencedNameElementType());
                    JetExpression right = binaryExpression.getRight();
                    if (right != null) {
                        trace.report(Errors.UNSAFE_INFIX_CALL.on(ResolutionTask.this.reference, binaryExpression.getLeft().getText(), operationString.getName(), right.getText()));
                    }
                } else {
                    trace.report(Errors.UNSAFE_CALL.on(ResolutionTask.this.reference, type));
                }
            }
        }

        @Override
        public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
            ASTNode callOperationNode = ResolutionTask.this.call.getCallOperationNode();
            assert (callOperationNode != null);
            trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type));
        }

        @Override
        public void danglingFunctionLiteralArgumentSuspected(@NotNull BindingTrace trace, @NotNull List<JetExpression> functionLiteralArguments) {
            for (JetExpression functionLiteralArgument : functionLiteralArguments) {
                trace.report(Errors.DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED.on(functionLiteralArgument));
            }
        }

        @Override
        public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptor descriptor) {
            trace.report(Errors.INVISIBLE_MEMBER.on(ResolutionTask.this.call.getCallElement(), descriptor, descriptor.getContainingDeclaration()));
        }
    };

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, BindingTrace trace, JetScope scope, Call call, JetType expectedType, DataFlowInfo dataFlowInfo) {
        super(trace, scope, call, expectedType, dataFlowInfo);
        this.candidates = candidates;
        this.reference = reference;
    }

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, @NotNull BasicResolutionContext context) {
        this(candidates, reference, context.trace, context.scope, context.call, context.expectedType, context.dataFlowInfo);
    }

    @NotNull
    public Collection<ResolutionCandidate<D>> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public Set<ResolvedCallWithTrace<F>> getResolvedCalls() {
        return this.resolvedCalls;
    }

    public void setCheckingStrategy(DescriptorCheckStrategy strategy) {
        this.checkingStrategy = strategy;
    }

    public boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
        return this.checkingStrategy == null || this.checkingStrategy.performAdvancedChecks(descriptor, trace, tracing);
    }

    public ResolutionTask<D, F> withTrace(BindingTrace newTrace) {
        ResolutionTask<D, F> newTask = new ResolutionTask<D, F>(this.candidates, this.reference, newTrace, this.scope, this.call, this.expectedType, this.dataFlowInfo);
        newTask.setCheckingStrategy(this.checkingStrategy);
        return newTask;
    }

    public static interface DescriptorCheckStrategy {
        public <D extends CallableDescriptor> boolean performAdvancedChecks(D var1, BindingTrace var2, TracingStrategy var3);
    }
}

