/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.EnumSet;

public final class ResolutionStatus
extends Enum<ResolutionStatus> {
    public static final /* enum */ ResolutionStatus UNKNOWN_STATUS = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus UNSAFE_CALL_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus OTHER_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus STRONG_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus SUCCESS = new ResolutionStatus(true);
    public static final EnumSet<ResolutionStatus>[] SEVERITY_LEVELS;
    private final boolean success;
    private int severityIndex = -1;
    private static final /* synthetic */ ResolutionStatus[] $VALUES;

    public static ResolutionStatus[] values() {
        return (ResolutionStatus[])$VALUES.clone();
    }

    public static ResolutionStatus valueOf(String name) {
        return Enum.valueOf(ResolutionStatus.class, name);
    }

    private ResolutionStatus(boolean success) {
        this.success = success;
    }

    private ResolutionStatus() {
        this(false);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ResolutionStatus combine(ResolutionStatus other) {
        if (this == UNKNOWN_STATUS || this.isSuccess()) {
            return other;
        }
        if (!other.isSuccess() && this.getSeverityIndex() < other.getSeverityIndex()) {
            return other;
        }
        return this;
    }

    private int getSeverityIndex() {
        if (this.severityIndex == -1) {
            for (int i = 0; i < SEVERITY_LEVELS.length; ++i) {
                if (!SEVERITY_LEVELS[i].contains((Object)this)) continue;
                this.severityIndex = i;
                break;
            }
        }
        assert (this.severityIndex >= 0);
        return this.severityIndex;
    }

    static {
        $VALUES = new ResolutionStatus[]{UNKNOWN_STATUS, UNSAFE_CALL_ERROR, OTHER_ERROR, STRONG_ERROR, SUCCESS};
        SEVERITY_LEVELS = new EnumSet[]{EnumSet.of(UNSAFE_CALL_ERROR), EnumSet.of(OTHER_ERROR), EnumSet.of(STRONG_ERROR)};
    }
}

