/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class ResolutionCandidate<D extends CallableDescriptor> {
    private final D candidateDescriptor;
    private ReceiverDescriptor thisObject;
    private ReceiverDescriptor receiverArgument;
    private ExplicitReceiverKind explicitReceiverKind;
    private Boolean isSafeCall;

    private ResolutionCandidate(@NotNull D descriptor, @NotNull ReceiverDescriptor thisObject, @NotNull ReceiverDescriptor receiverArgument, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable Boolean isSafeCall) {
        this.candidateDescriptor = descriptor;
        this.thisObject = thisObject;
        this.receiverArgument = receiverArgument;
        this.explicitReceiverKind = explicitReceiverKind;
        this.isSafeCall = isSafeCall;
    }

    static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull D descriptor) {
        return new ResolutionCandidate<D>(descriptor, ReceiverDescriptor.NO_RECEIVER, ReceiverDescriptor.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull D descriptor, boolean isSafeCall) {
        return ResolutionCandidate.create(descriptor, ReceiverDescriptor.NO_RECEIVER, ReceiverDescriptor.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, isSafeCall);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull D descriptor, @NotNull ReceiverDescriptor thisObject, @NotNull ReceiverDescriptor receiverArgument, @NotNull ExplicitReceiverKind explicitReceiverKind, boolean isSafeCall) {
        return new ResolutionCandidate<D>(descriptor, thisObject, receiverArgument, explicitReceiverKind, isSafeCall);
    }

    public void setThisObject(@NotNull ReceiverDescriptor thisObject) {
        this.thisObject = thisObject;
    }

    public void setReceiverArgument(@NotNull ReceiverDescriptor receiverArgument) {
        this.receiverArgument = receiverArgument;
    }

    public void setExplicitReceiverKind(@NotNull ExplicitReceiverKind explicitReceiverKind) {
        this.explicitReceiverKind = explicitReceiverKind;
    }

    @NotNull
    public D getDescriptor() {
        return this.candidateDescriptor;
    }

    @NotNull
    public ReceiverDescriptor getThisObject() {
        return this.thisObject;
    }

    @NotNull
    public ReceiverDescriptor getReceiverArgument() {
        return this.receiverArgument;
    }

    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.explicitReceiverKind;
    }

    @NotNull
    public static <D extends CallableDescriptor> List<ResolutionCandidate<D>> convertCollection(@NotNull Collection<? extends D> descriptors, boolean isSafeCall) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            result.add(ResolutionCandidate.create(descriptor, isSafeCall));
        }
        return result;
    }

    public void setSafeCall(boolean safeCall) {
        assert (this.isSafeCall == null);
        this.isSafeCall = safeCall;
    }

    public boolean isSafeCall() {
        assert (this.isSafeCall != null);
        return this.isSafeCall;
    }
}

