/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.gnu.trove.THashSet;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class OverloadingConflictResolver {
    @Nullable
    public <D extends CallableDescriptor> ResolvedCallWithTrace<D> findMaximallySpecific(Set<ResolvedCallWithTrace<D>> candidates, boolean discriminateGenericDescriptors) {
        THashSet<ResolvedCallWithTrace<D>> maximallySpecific = new THashSet<ResolvedCallWithTrace<D>>(new TObjectHashingStrategy<ResolvedCallWithTrace<D>>(){

            @Override
            public boolean equals(ResolvedCallWithTrace<D> o1, ResolvedCallWithTrace<D> o2) {
                return o1 == null ? o2 == null : o1.getResultingDescriptor().equals(o2.getResultingDescriptor());
            }

            @Override
            public int computeHashCode(ResolvedCallWithTrace<D> object) {
                return object == null ? 0 : object.getResultingDescriptor().hashCode();
            }
        });
        block0: for (ResolvedCallWithTrace<D> candidateCall : candidates) {
            Object me = candidateCall.getResultingDescriptor();
            for (ResolvedCallWithTrace<D> otherCall : candidates) {
                Object other = otherCall.getResultingDescriptor();
                if (other == me || this.moreSpecific((CallableDescriptor)me, (CallableDescriptor)other, discriminateGenericDescriptors) && !this.moreSpecific((CallableDescriptor)other, (CallableDescriptor)me, discriminateGenericDescriptors)) continue;
                continue block0;
            }
            maximallySpecific.add(candidateCall);
        }
        if (maximallySpecific.size() == 1) {
            ResolvedCallWithTrace result = (ResolvedCallWithTrace)maximallySpecific.iterator().next();
            result.getTrace().commit();
            return result;
        }
        return null;
    }

    private <Descriptor extends CallableDescriptor> boolean moreSpecific(Descriptor f, Descriptor g, boolean discriminateGenericDescriptors) {
        if (discriminateGenericDescriptors && !this.isGeneric(f) && this.isGeneric(g)) {
            return true;
        }
        if (OverridingUtil.overrides(f, g)) {
            return true;
        }
        if (OverridingUtil.overrides(g, f)) {
            return false;
        }
        ReceiverDescriptor receiverOfF = f.getReceiverParameter();
        ReceiverDescriptor receiverOfG = g.getReceiverParameter();
        if (f.getReceiverParameter().exists() && g.getReceiverParameter().exists() && !this.typeMoreSpecific(receiverOfF.getType(), receiverOfG.getType())) {
            return false;
        }
        List<ValueParameterDescriptor> fParams = f.getValueParameters();
        List<ValueParameterDescriptor> gParams = g.getValueParameters();
        int fSize = fParams.size();
        int gSize = gParams.size();
        boolean fIsVararg = this.isVariableArity(fParams);
        boolean gIsVararg = this.isVariableArity(gParams);
        if (!fIsVararg && gIsVararg) {
            return true;
        }
        if (fIsVararg && !gIsVararg) {
            return false;
        }
        if (!fIsVararg && !gIsVararg) {
            if (fSize != gSize) {
                return false;
            }
            for (int i = 0; i < fSize; ++i) {
                JetType gParamType;
                ValueParameterDescriptor fParam = fParams.get(i);
                ValueParameterDescriptor gParam = gParams.get(i);
                JetType fParamType = fParam.getType();
                if (this.typeMoreSpecific(fParamType, gParamType = gParam.getType())) continue;
                return false;
            }
        }
        if (fIsVararg && gIsVararg) {
            int minSize = Math.min(fSize, gSize);
            for (int i = 0; i < minSize - 1; ++i) {
                JetType gParamType;
                ValueParameterDescriptor fParam = fParams.get(i);
                ValueParameterDescriptor gParam = gParams.get(i);
                JetType fParamType = fParam.getType();
                if (this.typeMoreSpecific(fParamType, gParamType = gParam.getType())) continue;
                return false;
            }
            if (fSize < gSize) {
                ValueParameterDescriptor fParam = fParams.get(fSize - 1);
                JetType fParamType = fParam.getVarargElementType();
                assert (fParamType != null) : "fIsVararg guarantees this";
                for (int i = fSize - 1; i < gSize; ++i) {
                    ValueParameterDescriptor gParam = gParams.get(i);
                    if (this.typeMoreSpecific(fParamType, gParam.getType())) continue;
                    return false;
                }
            } else {
                ValueParameterDescriptor gParam = gParams.get(gSize - 1);
                JetType gParamType = gParam.getVarargElementType();
                assert (gParamType != null) : "gIsVararg guarantees this";
                for (int i = gSize - 1; i < fSize; ++i) {
                    ValueParameterDescriptor fParam = fParams.get(i);
                    if (this.typeMoreSpecific(fParam.getType(), gParamType)) continue;
                    return false;
                }
            }
        }
        if (discriminateGenericDescriptors && this.isGeneric(f)) {
            if (!this.isGeneric(g)) {
                return false;
            }
            return this.moreSpecific(DescriptorUtils.substituteBounds(f), DescriptorUtils.substituteBounds(g), false);
        }
        return true;
    }

    private boolean isVariableArity(List<ValueParameterDescriptor> fParams) {
        int fSize = fParams.size();
        return fSize > 0 && fParams.get(fSize - 1).getVarargElementType() != null;
    }

    private boolean isGeneric(CallableDescriptor f) {
        return !f.getOriginal().getTypeParameters().isEmpty();
    }

    private boolean typeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        return JetTypeChecker.INSTANCE.isSubtypeOf(specific, general) || this.numericTypeMoreSpecific(specific, general);
    }

    private boolean numericTypeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        JetStandardLibrary standardLibrary = JetStandardLibrary.getInstance();
        JetType _double = standardLibrary.getDoubleType();
        JetType _float = standardLibrary.getFloatType();
        JetType _long = standardLibrary.getLongType();
        JetType _int = standardLibrary.getIntType();
        JetType _byte = standardLibrary.getByteType();
        JetType _short = standardLibrary.getShortType();
        if (TypeUtils.equalTypes(specific, _double) && TypeUtils.equalTypes(general, _float)) {
            return true;
        }
        if (TypeUtils.equalTypes(specific, _int)) {
            if (TypeUtils.equalTypes(general, _long)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _byte)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _short)) {
                return true;
            }
        }
        return TypeUtils.equalTypes(specific, _short) && TypeUtils.equalTypes(general, _byte);
    }
}

