/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;

public class ExpressionValueArgument
implements ResolvedValueArgument {
    private final ValueArgument valueArgument;

    public ExpressionValueArgument(@Nullable ValueArgument valueArgument) {
        this.valueArgument = valueArgument;
    }

    @Nullable
    public ValueArgument getValueArgument() {
        return this.valueArgument;
    }

    @Override
    @NotNull
    public List<ValueArgument> getArguments() {
        if (this.valueArgument == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.valueArgument);
    }

    public String toString() {
        JetExpression expression = this.valueArgument.getArgumentExpression();
        return expression == null ? "no expression" : expression.getText();
    }
}

