/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;

public class CallableDescriptorCollectors {
    static CallableDescriptorCollector<FunctionDescriptor> FUNCTIONS = new CallableDescriptorCollector<FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getNonExtensionsByName(JetScope scope, Name name) {
            LinkedHashSet<FunctionDescriptor> functions = Sets.newLinkedHashSet(scope.getFunctions(name));
            Iterator iterator = functions.iterator();
            while (iterator.hasNext()) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)iterator.next();
                if (!functionDescriptor.getReceiverParameter().exists()) continue;
                iterator.remove();
            }
            this.addConstructors(scope, name, functions);
            return functions;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getMembersByName(@NotNull JetType receiverType, Name name) {
            JetScope receiverScope = receiverType.getMemberScope();
            HashSet<FunctionDescriptor> members = Sets.newHashSet(receiverScope.getFunctions(name));
            this.addConstructors(receiverScope, name, members);
            return members;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getNonMembersByName(JetScope scope, Name name) {
            return scope.getFunctions(name);
        }

        private void addConstructors(JetScope scope, Name name, Collection<FunctionDescriptor> functions) {
            ClassifierDescriptor classifier = scope.getClassifier(name);
            if (classifier instanceof ClassDescriptor && !ErrorUtils.isError(classifier.getTypeConstructor())) {
                ClassDescriptor classDescriptor = (ClassDescriptor)classifier;
                functions.addAll(classDescriptor.getConstructors());
            }
        }
    };
    static CallableDescriptorCollector<VariableDescriptor> VARIABLES = new CallableDescriptorCollector<VariableDescriptor>(){

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, Name name) {
            VariableDescriptor descriptor = scope.getLocalVariable(name);
            if (descriptor == null) {
                descriptor = DescriptorUtils.filterNonExtensionProperty(scope.getProperties(name));
            }
            if (descriptor == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(descriptor);
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiverType, Name name) {
            return receiverType.getMemberScope().getProperties(name);
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonMembersByName(JetScope scope, Name name) {
            LinkedHashSet<VariableDescriptor> result = Sets.newLinkedHashSet();
            VariableDescriptor localVariable = scope.getLocalVariable(name);
            if (localVariable != null) {
                result.add(localVariable);
            }
            result.addAll(scope.getProperties(name));
            return result;
        }
    };
    static CallableDescriptorCollector<VariableDescriptor> PROPERTIES = new CallableDescriptorCollector<VariableDescriptor>(){

        private Collection<VariableDescriptor> filterProperties(Collection<? extends VariableDescriptor> variableDescriptors) {
            ArrayList<VariableDescriptor> properties = Lists.newArrayList();
            for (VariableDescriptor variableDescriptor : variableDescriptors) {
                if (!(variableDescriptor instanceof PropertyDescriptor)) continue;
                properties.add(variableDescriptor);
            }
            return properties;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, Name name) {
            return this.filterProperties(VARIABLES.getNonExtensionsByName(scope, name));
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiver, Name name) {
            return this.filterProperties(VARIABLES.getMembersByName(receiver, name));
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonMembersByName(JetScope scope, Name name) {
            return this.filterProperties(VARIABLES.getNonMembersByName(scope, name));
        }
    };
    static List<CallableDescriptorCollector<? extends CallableDescriptor>> FUNCTIONS_AND_VARIABLES = Lists.newArrayList(FUNCTIONS, VARIABLES);
}

