/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.base.Function;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.ChainedTemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.BasicResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.DelegatingCall;
import org.jetbrains.jet.lang.resolve.calls.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;

public class CallTransformer<D extends CallableDescriptor, F extends D> {
    public static CallTransformer<VariableDescriptor, VariableDescriptor> PROPERTY_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<CallableDescriptor, FunctionDescriptor> FUNCTION_CALL_TRANSFORMER = new CallTransformer<CallableDescriptor, FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<CallResolutionContext<CallableDescriptor, FunctionDescriptor>> createCallContexts(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task, @NotNull TemporaryBindingTrace candidateTrace) {
            if (candidate.getDescriptor() instanceof FunctionDescriptor) {
                return super.createCallContexts(candidate, task, candidateTrace);
            }
            assert (candidate.getDescriptor() instanceof VariableDescriptor);
            boolean hasReceiver = candidate.getReceiverArgument().exists();
            Call variableCall = this.stripCallArguments(task);
            if (!hasReceiver) {
                CallResolutionContext<CallableDescriptor, FunctionDescriptor> context = CallResolutionContext.create(ResolvedCallImpl.create(candidate, candidateTrace), task, candidateTrace, task.tracing, variableCall);
                return Collections.singleton(context);
            }
            Call variableCallWithoutReceiver = this.stripReceiver(variableCall);
            CallResolutionContext<CallableDescriptor, FunctionDescriptor> contextWithReceiver = this.createContextWithChainedTrace(candidate, variableCall, candidateTrace, task);
            ResolutionCandidate<CallableDescriptor> candidateWithoutReceiver = ResolutionCandidate.create(candidate.getDescriptor(), candidate.getThisObject(), ReceiverDescriptor.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, false);
            CallResolutionContext<CallableDescriptor, FunctionDescriptor> contextWithoutReceiver = this.createContextWithChainedTrace(candidateWithoutReceiver, variableCallWithoutReceiver, candidateTrace, task);
            contextWithoutReceiver.receiverForVariableAsFunctionSecondCall = variableCall.getExplicitReceiver();
            return Lists.newArrayList(contextWithReceiver, contextWithoutReceiver);
        }

        private CallResolutionContext<CallableDescriptor, FunctionDescriptor> createContextWithChainedTrace(ResolutionCandidate<CallableDescriptor> candidate, Call call, TemporaryBindingTrace temporaryTrace, ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            ChainedTemporaryBindingTrace chainedTrace = ChainedTemporaryBindingTrace.create(temporaryTrace);
            ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(candidate, chainedTrace);
            return CallResolutionContext.create(resolvedCall, task, chainedTrace, task.tracing, call);
        }

        private Call stripCallArguments(@NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            return new DelegatingCall(task.call){

                @Override
                public JetValueArgumentList getValueArgumentList() {
                    return null;
                }

                @Override
                @NotNull
                public List<? extends ValueArgument> getValueArguments() {
                    return Collections.emptyList();
                }

                @Override
                @NotNull
                public List<JetExpression> getFunctionLiteralArguments() {
                    return Collections.emptyList();
                }

                @Override
                @NotNull
                public List<JetTypeProjection> getTypeArguments() {
                    return Collections.emptyList();
                }

                @Override
                public JetTypeArgumentList getTypeArgumentList() {
                    return null;
                }
            };
        }

        private Call stripReceiver(@NotNull Call variableCall) {
            return new DelegatingCall(variableCall){

                @Override
                @NotNull
                public ReceiverDescriptor getExplicitReceiver() {
                    return ReceiverDescriptor.NO_RECEIVER;
                }
            };
        }

        @Override
        @NotNull
        public Collection<ResolvedCallWithTrace<FunctionDescriptor>> transformCall(@NotNull CallResolutionContext<CallableDescriptor, FunctionDescriptor> context, @NotNull CallResolver callResolver, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            Object descriptor = context.candidateCall.getCandidateDescriptor();
            if (descriptor instanceof FunctionDescriptor) {
                return super.transformCall(context, callResolver, task);
            }
            assert (descriptor instanceof VariableDescriptor);
            JetType returnType = descriptor.getReturnType();
            if (returnType == null) {
                return Collections.emptyList();
            }
            final ResolvedCallImpl variableResolvedCall = context.candidateCall;
            Call functionCall = this.createFunctionCall(context, task, returnType);
            TemporaryBindingTrace variableCallTrace = context.candidateCall.getTrace();
            BasicResolutionContext basicResolutionContext = BasicResolutionContext.create(variableCallTrace, context.scope, functionCall, context.expectedType, context.dataFlowInfo);
            OverloadResolutionResults<FunctionDescriptor> results = callResolver.resolveCallWithGivenName(basicResolutionContext, task.reference, Name.identifier("invoke"));
            Collection calls = ((OverloadResolutionResultsImpl)results).getResultingCalls();
            return Collections2.transform(calls, new Function<ResolvedCallWithTrace<FunctionDescriptor>, ResolvedCallWithTrace<FunctionDescriptor>>(){

                @Override
                public ResolvedCallWithTrace<FunctionDescriptor> apply(ResolvedCallWithTrace<FunctionDescriptor> functionResolvedCall) {
                    return new VariableAsFunctionResolvedCall(functionResolvedCall, variableResolvedCall);
                }
            });
        }

        private Call createFunctionCall(final CallResolutionContext<CallableDescriptor, FunctionDescriptor> context, final ResolutionTask<CallableDescriptor, FunctionDescriptor> task, JetType returnType) {
            final ExpressionReceiver receiverFromVariable = new ExpressionReceiver(task.reference, returnType);
            final JetSimpleNameExpression invokeExpression = (JetSimpleNameExpression)JetPsiFactory.createExpression(task.call.getCallElement().getProject(), "invoke");
            return new CallForImplicitInvoke(task.call){

                @Override
                @NotNull
                public ReceiverDescriptor getExplicitReceiver() {
                    return context.receiverForVariableAsFunctionSecondCall;
                }

                @Override
                @NotNull
                public ReceiverDescriptor getThisObject() {
                    return receiverFromVariable;
                }

                @Override
                public JetExpression getCalleeExpression() {
                    return invokeExpression;
                }

                @Override
                @NotNull
                public PsiElement getCallElement() {
                    JetValueArgumentList list;
                    if (task.call.getCallElement() instanceof JetCallElement && (list = ((JetCallElement)task.call.getCallElement()).getValueArgumentList()) != null) {
                        return list;
                    }
                    return invokeExpression;
                }
            };
        }
    };

    private CallTransformer() {
    }

    @NotNull
    public Collection<CallResolutionContext<D, F>> createCallContexts(@NotNull ResolutionCandidate<D> candidate, @NotNull ResolutionTask<D, F> task, @NotNull TemporaryBindingTrace candidateTrace) {
        ResolvedCallImpl<D> candidateCall = ResolvedCallImpl.create(candidate, candidateTrace);
        return Collections.singleton(CallResolutionContext.create(candidateCall, task, candidateTrace, task.tracing));
    }

    @NotNull
    public Collection<ResolvedCallWithTrace<F>> transformCall(@NotNull CallResolutionContext<D, F> callResolutionContext, @NotNull CallResolver callResolver, @NotNull ResolutionTask<D, F> task) {
        return Collections.singleton(callResolutionContext.candidateCall);
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        public CallForImplicitInvoke(@NotNull Call delegate) {
            super(delegate);
        }
    }
}

