/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.BasicResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.CallTransformer;
import org.jetbrains.jet.lang.resolve.calls.CallableDescriptorCollectors;
import org.jetbrains.jet.lang.resolve.calls.DelegatingCall;
import org.jetbrains.jet.lang.resolve.calls.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.JetFakeReference;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.OverloadingConflictResolver;
import org.jetbrains.jet.lang.resolve.calls.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemWithPriorities;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.resolve.calls.inference.DebugConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class CallResolver {
    private static final JetType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    private final JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
    @NotNull
    private OverloadingConflictResolver overloadingConflictResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;

    @Inject
    public void setOverloadingConflictResolver(@NotNull OverloadingConflictResolver overloadingConflictResolver) {
        this.overloadingConflictResolver = overloadingConflictResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicResolutionContext context) {
        JetExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof JetSimpleNameExpression);
        JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        if (referencedName == null) {
            return OverloadResolutionResultsImpl.nameNotFound();
        }
        ArrayList callableDescriptorCollectors = Lists.newArrayList();
        if (nameExpression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            referencedName = Name.identifier(referencedName.getName().substring(1));
            callableDescriptorCollectors.add(CallableDescriptorCollectors.PROPERTIES);
        } else {
            callableDescriptorCollectors.add(CallableDescriptorCollectors.VARIABLES);
        }
        List prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context, referencedName, nameExpression, callableDescriptorCollectors);
        return this.doResolveCallOrGetCachedResults(BindingContext.RESOLUTION_RESULTS_FOR_PROPERTY, context, prioritizedTasks, CallTransformer.PROPERTY_CALL_TRANSFORMER, nameExpression);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BasicResolutionContext context, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        List tasks = TaskPrioritizer.computePrioritizedTasks(context, name, functionReference, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
        return this.doResolveCallOrGetCachedResults(BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION, context, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, functionReference);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo) {
        return this.resolveFunctionCall(BasicResolutionContext.create(trace, scope, call, expectedType, dataFlowInfo));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicResolutionContext context) {
        JetValueArgumentList reportAbsenceOn;
        void var4_9;
        List<Object> prioritizedTasks;
        JetExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression expression;
            JetSimpleNameExpression jetSimpleNameExpression = expression = (JetSimpleNameExpression)calleeExpression;
            Name name = expression.getReferencedNameAsName();
            if (name == null) {
                return this.checkArgumentTypesAndFail(context);
            }
            prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context, name, jetSimpleNameExpression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
            ResolutionTask.DescriptorCheckStrategy abstractConstructorCheck = new ResolutionTask.DescriptorCheckStrategy(){

                @Override
                public <D extends CallableDescriptor> boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
                    Modality modality;
                    if (descriptor instanceof ConstructorDescriptor && (modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()) == Modality.ABSTRACT) {
                        tracing.instantiationOfAbstractClass(trace);
                        return false;
                    }
                    return true;
                }
            };
            Iterator<Object> i$ = prioritizedTasks.iterator();
            while (i$.hasNext()) {
                ResolutionTask resolutionTask = (ResolutionTask)i$.next();
                resolutionTask.setCheckingStrategy(abstractConstructorCheck);
            }
            return this.doResolveCallOrGetCachedResults(BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
        }
        JetValueArgumentList valueArgumentList = context.call.getValueArgumentList();
        PsiElement psiElement = reportAbsenceOn = valueArgumentList == null ? context.call.getCallElement() : valueArgumentList;
        if (calleeExpression instanceof JetConstructorCalleeExpression) {
            assert (!context.call.getExplicitReceiver().exists());
            prioritizedTasks = Lists.newArrayList();
            JetConstructorCalleeExpression expression = (JetConstructorCalleeExpression)calleeExpression;
            JetReferenceExpression jetReferenceExpression = expression.getConstructorReferenceExpression();
            if (jetReferenceExpression == null) {
                return this.checkArgumentTypesAndFail(context);
            }
            JetTypeReference typeReference = expression.getTypeReference();
            assert (typeReference != null);
            JetType jetType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
            ClassifierDescriptor declarationDescriptor = jetType.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                context.trace.report(Errors.NOT_A_CLASS.on(calleeExpression));
                return this.checkArgumentTypesAndFail(context);
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            Set<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
            if (constructors.isEmpty()) {
                context.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                return this.checkArgumentTypesAndFail(context);
            }
            Collection candidates = TaskPrioritizer.convertWithImpliedThis(context.scope, Collections.singletonList(ReceiverDescriptor.NO_RECEIVER), constructors);
            Iterator<ResolutionCandidate<ConstructorDescriptor>> i$ = candidates.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    prioritizedTasks.add(new ResolutionTask(candidates, jetReferenceExpression, context));
                    return this.doResolveCallOrGetCachedResults(BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
                }
                ResolutionCandidate<ConstructorDescriptor> resolutionCandidate = i$.next();
                resolutionCandidate.setSafeCall(JetPsiUtil.isSafeCall(context.call));
            }
        }
        if (calleeExpression instanceof JetThisReferenceExpression) {
            JetThisReferenceExpression jetThisReferenceExpression = (JetThisReferenceExpression)calleeExpression;
            DeclarationDescriptor containingDeclaration = context.scope.getContainingDeclaration();
            if (containingDeclaration instanceof ConstructorDescriptor) {
                containingDeclaration = containingDeclaration.getContainingDeclaration();
            }
            assert (containingDeclaration instanceof ClassDescriptor);
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Set<ConstructorDescriptor> set = classDescriptor.getConstructors();
            if (set.isEmpty()) {
                context.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                return this.checkArgumentTypesAndFail(context);
            }
            List candidates = ResolutionCandidate.convertCollection(set, JetPsiUtil.isSafeCall(context.call));
            prioritizedTasks = Collections.singletonList(new ResolutionTask(candidates, jetThisReferenceExpression, context));
            return this.doResolveCallOrGetCachedResults(BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
        }
        if (calleeExpression == null) return this.checkArgumentTypesAndFail(context);
        JetType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        if (!JetStandardClasses.isFunctionType(calleeType)) {
            if (ErrorUtils.isErrorType(calleeType)) return this.checkArgumentTypesAndFail(context);
            context.trace.report(Errors.CALLEE_NOT_A_FUNCTION.on(calleeExpression, calleeType));
            return this.checkArgumentTypesAndFail(context);
        }
        ExpressionAsFunctionDescriptor functionDescriptor = new ExpressionAsFunctionDescriptor(context.scope.getContainingDeclaration(), Name.special("<for expression " + calleeExpression.getText() + ">"));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, calleeType, ReceiverDescriptor.NO_RECEIVER, Modality.FINAL, Visibilities.LOCAL);
        ResolutionCandidate<ExpressionAsFunctionDescriptor> resolutionCandidate = ResolutionCandidate.create(functionDescriptor, JetPsiUtil.isSafeCall(context.call));
        resolutionCandidate.setReceiverArgument(context.call.getExplicitReceiver());
        resolutionCandidate.setExplicitReceiverKind(ExplicitReceiverKind.RECEIVER_ARGUMENT);
        JetFakeReference jetFakeReference = new JetFakeReference(calleeExpression);
        prioritizedTasks = Collections.singletonList(new ResolutionTask(Collections.singleton(resolutionCandidate), jetFakeReference, context));
        return this.doResolveCallOrGetCachedResults(BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
    }

    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> doResolveCallOrGetCachedResults(@NotNull WritableSlice<CallKey, OverloadResolutionResults<F>> resolutionResultsSlice, @NotNull BasicResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull JetReferenceExpression reference) {
        OverloadResolutionResults<F> cachedResults;
        PsiElement element = context.call.getCallElement();
        if (element instanceof JetExpression && (cachedResults = context.trace.get(resolutionResultsSlice, CallKey.create(context.call.getCallType(), (JetExpression)element))) != null) {
            DelegatingBindingTrace delegatingTrace = context.trace.get(BindingContext.TRACE_DELTAS_CACHE, (JetExpression)element);
            assert (delegatingTrace != null);
            delegatingTrace.addAllMyDataTo(context.trace);
            return cachedResults;
        }
        TemporaryBindingTrace delegatingBindingTrace = TemporaryBindingTrace.create(context.trace);
        OverloadResolutionResults<F> results = this.doResolveCall(context.replaceTrace(delegatingBindingTrace), prioritizedTasks, callTransformer, reference);
        DelegatingBindingTrace cloneDelta = new DelegatingBindingTrace(new BindingTraceContext().getBindingContext());
        delegatingBindingTrace.addAllMyDataTo(cloneDelta);
        this.cacheResults(resolutionResultsSlice, context, results, cloneDelta);
        delegatingBindingTrace.commit();
        return results;
    }

    private <F extends CallableDescriptor> void cacheResults(@NotNull WritableSlice<CallKey, OverloadResolutionResults<F>> resolutionResultsSlice, @NotNull BasicResolutionContext context, @NotNull OverloadResolutionResults<F> results, @NotNull DelegatingBindingTrace delegatingBindingTrace) {
        boolean canBeCached = true;
        for (ResolvedCall<F> call : results.getResultingCalls()) {
            if (call.getCandidateDescriptor().getTypeParameters().isEmpty()) continue;
            canBeCached = false;
        }
        if (!canBeCached) {
            return;
        }
        PsiElement callElement = context.call.getCallElement();
        if (!(callElement instanceof JetExpression)) {
            return;
        }
        context.trace.record(resolutionResultsSlice, CallKey.create(context.call.getCallType(), (JetExpression)callElement), results);
        context.trace.record(BindingContext.TRACE_DELTAS_CACHE, (JetExpression)callElement, delegatingBindingTrace);
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> checkArgumentTypesAndFail(BasicResolutionContext context) {
        this.checkTypesWithNoCallee(context);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> doResolveCall(@NotNull BasicResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull JetReferenceExpression reference) {
        ResolutionDebugInfo.Data debugInfo = ResolutionDebugInfo.create();
        context.trace.record(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, context.call.getCallElement(), debugInfo);
        context.trace.record(BindingContext.RESOLUTION_SCOPE, context.call.getCalleeExpression(), context.scope);
        if (context.dataFlowInfo.hasTypeInfoConstraints()) {
            context.trace.record(BindingContext.NON_DEFAULT_EXPRESSION_DATA_FLOW, context.call.getCalleeExpression(), context.dataFlowInfo);
        }
        debugInfo.set(ResolutionDebugInfo.TASKS, prioritizedTasks);
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl<Object> resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D, F> task : prioritizedTasks) {
            TemporaryBindingTrace taskTrace;
            OverloadResolutionResultsImpl<F> results = this.performResolutionGuardedForExtraFunctionLiteralArguments(task.withTrace(taskTrace = TemporaryBindingTrace.create(context.trace)), callTransformer, context.trace);
            if (results.isSuccess() || results.isAmbiguity()) {
                taskTrace.commit();
                if (results.isSuccess()) {
                    debugInfo.set(ResolutionDebugInfo.RESULT, results.getResultingCall());
                }
                return results;
            }
            if (traceForFirstNonemptyCandidateSet != null || task.getCandidates().isEmpty() || results.isNothing()) continue;
            traceForFirstNonemptyCandidateSet = taskTrace;
            resultsForFirstNonemptyCandidateSet = results;
        }
        if (traceForFirstNonemptyCandidateSet != null) {
            traceForFirstNonemptyCandidateSet.commit();
            if (resultsForFirstNonemptyCandidateSet.isSingleResult()) {
                debugInfo.set(ResolutionDebugInfo.RESULT, resultsForFirstNonemptyCandidateSet.getResultingCall());
            }
        } else {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference));
            this.checkTypesWithNoCallee(context);
        }
        return resultsForFirstNonemptyCandidateSet != null ? resultsForFirstNonemptyCandidateSet : OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolutionGuardedForExtraFunctionLiteralArguments(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer, @NotNull BindingTrace traceForResolutionCache) {
        ResolutionTask newTask;
        OverloadResolutionResultsImpl resultsWithFunctionLiteralsStripped;
        OverloadResolutionResultsImpl<F> results = this.performResolution(task, callTransformer, traceForResolutionCache);
        EnumSet<OverloadResolutionResults.Code> someFailed = EnumSet.of(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH);
        if (someFailed.contains((Object)results.getResultCode()) && !task.call.getFunctionLiteralArguments().isEmpty() && ((resultsWithFunctionLiteralsStripped = this.performResolution(newTask = new ResolutionTask(task.getCandidates(), task.reference, TemporaryBindingTrace.create(task.trace), task.scope, new DelegatingCall(task.call){

            @Override
            @NotNull
            public List<JetExpression> getFunctionLiteralArguments() {
                return Collections.emptyList();
            }
        }, task.expectedType, task.dataFlowInfo), callTransformer, traceForResolutionCache)).isSuccess() || resultsWithFunctionLiteralsStripped.isAmbiguity())) {
            task.tracing.danglingFunctionLiteralArgumentSuspected(task.trace, task.call.getFunctionLiteralArguments());
        }
        return results;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolution(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer, @NotNull BindingTrace traceForResolutionCache) {
        for (ResolutionCandidate<D> resolutionCandidate : task.getCandidates()) {
            TemporaryBindingTrace candidateTrace = TemporaryBindingTrace.create(task.trace);
            Collection<CallResolutionContext<D, F>> contexts = callTransformer.createCallContexts(resolutionCandidate, task, candidateTrace);
            for (CallResolutionContext<D, F> context : contexts) {
                this.performResolutionForCandidateCall(context, task);
                task.tracing.bindReference(context.candidateCall.getTrace(), context.candidateCall);
                Collection<ResolvedCallWithTrace<F>> calls = callTransformer.transformCall(context, this, task);
                for (ResolvedCallWithTrace<F> call : calls) {
                    task.tracing.bindReference(call.getTrace(), call);
                    task.tracing.bindResolvedCall(call.getTrace(), call);
                    task.getResolvedCalls().add(call);
                }
                context.candidateCall.getTrace().addAllMyDataTo(traceForResolutionCache, new Predicate<WritableSlice>(){

                    @Override
                    public boolean apply(@Nullable WritableSlice slice) {
                        return slice == BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION || slice == BindingContext.RESOLUTION_RESULTS_FOR_PROPERTY || slice == BindingContext.TRACE_DELTAS_CACHE;
                    }
                }, false);
            }
        }
        LinkedHashSet<ResolvedCallWithTrace<D>> successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<ResolvedCallWithTrace<D>> failedCandidates = Sets.newLinkedHashSet();
        for (ResolvedCallWithTrace<F> candidateCall : task.getResolvedCalls()) {
            ResolutionStatus status = candidateCall.getStatus();
            if (status.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            assert (status != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (candidateCall.getStatus() == ResolutionStatus.STRONG_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        OverloadResolutionResultsImpl<D> results = this.computeResultAndReportErrors(task.trace, task.tracing, successfulCandidates, failedCandidates);
        if (!results.isSingleResult()) {
            this.checkTypesWithNoCallee(task.toBasic());
        }
        return results;
    }

    private <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallResolutionContext<D, F> context, @NotNull ResolutionTask<D, F> task) {
        List<JetTypeProjection> jetTypeArguments;
        ResolvedCallImpl<CallableDescriptor> candidateCall = context.candidateCall;
        Object candidate = candidateCall.getCandidateDescriptor();
        if (ErrorUtils.isError(candidate)) {
            candidateCall.addStatus(ResolutionStatus.SUCCESS);
            this.checkTypesWithNoCallee(context.toBasic());
            return;
        }
        if (!Visibilities.isVisible(candidate, context.scope.getContainingDeclaration())) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            context.tracing.invisibleMember(context.trace, (DeclarationDescriptor)candidate);
            return;
        }
        LinkedHashSet<ValueArgument> unmappedArguments = Sets.newLinkedHashSet();
        ValueArgumentsToParametersMapper.Status argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters(context.call, context.tracing, candidateCall, unmappedArguments);
        if (!argumentMappingStatus.isSuccess()) {
            if (argumentMappingStatus == ValueArgumentsToParametersMapper.Status.STRONG_ERROR) {
                candidateCall.addStatus(ResolutionStatus.STRONG_ERROR);
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            if (argumentMappingStatus != ValueArgumentsToParametersMapper.Status.WEAK_ERROR) {
                this.checkTypesWithNoCallee(context.toBasic());
                return;
            }
            this.checkUnmappedArgumentTypes(context.toBasic(), unmappedArguments);
        }
        if ((jetTypeArguments = context.call.getTypeArguments()).isEmpty()) {
            if (!candidate.getTypeParameters().isEmpty()) {
                candidateCall.addStatus(this.inferTypeArguments(context));
            } else {
                candidateCall.addStatus(this.checkAllValueArguments(context));
            }
        } else {
            ArrayList<JetType> typeArguments = new ArrayList<JetType>();
            for (JetTypeProjection projection : jetTypeArguments) {
                JetTypeReference typeReference;
                if (projection.getProjectionKind() != JetProjectionKind.NONE) {
                    context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                }
                if ((typeReference = projection.getTypeReference()) != null) {
                    typeArguments.add(this.typeResolver.resolveType(context.scope, typeReference, context.trace, true));
                    continue;
                }
                typeArguments.add(ErrorUtils.createErrorType("Star projection in a call"));
            }
            int expectedTypeArgumentCount = candidate.getTypeParameters().size();
            if (expectedTypeArgumentCount == jetTypeArguments.size()) {
                this.checkGenericBoundsInAFunctionCall(jetTypeArguments, (List<JetType>)typeArguments, (CallableDescriptor)candidate, context.trace);
                Map<TypeConstructor, TypeProjection> substitutionContext = FunctionDescriptorUtil.createSubstitutionContext((FunctionDescriptor)candidate, typeArguments);
                CallableDescriptor substitutedDescriptor = candidate.substitute(TypeSubstitutor.create(substitutionContext));
                candidateCall.setResultingDescriptor(substitutedDescriptor);
                CallResolver.replaceValueParametersWithSubstitutedOnes(candidateCall, substitutedDescriptor);
                List<TypeParameterDescriptor> typeParameters = candidateCall.getCandidateDescriptor().getTypeParameters();
                for (int i = 0; i < typeParameters.size(); ++i) {
                    TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
                    candidateCall.recordTypeArgument(typeParameterDescriptor, (JetType)typeArguments.get(i));
                }
                candidateCall.addStatus(this.checkAllValueArguments(context));
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                context.tracing.wrongNumberOfTypeArguments(context.trace, expectedTypeArgumentCount);
            }
        }
        task.performAdvancedChecks(candidate, context.trace, context.tracing);
        JetSuperExpression superExpression = TaskPrioritizer.getReceiverSuper(candidateCall.getReceiverArgument());
        if (superExpression != null) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(superExpression, superExpression.getText()));
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
        CallResolver.recordAutoCastIfNecessary(candidateCall.getReceiverArgument(), candidateCall.getTrace());
        CallResolver.recordAutoCastIfNecessary(candidateCall.getThisObject(), candidateCall.getTrace());
    }

    private <D extends CallableDescriptor, F extends D> ResolutionStatus inferTypeArguments(CallResolutionContext<D, F> context) {
        ConstraintSystemSolution solution;
        ResolvedCallImpl<CallableDescriptor> candidateCall = context.candidateCall;
        Object candidate = candidateCall.getCandidateDescriptor();
        ResolutionDebugInfo.Data debugInfo = context.trace.get(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, context.call.getCallElement());
        ConstraintSystemWithPriorities constraintSystem = new ConstraintSystemWithPriorities(new DebugConstraintResolutionListener(candidateCall, debugInfo));
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidate);
        for (TypeParameterDescriptor typeParameterDescriptor : candidateWithFreshVariables.getTypeParameters()) {
            constraintSystem.registerTypeVariable(typeParameterDescriptor, Variance.INVARIANT);
        }
        TypeSubstitutor substituteDontCare = ConstraintSystemWithPriorities.makeConstantSubstitutor(candidateWithFreshVariables.getTypeParameters(), DONT_CARE);
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidateWithFreshVariables.getValueParameters().get(entry.getKey().getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                JetType type;
                JetType effectiveExpectedType = this.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
                TemporaryBindingTrace traceForUnknown = TemporaryBindingTrace.create(context.trace);
                JetExpression argumentExpression = valueArgument.getArgumentExpression();
                JetType jetType = type = argumentExpression != null ? this.expressionTypingServices.getType(context.scope, argumentExpression, substituteDontCare.substitute(valueParameterDescriptor.getType(), Variance.INVARIANT), context.dataFlowInfo, traceForUnknown) : null;
                if (type != null && !ErrorUtils.isErrorType(type)) {
                    constraintSystem.addSubtypingConstraint(ConstraintType.VALUE_ARGUMENT.assertSubtyping(type, effectiveExpectedType));
                    continue;
                }
                candidateCall.argumentHasNoType();
            }
        }
        ReceiverDescriptor receiverArgument = candidateCall.getReceiverArgument();
        ReceiverDescriptor receiverParameter = candidateWithFreshVariables.getReceiverParameter();
        if (receiverArgument.exists() && receiverParameter.exists()) {
            constraintSystem.addSubtypingConstraint(ConstraintType.RECEIVER.assertSubtyping(receiverArgument.getType(), receiverParameter.getType()));
        }
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            constraintSystem.addSubtypingConstraint(ConstraintType.EXPECTED_TYPE.assertSubtyping(candidateWithFreshVariables.getReturnType(), context.expectedType));
        }
        if ((solution = constraintSystem.solve()).getStatus().isSuccessful()) {
            CallableDescriptor substitute = candidateWithFreshVariables.substitute(solution.getSubstitutor());
            assert (substitute != null);
            CallResolver.replaceValueParametersWithSubstitutedOnes(candidateCall, substitute);
            candidateCall.setResultingDescriptor(substitute);
            for (TypeParameterDescriptor typeParameterDescriptor : candidateCall.getCandidateDescriptor().getTypeParameters()) {
                candidateCall.recordTypeArgument(typeParameterDescriptor, solution.getValue(candidateWithFreshVariables.getTypeParameters().get(typeParameterDescriptor.getIndex())));
            }
            this.checkValueArgumentTypes(context);
            return ResolutionStatus.SUCCESS;
        }
        context.tracing.typeInferenceFailed(context.trace, solution.getStatus());
        return ResolutionStatus.OTHER_ERROR.combine(this.checkAllValueArguments(context));
    }

    private static void recordAutoCastIfNecessary(ReceiverDescriptor receiver, BindingTrace trace) {
        if (receiver instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)receiver;
            ReceiverDescriptor original = autoCastReceiver.getOriginal();
            if (original instanceof ExpressionReceiver) {
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)original;
                if (autoCastReceiver.canCast()) {
                    trace.record(BindingContext.AUTOCAST, expressionReceiver.getExpression(), autoCastReceiver.getType());
                } else {
                    trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expressionReceiver.getExpression(), autoCastReceiver.getType(), expressionReceiver.getExpression().getText()));
                }
            } else assert (autoCastReceiver.canCast()) : "A non-expression receiver must always be autocastabe: " + original;
        }
    }

    private void checkTypesWithNoCallee(BasicResolutionContext context) {
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            this.expressionTypingServices.getType(context.scope, argumentExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
        for (JetExpression jetExpression : context.call.getFunctionLiteralArguments()) {
            this.expressionTypingServices.getType(context.scope, jetExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
        for (JetTypeProjection jetTypeProjection : context.call.getTypeArguments()) {
            JetTypeReference typeReference = jetTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(jetTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    private void checkUnmappedArgumentTypes(BasicResolutionContext context, Set<ValueArgument> unmappedArguments) {
        for (ValueArgument valueArgument : unmappedArguments) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            this.expressionTypingServices.getType(context.scope, argumentExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
    }

    private static <D extends CallableDescriptor> void replaceValueParametersWithSubstitutedOnes(ResolvedCallImpl<D> candidateCall, @NotNull D substitutedDescriptor) {
        HashMap<ValueParameterDescriptor, ValueParameterDescriptor> parameterMap = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
            parameterMap.put(valueParameterDescriptor.getOriginal(), valueParameterDescriptor);
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = candidateCall.getValueArguments();
        HashMap<ValueParameterDescriptor, ResolvedValueArgument> originalValueArguments = Maps.newHashMap(valueArguments);
        valueArguments.clear();
        for (Map.Entry entry : originalValueArguments.entrySet()) {
            ValueParameterDescriptor substitutedVersion = (ValueParameterDescriptor)parameterMap.get(((ValueParameterDescriptor)entry.getKey()).getOriginal());
            assert (substitutedVersion != null) : (ValueParameterDescriptor)entry.getKey();
            valueArguments.put(substitutedVersion, (ResolvedValueArgument)entry.getValue());
        }
    }

    private <D extends CallableDescriptor, F extends D> ResolutionStatus checkAllValueArguments(CallResolutionContext<D, F> context) {
        ResolutionStatus result = this.checkValueArgumentTypes(context);
        ResolvedCallImpl candidateCall = context.candidateCall;
        result = result.combine(this.checkReceiver(context, candidateCall, candidateCall.getResultingDescriptor().getReceiverParameter(), candidateCall.getReceiverArgument(), candidateCall.getExplicitReceiverKind().isReceiver(), false));
        result = result.combine(this.checkReceiver(context, candidateCall, candidateCall.getResultingDescriptor().getExpectedThisObject(), candidateCall.getThisObject(), candidateCall.getExplicitReceiverKind().isThisObject(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        return result;
    }

    private <D extends CallableDescriptor, F extends D> ResolutionStatus checkReceiver(CallResolutionContext<D, F> context, ResolvedCall<D> candidateCall, ReceiverDescriptor receiverParameter, ReceiverDescriptor receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        ResolutionStatus result = ResolutionStatus.SUCCESS;
        if (receiverParameter.exists() && receiverArgument.exists()) {
            boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && candidateCall.isSafeCall();
            JetType receiverArgumentType = receiverArgument.getType();
            AutoCastServiceImpl autoCastService = new AutoCastServiceImpl(context.dataFlowInfo, context.candidateCall.getTrace().getBindingContext());
            if (!(safeAccess || receiverParameter.getType().isNullable() || autoCastService.isNotNull(receiverArgument))) {
                context.tracing.unsafeCall(context.candidateCall.getTrace(), receiverArgumentType, implicitInvokeCheck);
                result = ResolutionStatus.UNSAFE_CALL_ERROR;
            } else {
                JetType effectiveReceiverArgumentType;
                JetType jetType = effectiveReceiverArgumentType = safeAccess ? TypeUtils.makeNotNullable(receiverArgumentType) : receiverArgumentType;
                if (!this.typeChecker.isSubtypeOf(effectiveReceiverArgumentType, receiverParameter.getType())) {
                    context.tracing.wrongReceiverType(context.candidateCall.getTrace(), receiverParameter, receiverArgument);
                    result = ResolutionStatus.OTHER_ERROR;
                }
            }
            if (safeAccess && (receiverParameter.getType().isNullable() || !receiverArgumentType.isNullable())) {
                context.tracing.unnecessarySafeCall(context.candidateCall.getTrace(), receiverArgumentType);
            }
        }
        return result;
    }

    private <D extends CallableDescriptor, F extends D> ResolutionStatus checkValueArgumentTypes(CallResolutionContext<D, F> context) {
        ResolutionStatus result = ResolutionStatus.SUCCESS;
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : context.candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                JetExpression expression = argument.getArgumentExpression();
                if (expression == null) continue;
                JetType expectedType = this.getEffectiveExpectedType(parameterDescriptor, argument);
                JetType type = this.expressionTypingServices.getType(context.scope, expression, expectedType, context.dataFlowInfo, context.candidateCall.getTrace());
                if (type == null || ErrorUtils.isErrorType(type)) {
                    context.candidateCall.argumentHasNoType();
                    continue;
                }
                if (this.typeChecker.isSubtypeOf(type, expectedType)) continue;
                result = ResolutionStatus.OTHER_ERROR;
            }
        }
        return result;
    }

    @NotNull
    private JetType getEffectiveExpectedType(ValueParameterDescriptor parameterDescriptor, ValueArgument argument) {
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                return ErrorUtils.createErrorType("Don't care");
            }
            return parameterDescriptor.getType();
        }
        if (argument.isNamed()) {
            return parameterDescriptor.getType();
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType == null) {
            return parameterDescriptor.getType();
        }
        return varargElementType;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(BindingTrace trace, TracingStrategy tracing, Set<ResolvedCallWithTrace<D>> successfulCandidates, Set<ResolvedCallWithTrace<D>> failedCandidates) {
        if (successfulCandidates.size() > 0) {
            OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulCandidates, true);
            if (results.isAmbiguity()) {
                if (CallResolver.allClean(results.getResultingCalls())) {
                    tracing.ambiguity(trace, results.getResultingCalls());
                }
                tracing.recordAmbiguity(trace, results.getResultingCalls());
            }
            return results;
        }
        if (!failedCandidates.isEmpty()) {
            if (failedCandidates.size() != 1) {
                for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
                    LinkedHashSet<ResolvedCallWithTrace<D>> thisLevel = Sets.newLinkedHashSet();
                    for (ResolvedCallWithTrace<D> candidate : failedCandidates) {
                        if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                        thisLevel.add(candidate);
                    }
                    if (thisLevel.isEmpty()) continue;
                    OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false);
                    if (results.isSuccess()) {
                        results.getResultingCall().getTrace().commit();
                        return OverloadResolutionResultsImpl.singleFailedCandidate(results.getResultingCall());
                    }
                    tracing.noneApplicable(trace, results.getResultingCalls());
                    tracing.recordAmbiguity(trace, results.getResultingCalls());
                    return OverloadResolutionResultsImpl.manyFailedCandidates(results.getResultingCalls());
                }
                assert (false) : "Should not be reachable, cause every status must belong to some level";
                Set noOverrides = OverridingUtil.filterOverrides(failedCandidates, ResolvedCallImpl.MAP_TO_CANDIDATE);
                if (noOverrides.size() != 1) {
                    tracing.noneApplicable(trace, noOverrides);
                    tracing.recordAmbiguity(trace, noOverrides);
                    return OverloadResolutionResultsImpl.manyFailedCandidates(noOverrides);
                }
                failedCandidates = noOverrides;
            }
            ResolvedCallWithTrace<D> failed = failedCandidates.iterator().next();
            failed.getTrace().commit();
            return OverloadResolutionResultsImpl.singleFailedCandidate(failed);
        }
        tracing.unresolvedReference(trace);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    private static <D extends CallableDescriptor> boolean allClean(Collection<ResolvedCallWithTrace<D>> results) {
        for (ResolvedCallWithTrace<D> result : results) {
            if (!result.isDirty()) continue;
            return false;
        }
        return true;
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(Set<ResolvedCallWithTrace<D>> candidates, boolean discriminateGenerics) {
        if (candidates.size() != 1) {
            ResolvedCallWithTrace<D> maximallySpecificGenericsDiscriminated;
            ResolvedCallWithTrace<D> maximallySpecific;
            Set<ResolvedCallWithTrace<D>> cleanCandidates = Sets.newLinkedHashSet(candidates);
            Iterator iterator = cleanCandidates.iterator();
            while (iterator.hasNext()) {
                ResolvedCallWithTrace candidate = (ResolvedCallWithTrace)iterator.next();
                if (!candidate.isDirty()) continue;
                iterator.remove();
            }
            if (cleanCandidates.isEmpty()) {
                cleanCandidates = candidates;
            }
            if ((maximallySpecific = this.overloadingConflictResolver.findMaximallySpecific(cleanCandidates, false)) != null) {
                return OverloadResolutionResultsImpl.success(maximallySpecific);
            }
            if (discriminateGenerics && (maximallySpecificGenericsDiscriminated = this.overloadingConflictResolver.findMaximallySpecific(cleanCandidates, true)) != null) {
                return OverloadResolutionResultsImpl.success(maximallySpecificGenericsDiscriminated);
            }
            Set noOverrides = OverridingUtil.filterOverrides(candidates, ResolvedCallImpl.MAP_TO_RESULT);
            return OverloadResolutionResultsImpl.ambiguity(noOverrides);
        }
        ResolvedCallWithTrace<D> result = candidates.iterator().next();
        TemporaryBindingTrace temporaryTrace = result.getTrace();
        temporaryTrace.commit();
        return OverloadResolutionResultsImpl.success(result);
    }

    private void checkGenericBoundsInAFunctionCall(List<JetTypeProjection> jetTypeArguments, List<JetType> typeArguments, CallableDescriptor functionDescriptor, BindingTrace trace) {
        HashMap<TypeConstructor, TypeProjection> context = Maps.newHashMap();
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getOriginal().getTypeParameters();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            context.put(typeParameter.getTypeConstructor(), new TypeProjection(typeArgument));
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(context);
        int typeParametersSize2 = typeParameters.size();
        for (int i = 0; i < typeParametersSize2; ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            JetTypeReference typeReference = jetTypeArguments.get(i).getTypeReference();
            if (typeReference == null) continue;
            DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveExactSignature(@NotNull JetScope scope, @NotNull ReceiverDescriptor receiver, @NotNull Name name, @NotNull List<JetType> parameterTypes) {
        List<ResolutionCandidate<FunctionDescriptor>> candidates = this.findCandidatesByExactSignature(scope, receiver, name, parameterTypes);
        BindingTraceContext trace = new BindingTraceContext();
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace);
        LinkedHashSet calls = Sets.newLinkedHashSet();
        for (ResolutionCandidate<FunctionDescriptor> candidate : candidates) {
            ResolvedCallImpl<FunctionDescriptor> call = ResolvedCallImpl.create(candidate, temporaryBindingTrace);
            calls.add(call);
        }
        return this.computeResultAndReportErrors(trace, TracingStrategy.EMPTY, calls, Collections.emptySet());
    }

    private List<ResolutionCandidate<FunctionDescriptor>> findCandidatesByExactSignature(JetScope scope, ReceiverDescriptor receiver, Name name, List<JetType> parameterTypes) {
        ArrayList<ResolutionCandidate<FunctionDescriptor>> result = Lists.newArrayList();
        if (receiver.exists()) {
            List extensionFunctionDescriptors = ResolutionCandidate.convertCollection(scope.getFunctions(name), false);
            ArrayList<ResolutionCandidate<FunctionDescriptor>> nonlocal = Lists.newArrayList();
            ArrayList<ResolutionCandidate<FunctionDescriptor>> local = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(extensionFunctionDescriptors, scope.getContainingDeclaration(), local, nonlocal);
            if (this.findExtensionFunctions(local, receiver, parameterTypes, result)) {
                return result;
            }
            List<ResolutionCandidate<FunctionDescriptor>> functionDescriptors = ResolutionCandidate.convertCollection(receiver.getType().getMemberScope().getFunctions(name), false);
            if (CallResolver.lookupExactSignature(functionDescriptors, parameterTypes, result)) {
                return result;
            }
            this.findExtensionFunctions(nonlocal, receiver, parameterTypes, result);
            return result;
        }
        CallResolver.lookupExactSignature(ResolutionCandidate.convertCollection(scope.getFunctions(name), false), parameterTypes, result);
        return result;
    }

    private static boolean lookupExactSignature(Collection<ResolutionCandidate<FunctionDescriptor>> candidates, List<JetType> parameterTypes, List<ResolutionCandidate<FunctionDescriptor>> result) {
        boolean found = false;
        for (ResolutionCandidate<FunctionDescriptor> resolvedCall : candidates) {
            FunctionDescriptor functionDescriptor = resolvedCall.getDescriptor();
            if (functionDescriptor.getReceiverParameter().exists() || !functionDescriptor.getTypeParameters().isEmpty() || !CallResolver.checkValueParameters(functionDescriptor, parameterTypes)) continue;
            result.add(resolvedCall);
            found = true;
        }
        return found;
    }

    private boolean findExtensionFunctions(Collection<ResolutionCandidate<FunctionDescriptor>> candidates, ReceiverDescriptor receiver, List<JetType> parameterTypes, List<ResolutionCandidate<FunctionDescriptor>> result) {
        boolean found = false;
        for (ResolutionCandidate<FunctionDescriptor> candidate : candidates) {
            FunctionDescriptor functionDescriptor = candidate.getDescriptor();
            ReceiverDescriptor functionReceiver = functionDescriptor.getReceiverParameter();
            if (!functionReceiver.exists() || !functionDescriptor.getTypeParameters().isEmpty() || !this.typeChecker.isSubtypeOf(receiver.getType(), functionReceiver.getType()) || !CallResolver.checkValueParameters(functionDescriptor, parameterTypes)) continue;
            result.add(candidate);
            found = true;
        }
        return found;
    }

    private static boolean checkValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<JetType> parameterTypes) {
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        if (valueParameters.size() != parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < valueParameters.size(); ++i) {
            ValueParameterDescriptor valueParameter = valueParameters.get(i);
            JetType expectedType = parameterTypes.get(i);
            if (TypeUtils.equalTypes(expectedType, valueParameter.getType())) continue;
            return false;
        }
        return true;
    }
}

