/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTupleType;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.util.lazy.LazyValue;

public class TypeResolver {
    private AnnotationResolver annotationResolver;
    private DescriptorResolver descriptorResolver;
    private QualifiedExpressionResolver qualifiedExpressionResolver;

    @Inject
    public void setDescriptorResolver(DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setAnnotationResolver(AnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setQualifiedExpressionResolver(QualifiedExpressionResolver qualifiedExpressionResolver) {
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    @NotNull
    public JetType resolveType(@NotNull JetScope scope, @NotNull JetTypeReference typeReference, BindingTrace trace, boolean checkBounds) {
        JetType cachedType = trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            return cachedType;
        }
        List<AnnotationDescriptor> annotations = this.annotationResolver.createAnnotationStubs(typeReference.getAnnotations(), trace);
        JetTypeElement typeElement = typeReference.getTypeElement();
        JetType type = this.resolveTypeElement(scope, annotations, typeElement, false, trace, checkBounds);
        trace.record(BindingContext.TYPE, typeReference, type);
        trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, typeReference, scope);
        return type;
    }

    @NotNull
    private JetType resolveTypeElement(final JetScope scope, final List<AnnotationDescriptor> annotations, JetTypeElement typeElement, final boolean nullable, final BindingTrace trace, final boolean checkBounds) {
        final JetType[] result = new JetType[1];
        if (typeElement != null) {
            typeElement.accept(new JetVisitorVoid(){

                @Override
                public void visitUserType(JetUserType type) {
                    JetSimpleNameExpression referenceExpression = type.getReferenceExpression();
                    String referencedName = type.getReferencedName();
                    if (referenceExpression == null || referencedName == null) {
                        return;
                    }
                    ClassifierDescriptor classifierDescriptor = TypeResolver.this.resolveClass(scope, type, trace);
                    if (classifierDescriptor == null) {
                        TypeResolver.this.resolveTypeProjections(scope, ErrorUtils.createErrorType("No type").getConstructor(), type.getTypeArguments(), trace, checkBounds);
                        return;
                    }
                    if (classifierDescriptor instanceof TypeParameterDescriptor) {
                        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
                        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, typeParameterDescriptor);
                        JetScope scopeForTypeParameter = TypeResolver.this.getScopeForTypeParameter(typeParameterDescriptor, checkBounds);
                        result[0] = scopeForTypeParameter instanceof ErrorUtils.ErrorScope ? ErrorUtils.createErrorType("?") : new JetTypeImpl(annotations, typeParameterDescriptor.getTypeConstructor(), nullable || TypeUtils.hasNullableLowerBound(typeParameterDescriptor), Collections.<TypeProjection>emptyList(), scopeForTypeParameter);
                        TypeResolver.this.resolveTypeProjections(scope, ErrorUtils.createErrorType("No type").getConstructor(), type.getTypeArguments(), trace, checkBounds);
                    } else if (classifierDescriptor instanceof ClassDescriptor) {
                        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifierDescriptor);
                        TypeConstructor typeConstructor = classifierDescriptor.getTypeConstructor();
                        List arguments = TypeResolver.this.resolveTypeProjections(scope, typeConstructor, type.getTypeArguments(), trace, checkBounds);
                        List<TypeParameterDescriptor> parameters = typeConstructor.getParameters();
                        int expectedArgumentCount = parameters.size();
                        int actualArgumentCount = arguments.size();
                        if (ErrorUtils.isError(typeConstructor)) {
                            result[0] = ErrorUtils.createErrorType("[Error type: " + typeConstructor + "]");
                        } else if (actualArgumentCount != expectedArgumentCount) {
                            if (actualArgumentCount == 0) {
                                trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(type, expectedArgumentCount));
                            } else {
                                trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(type.getTypeArgumentList(), expectedArgumentCount));
                            }
                        } else {
                            result[0] = new JetTypeImpl(annotations, typeConstructor, nullable, arguments, classDescriptor.getMemberScope(arguments));
                            if (checkBounds) {
                                TypeSubstitutor substitutor = TypeSubstitutor.create(result[0]);
                                int parametersSize = parameters.size();
                                for (int i = 0; i < parametersSize; ++i) {
                                    TypeParameterDescriptor parameter = parameters.get(i);
                                    JetType argument = ((TypeProjection)arguments.get(i)).getType();
                                    JetTypeReference typeReference = type.getTypeArguments().get(i).getTypeReference();
                                    if (typeReference == null) continue;
                                    TypeResolver.this.descriptorResolver;
                                    DescriptorResolver.checkBounds(typeReference, argument, parameter, substitutor, trace);
                                }
                            }
                        }
                    }
                }

                @Override
                public void visitNullableType(JetNullableType nullableType) {
                    result[0] = TypeResolver.this.resolveTypeElement(scope, annotations, nullableType.getInnerType(), true, trace, checkBounds);
                }

                @Override
                public void visitTupleType(JetTupleType type) {
                    result[0] = JetStandardClasses.getTupleType(TypeResolver.this.resolveTypes(scope, type.getComponentTypeRefs(), trace, checkBounds));
                }

                @Override
                public void visitFunctionType(JetFunctionType type) {
                    JetTypeReference receiverTypeRef = type.getReceiverTypeRef();
                    JetType receiverType = receiverTypeRef == null ? null : TypeResolver.this.resolveType(scope, receiverTypeRef, trace, checkBounds);
                    ArrayList<JetType> parameterTypes = new ArrayList<JetType>();
                    for (JetParameter parameter : type.getParameters()) {
                        parameterTypes.add(TypeResolver.this.resolveType(scope, parameter.getTypeReference(), trace, checkBounds));
                    }
                    JetTypeReference returnTypeRef = type.getReturnTypeRef();
                    JetType returnType = returnTypeRef != null ? TypeResolver.this.resolveType(scope, returnTypeRef, trace, checkBounds) : JetStandardClasses.getUnitType();
                    result[0] = JetStandardClasses.getFunctionType(annotations, receiverType, parameterTypes, returnType);
                }

                @Override
                public void visitJetElement(JetElement element) {
                    trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }
            });
        }
        if (result[0] == null) {
            return ErrorUtils.createErrorType(typeElement == null ? "No type element" : typeElement.getText());
        }
        if (nullable) {
            return TypeUtils.makeNullable(result[0]);
        }
        return result[0];
    }

    private JetScope getScopeForTypeParameter(final TypeParameterDescriptor typeParameterDescriptor, boolean checkBounds) {
        if (checkBounds) {
            return typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
        }
        return new LazyScopeAdapter(new LazyValue<JetScope>(){

            @Override
            protected JetScope compute() {
                return typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
            }
        });
    }

    private List<JetType> resolveTypes(JetScope scope, List<JetTypeReference> argumentElements, BindingTrace trace, boolean checkBounds) {
        ArrayList<JetType> arguments = new ArrayList<JetType>();
        for (JetTypeReference argumentElement : argumentElements) {
            arguments.add(this.resolveType(scope, argumentElement, trace, checkBounds));
        }
        return arguments;
    }

    @NotNull
    private List<TypeProjection> resolveTypeProjections(JetScope scope, TypeConstructor constructor, List<JetTypeProjection> argumentElements, BindingTrace trace, boolean checkBounds) {
        ArrayList<TypeProjection> arguments = new ArrayList<TypeProjection>();
        int argumentElementsSize = argumentElements.size();
        for (int i = 0; i < argumentElementsSize; ++i) {
            JetTypeProjection argumentElement = argumentElements.get(i);
            JetProjectionKind projectionKind = argumentElement.getProjectionKind();
            if (projectionKind == JetProjectionKind.STAR) {
                List<TypeParameterDescriptor> parameters = constructor.getParameters();
                if (parameters.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = parameters.get(i);
                    arguments.add(SubstitutionUtils.makeStarProjection(parameterDescriptor));
                    continue;
                }
                arguments.add(new TypeProjection(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*")));
                continue;
            }
            JetType type = this.resolveType(scope, argumentElement.getTypeReference(), trace, checkBounds);
            Variance kind = null;
            switch (projectionKind) {
                case IN: {
                    kind = Variance.IN_VARIANCE;
                    break;
                }
                case OUT: {
                    kind = Variance.OUT_VARIANCE;
                    break;
                }
                case NONE: {
                    kind = Variance.INVARIANT;
                }
            }
            assert (kind != null);
            arguments.add(new TypeProjection(kind, type));
        }
        return arguments;
    }

    @Nullable
    public ClassifierDescriptor resolveClass(JetScope scope, JetUserType userType, BindingTrace trace) {
        Collection<? extends DeclarationDescriptor> descriptors = this.qualifiedExpressionResolver.lookupDescriptorsForUserType(userType, scope, trace);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            if (!(declarationDescriptor instanceof ClassifierDescriptor)) continue;
            return (ClassifierDescriptor)declarationDescriptor;
        }
        return null;
    }
}

