/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.WithDeferredResolve;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.NamespaceFactoryImpl;
import org.jetbrains.jet.lang.resolve.ScriptResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WriteThroughScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lexer.JetTokens;

public class TypeHierarchyResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptResolver scriptResolver;
    @NotNull
    private NamespaceFactoryImpl namespaceFactory;
    @NotNull
    private BindingTrace trace;
    private LinkedList<MutableClassDescriptor> topologicalOrder;

    @Inject
    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    @Inject
    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        this.importsResolver = importsResolver;
    }

    @Inject
    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setScriptResolver(@NotNull ScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    @Inject
    public void setNamespaceFactory(@NotNull NamespaceFactoryImpl namespaceFactory) {
        this.namespaceFactory = namespaceFactory;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        LinkedList<JetDeclarationContainer> forDeferredResolve = new LinkedList<JetDeclarationContainer>();
        forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(outerScope, owner, declarations));
        while (!forDeferredResolve.isEmpty()) {
            JetDeclarationContainer declarationContainer = (JetDeclarationContainer)forDeferredResolve.poll();
            assert (declarationContainer != null);
            WithDeferredResolve descriptorForDeferredResolve = this.context.forDeferredResolver.get(declarationContainer);
            JetScope scope = this.context.normalScope.get(declarationContainer);
            if (descriptorForDeferredResolve instanceof MutableClassDescriptorLite) {
                forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(scope, ((MutableClassDescriptorLite)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            if (descriptorForDeferredResolve instanceof NamespaceDescriptorImpl) {
                forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(scope, ((NamespaceDescriptorImpl)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            assert (false);
        }
        this.importsResolver.processTypeImports(outerScope);
        this.createTypeConstructors();
        this.resolveTypesInClassHeaders();
        this.topologicalOrder = this.topologicallySortClassesAndObjects();
        this.detectAndDisconnectLoops();
        this.checkSupertypesForConsistency();
        this.checkTypesInClassHeaders();
    }

    @NotNull
    private JetScope getStaticScope(PsiElement declarationElement, @NotNull NamespaceLikeBuilder owner) {
        DeclarationDescriptor ownerDescriptor = owner.getOwnerForChildren();
        if (ownerDescriptor instanceof NamespaceDescriptorImpl) {
            return this.context.getNamespaceScopes().get(declarationElement.getContainingFile());
        }
        if (ownerDescriptor instanceof MutableClassDescriptor) {
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)ownerDescriptor;
            if (classDescriptor.getKind() == ClassKind.OBJECT) {
                return classDescriptor.getScopeForMemberResolution();
            }
            DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
            if (declaration instanceof NamespaceDescriptorImpl) {
                return this.getStaticScope(declarationElement, ((NamespaceDescriptorImpl)declaration).getBuilder());
            }
            if (declaration instanceof MutableClassDescriptorLite) {
                return this.getStaticScope(declarationElement, ((MutableClassDescriptorLite)declaration).getBuilder());
            }
        }
        return null;
    }

    @Nullable
    private Collection<JetDeclarationContainer> collectNamespacesAndClassifiers(final @NotNull JetScope outerScope, final @NotNull NamespaceLikeBuilder owner, @NotNull Iterable<? extends PsiElement> declarations) {
        final ArrayList<JetDeclarationContainer> forDeferredResolve = new ArrayList<JetDeclarationContainer>();
        for (PsiElement psiElement : declarations) {
            psiElement.accept(new JetVisitorVoid(){

                @Override
                public void visitJetFile(JetFile file) {
                    if (file.isScript()) {
                        JetScript script = file.getScript();
                        TypeHierarchyResolver.this.scriptResolver.processScriptHierarchy(script, outerScope);
                        return;
                    }
                    NamespaceDescriptorImpl namespaceDescriptor = TypeHierarchyResolver.this.namespaceFactory.createNamespaceDescriptorPathIfNeeded(file, outerScope, RedeclarationHandler.DO_NOTHING);
                    TypeHierarchyResolver.this.context.getNamespaceDescriptors().put(file, namespaceDescriptor);
                    WriteThroughScope namespaceScope = new WriteThroughScope(outerScope, namespaceDescriptor.getMemberScope(), new TraceBasedRedeclarationHandler(TypeHierarchyResolver.this.trace), "namespace");
                    namespaceScope.changeLockLevel(WritableScope.LockLevel.BOTH);
                    TypeHierarchyResolver.this.context.getNamespaceScopes().put(file, namespaceScope);
                    this.prepareForDeferredCall(namespaceScope, namespaceDescriptor, file);
                }

                @Override
                public void visitClass(JetClass klass) {
                    MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(owner.getOwnerForChildren(), outerScope, TypeHierarchyResolver.getClassKind(klass), JetPsiUtil.safeName(klass.getName()));
                    TypeHierarchyResolver.this.context.getClasses().put(klass, mutableClassDescriptor);
                    TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getFQName(klass), mutableClassDescriptor);
                    this.createClassObjectForEnumClass(klass, mutableClassDescriptor);
                    JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
                    this.prepareForDeferredCall(classScope, mutableClassDescriptor, klass);
                    owner.addClassifierDescriptor(mutableClassDescriptor);
                }

                @Override
                public void visitObjectDeclaration(JetObjectDeclaration declaration) {
                    MutableClassDescriptor objectDescriptor = this.createClassDescriptorForObject(declaration, owner, outerScope);
                    TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getFQName(declaration), objectDescriptor);
                }

                @Override
                public void visitEnumEntry(JetEnumEntry enumEntry) {
                    MutableClassDescriptorLite ownerClassDescriptor = (MutableClassDescriptorLite)owner.getOwnerForChildren();
                    MutableClassDescriptorLite classObjectDescriptor = ownerClassDescriptor.getClassObjectDescriptor();
                    assert (classObjectDescriptor != null) : enumEntry.getParent().getText();
                    if (enumEntry.getPrimaryConstructorParameterList() == null) {
                        this.createClassDescriptorForEnumEntry(enumEntry, classObjectDescriptor.getBuilder());
                    } else {
                        MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(classObjectDescriptor, outerScope, ClassKind.ENUM_ENTRY, JetPsiUtil.safeName(enumEntry.getName()));
                        TypeHierarchyResolver.this.context.getClasses().put(enumEntry, mutableClassDescriptor);
                        JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
                        this.prepareForDeferredCall(classScope, mutableClassDescriptor, enumEntry);
                        classObjectDescriptor.getBuilder().addObjectDescriptor(mutableClassDescriptor);
                    }
                }

                @Override
                public void visitTypedef(JetTypedef typedef) {
                    TypeHierarchyResolver.this.trace.report(Errors.UNSUPPORTED.on(typedef, "TypeHierarchyResolver"));
                }

                @Override
                public void visitClassObject(JetClassObject classObject) {
                    JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
                    if (objectDeclaration != null) {
                        MutableClassDescriptor classObjectDescriptor = this.createClassDescriptorForObject(objectDeclaration, owner, TypeHierarchyResolver.this.getStaticScope(classObject, owner));
                        NamespaceLikeBuilder.ClassObjectStatus status = owner.setClassObjectDescriptor(classObjectDescriptor);
                        switch (status) {
                            case DUPLICATE: {
                                TypeHierarchyResolver.this.trace.report(Errors.MANY_CLASS_OBJECTS.on(classObject));
                                break;
                            }
                            case NOT_ALLOWED: {
                                TypeHierarchyResolver.this.trace.report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
                                break;
                            }
                        }
                    }
                }

                private void createClassObjectForEnumClass(JetClass klass, MutableClassDescriptor mutableClassDescriptor) {
                    if (klass.hasModifier(JetTokens.ENUM_KEYWORD)) {
                        MutableClassDescriptor classObjectDescriptor = new MutableClassDescriptor(mutableClassDescriptor, outerScope, ClassKind.OBJECT, Name.special("<class-object-for-" + klass.getName() + ">"));
                        classObjectDescriptor.setModality(Modality.FINAL);
                        classObjectDescriptor.setVisibility(DescriptorResolver.resolveVisibilityFromModifiers(klass.getModifierList()));
                        classObjectDescriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
                        classObjectDescriptor.createTypeConstructor();
                        this.createPrimaryConstructorForObject(null, classObjectDescriptor);
                        mutableClassDescriptor.getBuilder().setClassObjectDescriptor(classObjectDescriptor);
                    }
                }

                private MutableClassDescriptor createClassDescriptorForObject(@NotNull JetObjectDeclaration declaration, @NotNull NamespaceLikeBuilder owner2, JetScope scope) {
                    MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(owner2.getOwnerForChildren(), scope, ClassKind.OBJECT, JetPsiUtil.safeName(declaration.getName()));
                    TypeHierarchyResolver.this.context.getObjects().put(declaration, mutableClassDescriptor);
                    JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
                    this.prepareForDeferredCall(classScope, mutableClassDescriptor, declaration);
                    this.createPrimaryConstructorForObject(declaration, mutableClassDescriptor);
                    owner2.addObjectDescriptor(mutableClassDescriptor);
                    TypeHierarchyResolver.this.trace.record(BindingContext.CLASS, declaration, mutableClassDescriptor);
                    return mutableClassDescriptor;
                }

                private MutableClassDescriptor createClassDescriptorForEnumEntry(@NotNull JetEnumEntry declaration, @NotNull NamespaceLikeBuilder owner2) {
                    MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(owner2.getOwnerForChildren(), TypeHierarchyResolver.this.getStaticScope(declaration, owner2), ClassKind.ENUM_ENTRY, JetPsiUtil.safeName(declaration.getName()));
                    TypeHierarchyResolver.this.context.getClasses().put(declaration, mutableClassDescriptor);
                    this.prepareForDeferredCall(mutableClassDescriptor.getScopeForMemberResolution(), mutableClassDescriptor, declaration);
                    this.createPrimaryConstructorForObject(declaration, mutableClassDescriptor);
                    owner2.addObjectDescriptor(mutableClassDescriptor);
                    TypeHierarchyResolver.this.trace.record(BindingContext.CLASS, declaration, mutableClassDescriptor);
                    return mutableClassDescriptor;
                }

                private void createPrimaryConstructorForObject(@Nullable PsiElement object, MutableClassDescriptor mutableClassDescriptor) {
                    ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(mutableClassDescriptor, Collections.<AnnotationDescriptor>emptyList(), true);
                    constructorDescriptor.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
                    mutableClassDescriptor.setPrimaryConstructor(constructorDescriptor, TypeHierarchyResolver.this.trace);
                    if (object != null) {
                        TypeHierarchyResolver.this.trace.record(BindingContext.CONSTRUCTOR, object, constructorDescriptor);
                    }
                }

                private void prepareForDeferredCall(@NotNull JetScope outerScope2, @NotNull WithDeferredResolve withDeferredResolve, @NotNull JetDeclarationContainer container) {
                    forDeferredResolve.add(container);
                    ((TypeHierarchyResolver)TypeHierarchyResolver.this).context.normalScope.put(container, outerScope2);
                    ((TypeHierarchyResolver)TypeHierarchyResolver.this).context.forDeferredResolver.put(container, withDeferredResolve);
                }
            });
        }
        return forDeferredResolve;
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull JetClass jetClass) {
        if (jetClass.isTrait()) {
            return ClassKind.TRAIT;
        }
        if (jetClass.hasModifier(JetTokens.ANNOTATION_KEYWORD)) {
            return ClassKind.ANNOTATION_CLASS;
        }
        if (jetClass.hasModifier(JetTokens.ENUM_KEYWORD)) {
            return ClassKind.ENUM_CLASS;
        }
        return ClassKind.CLASS;
    }

    private void createTypeConstructors() {
        MutableClassDescriptor descriptor;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.descriptorResolver.resolveMutableClassDescriptor(jetClass, descriptor, this.trace);
            descriptor.createTypeConstructor();
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)entry.getKey();
            descriptor = entry.getValue();
            descriptor.setModality(Modality.FINAL);
            descriptor.setVisibility(DescriptorResolver.resolveVisibilityFromModifiers(objectDeclaration.getModifierList()));
            descriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
            descriptor.createTypeConstructor();
        }
    }

    private void resolveTypesInClassHeaders() {
        MutableClassDescriptor descriptor;
        JetClassOrObject jetClass;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.descriptorResolver.resolveGenericBounds((JetTypeParameterListOwner)((Object)jetClass), descriptor.getScopeForSupertypeResolution(), (List<TypeParameterDescriptorImpl>)descriptor.getTypeConstructor().getParameters(), this.trace);
            this.descriptorResolver.resolveSupertypesForMutableClassDescriptor(jetClass, descriptor, this.trace);
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            jetClass = (JetClassOrObject)((Object)entry.getKey());
            descriptor = entry.getValue();
            this.descriptorResolver.resolveSupertypesForMutableClassDescriptor(jetClass, descriptor, this.trace);
        }
    }

    private LinkedList<MutableClassDescriptor> topologicallySortClassesAndObjects() {
        LinkedList<MutableClassDescriptor> topologicalOrder = Lists.newLinkedList();
        HashSet<ClassDescriptor> visited = Sets.newHashSet();
        for (MutableClassDescriptor mutableClassDescriptor : this.context.getClasses().values()) {
            TypeHierarchyResolver.topologicallySort(mutableClassDescriptor, visited, topologicalOrder);
        }
        for (MutableClassDescriptor mutableClassDescriptor : this.context.getObjects().values()) {
            TypeHierarchyResolver.topologicallySort(mutableClassDescriptor, visited, topologicalOrder);
        }
        return topologicalOrder;
    }

    private void detectAndDisconnectLoops() {
        HashSet<ClassDescriptor> visited = Sets.newHashSet();
        HashSet<ClassDescriptor> beingProcessed = Sets.newHashSet();
        ArrayList<ClassDescriptor> currentPath = Lists.newArrayList();
        for (MutableClassDescriptor mutableClassDescriptor : this.topologicalOrder) {
            this.traverseTypeHierarchy(mutableClassDescriptor, visited, beingProcessed, currentPath);
        }
    }

    private static void topologicallySort(MutableClassDescriptor mutableClassDescriptor, Set<ClassDescriptor> visited, LinkedList<MutableClassDescriptor> topologicalOrder) {
        if (!visited.add(mutableClassDescriptor)) {
            return;
        }
        for (JetType supertype : mutableClassDescriptor.getSupertypes()) {
            ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof MutableClassDescriptor)) continue;
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)declarationDescriptor;
            TypeHierarchyResolver.topologicallySort(classDescriptor, visited, topologicalOrder);
        }
        topologicalOrder.addFirst(mutableClassDescriptor);
    }

    private void traverseTypeHierarchy(MutableClassDescriptor currentClass, Set<ClassDescriptor> visited, Set<ClassDescriptor> beingProcessed, List<ClassDescriptor> currentPath) {
        if (!visited.add(currentClass)) {
            if (beingProcessed.contains(currentClass)) {
                this.markCycleErrors(currentPath, currentClass);
                assert (!currentPath.isEmpty()) : "Cycle cannot be found on an empty currentPath";
                ClassDescriptor subclassOfCurrent = currentPath.get(currentPath.size() - 1);
                assert (subclassOfCurrent instanceof MutableClassDescriptor);
                Iterator<JetType> iterator = ((MutableClassDescriptor)subclassOfCurrent).getSupertypes().iterator();
                while (iterator.hasNext()) {
                    JetType type = iterator.next();
                    if (type.getConstructor() != currentClass.getTypeConstructor()) continue;
                    iterator.remove();
                    break;
                }
            }
            return;
        }
        beingProcessed.add(currentClass);
        currentPath.add(currentClass);
        for (JetType supertype : Lists.newArrayList(currentClass.getSupertypes())) {
            ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof MutableClassDescriptor)) continue;
            MutableClassDescriptor mutableClassDescriptor = (MutableClassDescriptor)declarationDescriptor;
            this.traverseTypeHierarchy(mutableClassDescriptor, visited, beingProcessed, currentPath);
        }
        beingProcessed.remove(currentClass);
        currentPath.remove(currentPath.size() - 1);
    }

    private void markCycleErrors(List<ClassDescriptor> currentPath, @NotNull ClassDescriptor current) {
        int size = currentPath.size();
        for (int i = size - 1; i >= 0; --i) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            ClassDescriptor classDescriptor = currentPath.get(i);
            ClassDescriptor superclass = i < size - 1 ? currentPath.get(i + 1) : current;
            PsiElement psiElement = BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)psiElement;
                for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                    JetType supertype;
                    JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = this.trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                this.trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
            if (classDescriptor == current) break;
        }
    }

    private void checkSupertypesForConsistency() {
        for (MutableClassDescriptor mutableClassDescriptor : this.topologicalOrder) {
            Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(mutableClassDescriptor.getDefaultType());
            for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
                Collection<TypeProjection> projections = entry.getValue();
                if (projections.size() <= 1) continue;
                TypeConstructor typeConstructor = entry.getKey();
                ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
                assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
                LinkedHashSet<JetType> conflictingTypes = Sets.newLinkedHashSet();
                for (TypeProjection projection : projections) {
                    conflictingTypes.add(projection.getType());
                }
                switch (typeParameterDescriptor.getVariance()) {
                    case INVARIANT: {
                        break;
                    }
                    case IN_VARIANCE: {
                        Filter.REMOVE_IF_SUPERTYPE_IN_THE_SET.proceed(conflictingTypes);
                        break;
                    }
                    case OUT_VARIANCE: {
                        Filter.REMOVE_IF_SUBTYPE_IN_THE_SET.proceed(conflictingTypes);
                    }
                }
                if (conflictingTypes.size() <= 1) continue;
                DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
                assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
                JetClassOrObject psiElement = (JetClassOrObject)BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), mutableClassDescriptor);
                JetDelegationSpecifierList delegationSpecifierList = psiElement.getDelegationSpecifierList();
                assert (delegationSpecifierList != null);
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
            }
        }
    }

    private void checkTypesInClassHeaders() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetTypeReference extendsBound;
            JetType type;
            JetClass jetClass = entry.getKey();
            for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
                JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                if (typeReference == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
                DescriptorResolver.checkBounds(typeReference, type, this.trace);
            }
            for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
                extendsBound = jetTypeParameter.getExtendsBound();
                if (extendsBound == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, extendsBound)) == null) continue;
                DescriptorResolver.checkBounds(extendsBound, type, this.trace);
            }
            for (JetTypeConstraint constraint : jetClass.getTypeConstraints()) {
                extendsBound = constraint.getBoundTypeReference();
                if (extendsBound == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, extendsBound)) == null) continue;
                DescriptorResolver.checkBounds(extendsBound, type, this.trace);
            }
        }
    }

    private static enum Filter {
        REMOVE_IF_SUBTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(other, subject);
            }
        }
        ,
        REMOVE_IF_SUPERTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(subject, other);
            }
        };


        private void proceed(Set<JetType> conflictingTypes) {
            Iterator<JetType> iterator = conflictingTypes.iterator();
            block0: while (iterator.hasNext()) {
                JetType type = iterator.next();
                for (JetType otherType : conflictingTypes) {
                    boolean subtypeOf = this.removeNeeded(type, otherType);
                    if (type == otherType || !subtypeOf) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }

        public abstract boolean removeNeeded(JetType var1, JetType var2);
    }
}

