/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.io.PrintStream;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.WithDeferredResolve;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class TopDownAnalysisContext
implements BodiesResolveContext {
    private final Map<JetClass, MutableClassDescriptor> classes = Maps.newLinkedHashMap();
    private final Map<JetObjectDeclaration, MutableClassDescriptor> objects = Maps.newLinkedHashMap();
    protected final Map<JetFile, NamespaceDescriptorImpl> namespaceDescriptors = Maps.newHashMap();
    private final Map<JetDeclaration, JetScope> declaringScopes = Maps.newHashMap();
    private final Map<JetNamedFunction, SimpleFunctionDescriptor> functions = Maps.newLinkedHashMap();
    private final Map<JetSecondaryConstructor, ConstructorDescriptor> constructors = Maps.newLinkedHashMap();
    private final Map<JetProperty, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private final Map<JetParameter, PropertyDescriptor> primaryConstructorParameterProperties = Maps.newHashMap();
    private Map<JetDeclaration, CallableMemberDescriptor> members = null;
    protected final Map<JetFile, WritableScope> namespaceScopes = Maps.newHashMap();
    public final Map<JetDeclarationContainer, WithDeferredResolve> forDeferredResolver = Maps.newHashMap();
    public final Map<JetDeclarationContainer, JetScope> normalScope = Maps.newHashMap();
    private final Map<JetScript, ScriptDescriptor> scripts = Maps.newLinkedHashMap();
    private final Map<JetScript, WritableScope> scriptScopes = Maps.newHashMap();
    private StringBuilder debugOutput;
    private TopDownAnalysisParameters topDownAnalysisParameters;

    @Override
    @Inject
    public void setTopDownAnalysisParameters(TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    public TopDownAnalysisParameters getTopDownAnalysisParameters() {
        return this.topDownAnalysisParameters;
    }

    public void debug(Object message) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message).append("\n");
        }
    }

    void printDebugOutput(PrintStream out) {
        if (this.debugOutput != null) {
            out.print(this.debugOutput);
        }
    }

    @Override
    public boolean completeAnalysisNeeded(@NotNull PsiElement element) {
        boolean result;
        PsiFile containingFile = element.getContainingFile();
        boolean bl = result = containingFile != null && this.topDownAnalysisParameters.getAnalyzeCompletely().apply(containingFile);
        if (!result) {
            this.debug(containingFile);
        }
        return result;
    }

    @Override
    public Map<JetClass, MutableClassDescriptor> getClasses() {
        return this.classes;
    }

    @Override
    public Map<JetObjectDeclaration, MutableClassDescriptor> getObjects() {
        return this.objects;
    }

    public Map<JetFile, WritableScope> getNamespaceScopes() {
        return this.namespaceScopes;
    }

    public Map<JetFile, NamespaceDescriptorImpl> getNamespaceDescriptors() {
        return this.namespaceDescriptors;
    }

    @Override
    @NotNull
    public Map<JetScript, ScriptDescriptor> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public Map<JetScript, WritableScope> getScriptScopes() {
        return this.scriptScopes;
    }

    public Map<JetParameter, PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    @Override
    public Map<JetSecondaryConstructor, ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    @Override
    public Map<JetProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    public Map<JetDeclaration, JetScope> getDeclaringScopes() {
        return this.declaringScopes;
    }

    @Override
    public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    public Map<JetDeclaration, CallableMemberDescriptor> getMembers() {
        if (this.members == null) {
            this.members = Maps.newHashMap();
            this.members.putAll(this.functions);
            this.members.putAll(this.properties);
            this.members.putAll(this.primaryConstructorParameterProperties);
        }
        return this.members;
    }
}

