/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.NamespaceFactory;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.ref.JetTypeName;

public class ScriptResolver {
    @NotNull
    private NamespaceFactory namespaceFactory;
    @NotNull
    private DependencyClassByQualifiedNameResolver dependencyClassByQualifiedNameResolver;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private BindingTrace trace;
    @NotNull
    private TopDownAnalysisParameters topDownAnalysisParameters;

    @Inject
    public void setNamespaceFactory(@NotNull NamespaceFactory namespaceFactory) {
        this.namespaceFactory = namespaceFactory;
    }

    @Inject
    public void setDependencyClassByQualifiedNameResolver(@NotNull DependencyClassByQualifiedNameResolver dependencyClassByQualifiedNameResolver) {
        this.dependencyClassByQualifiedNameResolver = dependencyClassByQualifiedNameResolver;
    }

    @Inject
    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    @Inject
    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    @Inject
    public void setTopDownAnalysisParameters(@NotNull TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    @NotNull
    private ClassDescriptor resolveClass(@NotNull FqName className) {
        ClassDescriptor classDescriptor = this.dependencyClassByQualifiedNameResolver.resolveClass(className);
        if (classDescriptor == null) {
            throw new IllegalStateException("dependency class not found by name: " + className);
        }
        return classDescriptor;
    }

    @NotNull
    public JetType resolveTypeName(@NotNull JetTypeName typeName) {
        ArrayList<JetType> typeArguments = new ArrayList<JetType>();
        for (JetTypeName typeArgumentName : typeName.getArguments()) {
            typeArguments.add(this.resolveTypeName(typeArgumentName));
        }
        ClassDescriptor classDescriptor = this.resolveClass(typeName.getClassName());
        return TypeUtils.substituteParameters(classDescriptor, typeArguments);
    }

    @NotNull
    private ValueParameterDescriptor resolveScriptParameter(@NotNull AnalyzerScriptParameter scriptParameter, int index, @NotNull ScriptDescriptor script) {
        JetType type = this.resolveTypeName(scriptParameter.getType());
        return new ValueParameterDescriptorImpl(script, index, Collections.<AnnotationDescriptor>emptyList(), scriptParameter.getName(), false, type, false, null);
    }

    public void processScriptHierarchy(@NotNull JetScript script, @NotNull JetScope outerScope) {
        NamespaceDescriptorImpl ns = this.namespaceFactory.createNamespaceDescriptorPathIfNeeded(FqName.ROOT);
        ScriptDescriptor scriptDescriptor = new ScriptDescriptor(ns);
        WritableScopeImpl scriptScope = new WritableScopeImpl(outerScope, scriptDescriptor, RedeclarationHandler.DO_NOTHING, "script");
        scriptScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.context.getScriptScopes().put(script, scriptScope);
        this.context.getScripts().put(script, scriptDescriptor);
        this.trace.record(BindingContext.SCRIPT, script, scriptDescriptor);
    }

    public void resolveScripts() {
        for (Map.Entry<JetScript, ScriptDescriptor> e : this.context.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptor descriptor = e.getValue();
            WritableScope scope = this.context.getScriptScopes().get(declaration);
            ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
            scope.setImplicitReceiver(descriptor.getImplicitReceiver());
            int index = 0;
            for (AnalyzerScriptParameter scriptParameter : this.topDownAnalysisParameters.getScriptParameters()) {
                ValueParameterDescriptor parameter = this.resolveScriptParameter(scriptParameter, index, descriptor);
                valueParameters.add(parameter);
                scope.addVariableDescriptor(parameter);
                ++index;
            }
            scope.changeLockLevel(WritableScope.LockLevel.READING);
            ExpressionTypingContext context = ExpressionTypingContext.newContext(this.expressionTypingServices, this.trace, scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, false);
            JetType returnType = this.expressionTypingServices.getBlockReturnedType(scope, declaration.getBlockExpression(), CoercionStrategy.NO_COERCION, context, this.trace);
            if (returnType == null) {
                returnType = ErrorUtils.createErrorType("getBlockReturnedType returned null");
            }
            descriptor.initialize(returnType, valueParameters);
        }
    }
}

