/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class QualifiedExpressionResolver {
    @NotNull
    public Collection<? extends DeclarationDescriptor> analyseImportReference(@NotNull JetImportDirective importDirective, @NotNull JetScope scope, @NotNull BindingTrace trace) {
        return this.processImportReference(importDirective, scope, scope, Importer.DO_NOTHING, trace, false);
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> processImportReference(@NotNull JetImportDirective importDirective, @NotNull JetScope scope, @NotNull JetScope scopeToCheckVisibility, @NotNull Importer importer, @NotNull BindingTrace trace, boolean onlyClasses) {
        Collection<? extends DeclarationDescriptor> descriptors;
        if (importDirective.isAbsoluteInRootNamespace()) {
            trace.report(Errors.UNSUPPORTED.on(importDirective, "TypeHierarchyResolver"));
            return Collections.emptyList();
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return Collections.emptyList();
        }
        if (importedReference instanceof JetQualifiedExpression) {
            descriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)importedReference, scope, scopeToCheckVisibility, trace, onlyClasses, !onlyClasses);
        } else {
            assert (importedReference instanceof JetSimpleNameExpression);
            descriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)importedReference, scope, scopeToCheckVisibility, trace, onlyClasses, true, !onlyClasses);
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (importDirective.isAllUnder()) {
            if (referenceExpression == null || !this.canImportMembersFrom(descriptors, referenceExpression, trace, onlyClasses)) {
                return Collections.emptyList();
            }
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                importer.addAllUnderImport(declarationDescriptor);
            }
            return Collections.emptyList();
        }
        Name aliasName = JetPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            return Collections.emptyList();
        }
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            importer.addAliasImport(declarationDescriptor, aliasName);
        }
        return descriptors;
    }

    private boolean canImportMembersFrom(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace, boolean onlyClasses) {
        if (onlyClasses) {
            return true;
        }
        if (descriptors.size() == 1) {
            return this.canImportMembersFrom(descriptors.iterator().next(), reference, trace, onlyClasses);
        }
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace);
        boolean canImport = false;
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            canImport |= this.canImportMembersFrom(declarationDescriptor, reference, (BindingTrace)temporaryTrace, onlyClasses);
        }
        if (!canImport) {
            temporaryTrace.commit();
        }
        return canImport;
    }

    private boolean canImportMembersFrom(@NotNull DeclarationDescriptor descriptor, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace, boolean onlyClasses) {
        assert (!onlyClasses);
        if (descriptor instanceof NamespaceDescriptor) {
            return true;
        }
        if (descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.OBJECT) {
            return true;
        }
        trace.report(Errors.CANNOT_IMPORT_FROM_ELEMENT.on(reference, descriptor));
        return false;
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> lookupDescriptorsForUserType(@NotNull JetUserType userType, @NotNull JetScope outerScope, @NotNull BindingTrace trace) {
        if (userType.isAbsoluteInRootNamespace()) {
            trace.report(Errors.UNSUPPORTED.on(userType, "package"));
            return Collections.emptyList();
        }
        JetSimpleNameExpression referenceExpression = userType.getReferenceExpression();
        if (referenceExpression == null) {
            return Collections.emptyList();
        }
        JetUserType qualifier = userType.getQualifier();
        if (qualifier == null) {
            return this.lookupDescriptorsForSimpleNameReference(referenceExpression, outerScope, outerScope, trace, true, false, true);
        }
        Collection<? extends DeclarationDescriptor> declarationDescriptors = this.lookupDescriptorsForUserType(qualifier, outerScope, trace);
        return this.lookupSelectorDescriptors(referenceExpression, declarationDescriptors, trace, outerScope, true, true);
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> lookupDescriptorsForQualifiedExpression(@NotNull JetQualifiedExpression importedReference, @NotNull JetScope outerScope, @NotNull JetScope scopeToCheckVisibility, @NotNull BindingTrace trace, boolean onlyClasses, boolean storeResult) {
        Collection<? extends DeclarationDescriptor> declarationDescriptors;
        JetExpression receiverExpression = importedReference.getReceiverExpression();
        if (receiverExpression instanceof JetQualifiedExpression) {
            declarationDescriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)receiverExpression, outerScope, scopeToCheckVisibility, trace, onlyClasses, storeResult);
        } else {
            assert (receiverExpression instanceof JetSimpleNameExpression);
            declarationDescriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)receiverExpression, outerScope, scopeToCheckVisibility, trace, onlyClasses, true, storeResult);
        }
        JetExpression selectorExpression = importedReference.getSelectorExpression();
        if (!(selectorExpression instanceof JetSimpleNameExpression)) {
            return Collections.emptyList();
        }
        JetSimpleNameExpression selector = (JetSimpleNameExpression)selectorExpression;
        JetSimpleNameExpression lastReference = JetPsiUtil.getLastReference(receiverExpression);
        if (lastReference == null || !this.canImportMembersFrom(declarationDescriptors, lastReference, trace, onlyClasses)) {
            return Collections.emptyList();
        }
        return this.lookupSelectorDescriptors(selector, declarationDescriptors, trace, scopeToCheckVisibility, onlyClasses, storeResult);
    }

    @NotNull
    private Collection<? extends DeclarationDescriptor> lookupSelectorDescriptors(@NotNull JetSimpleNameExpression selector, @NotNull Collection<? extends DeclarationDescriptor> declarationDescriptors, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility, boolean onlyClasses, boolean storeResult) {
        HashSet<SuccessfulLookupResult> results = Sets.newHashSet();
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            if (declarationDescriptor instanceof NamespaceDescriptor) {
                this.addResult(results, this.lookupSimpleNameReference(selector, ((NamespaceDescriptor)declarationDescriptor).getMemberScope(), onlyClasses, true));
            }
            if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
            this.addResult(results, this.lookupSimpleNameReference(selector, this.getAppropriateScope((ClassDescriptor)declarationDescriptor, onlyClasses), onlyClasses, false));
            ClassDescriptor classObjectDescriptor = ((ClassDescriptor)declarationDescriptor).getClassObjectDescriptor();
            if (classObjectDescriptor == null) continue;
            this.addResult(results, this.lookupSimpleNameReference(selector, this.getAppropriateScope(classObjectDescriptor, onlyClasses), onlyClasses, false));
        }
        return this.filterAndStoreResolutionResult(results, selector, trace, scopeToCheckVisibility, onlyClasses, storeResult);
    }

    @NotNull
    private JetScope getAppropriateScope(@NotNull ClassDescriptor classDescriptor, boolean onlyClasses) {
        return onlyClasses ? classDescriptor.getUnsubstitutedInnerClassesScope() : classDescriptor.getDefaultType().getMemberScope();
    }

    private void addResult(@NotNull Set<SuccessfulLookupResult> results, @NotNull LookupResult result) {
        if (result == LookupResult.EMPTY) {
            return;
        }
        results.add((SuccessfulLookupResult)result);
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> lookupDescriptorsForSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull JetScope scopeToCheckVisibility, @NotNull BindingTrace trace, boolean onlyClasses, boolean namespaceLevel, boolean storeResult) {
        LookupResult lookupResult = this.lookupSimpleNameReference(referenceExpression, outerScope, onlyClasses, namespaceLevel);
        if (lookupResult == LookupResult.EMPTY) {
            return Collections.emptyList();
        }
        return this.filterAndStoreResolutionResult(Collections.singletonList((SuccessfulLookupResult)lookupResult), referenceExpression, trace, scopeToCheckVisibility, onlyClasses, storeResult);
    }

    @NotNull
    private LookupResult lookupSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, boolean onlyClasses, boolean namespaceLevel) {
        ClassifierDescriptor classifierDescriptor;
        Name referencedName = referenceExpression.getReferencedNameAsName();
        if (referencedName == null) {
            return new SuccessfulLookupResult(Collections.emptyList(), outerScope, namespaceLevel);
        }
        HashSet<DeclarationDescriptor> descriptors = Sets.newHashSet();
        NamespaceDescriptor namespaceDescriptor = outerScope.getNamespace(referencedName);
        if (namespaceDescriptor != null) {
            descriptors.add(namespaceDescriptor);
        }
        if ((classifierDescriptor = outerScope.getClassifier(referencedName)) != null) {
            descriptors.add(classifierDescriptor);
        }
        if (onlyClasses) {
            ClassDescriptor objectDescriptor = outerScope.getObjectDescriptor(referencedName);
            if (objectDescriptor != null) {
                descriptors.add(objectDescriptor);
            }
        } else {
            descriptors.addAll(outerScope.getFunctions(referencedName));
            descriptors.addAll(outerScope.getProperties(referencedName));
            VariableDescriptor localVariable = outerScope.getLocalVariable(referencedName);
            if (localVariable != null) {
                descriptors.add(localVariable);
            }
        }
        return new SuccessfulLookupResult(descriptors, outerScope, namespaceLevel);
    }

    @NotNull
    private Collection<? extends DeclarationDescriptor> filterAndStoreResolutionResult(@NotNull Collection<SuccessfulLookupResult> lookupResults, @NotNull JetSimpleNameExpression referenceExpression, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility, boolean onlyClasses, boolean storeResult) {
        Collection<Object> filteredDescriptors;
        if (lookupResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<? extends DeclarationDescriptor> descriptors = Sets.newLinkedHashSet();
        for (SuccessfulLookupResult lookupResult : lookupResults) {
            descriptors.addAll(lookupResult.descriptors);
        }
        ArrayList<JetScope> possibleResolutionScopes = Lists.newArrayList();
        for (SuccessfulLookupResult lookupResult : lookupResults) {
            if (lookupResult.descriptors.isEmpty()) continue;
            possibleResolutionScopes.add(lookupResult.resolutionScope);
        }
        if (possibleResolutionScopes.isEmpty()) {
            for (SuccessfulLookupResult lookupResult : lookupResults) {
                possibleResolutionScopes.add(lookupResult.resolutionScope);
            }
        }
        if (onlyClasses) {
            filteredDescriptors = Collections2.filter(descriptors, new Predicate<DeclarationDescriptor>(){

                @Override
                public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                    return descriptor instanceof ClassifierDescriptor || descriptor instanceof NamespaceDescriptor;
                }
            });
        } else {
            filteredDescriptors = Sets.newLinkedHashSet();
            for (SuccessfulLookupResult lookupResult : lookupResults) {
                if (lookupResult.namespaceLevel) {
                    filteredDescriptors.addAll(lookupResult.descriptors);
                    continue;
                }
                filteredDescriptors.addAll(Collections2.filter(lookupResult.descriptors, new Predicate<DeclarationDescriptor>(){

                    @Override
                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        return descriptor instanceof NamespaceDescriptor || descriptor instanceof ClassifierDescriptor || descriptor instanceof VariableDescriptor && ((VariableDescriptor)descriptor).isObjectDeclaration();
                    }
                }));
            }
        }
        if (storeResult) {
            this.storeResolutionResult(descriptors, filteredDescriptors, referenceExpression, possibleResolutionScopes, trace, scopeToCheckVisibility);
        }
        return filteredDescriptors;
    }

    private void storeResolutionResult(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull Collection<? extends DeclarationDescriptor> canBeImportedDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull Collection<JetScope> possibleResolutionScopes, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility) {
        assert (canBeImportedDescriptors.size() <= descriptors.size());
        assert (!possibleResolutionScopes.isEmpty());
        JetScope resolutionScope = possibleResolutionScopes.iterator().next();
        if (this.resolveClassNamespaceAmbiguity(canBeImportedDescriptors, referenceExpression, resolutionScope, trace, scopeToCheckVisibility)) {
            return;
        }
        if (descriptors.isEmpty()) {
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            trace.report(Errors.UNRESOLVED_REFERENCE.on(referenceExpression));
            return;
        }
        DeclarationDescriptor descriptor = null;
        if (descriptors.size() == 1) {
            descriptor = descriptors.iterator().next();
            assert (canBeImportedDescriptors.size() <= 1);
        } else if (canBeImportedDescriptors.size() == 1) {
            descriptor = canBeImportedDescriptors.iterator().next();
        }
        if (descriptor != null) {
            trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptors.iterator().next());
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            if (descriptor instanceof DeclarationDescriptorWithVisibility) {
                this.checkVisibility((DeclarationDescriptorWithVisibility)descriptor, trace, referenceExpression, scopeToCheckVisibility);
            }
        }
        if (canBeImportedDescriptors.isEmpty()) {
            assert (descriptors.size() >= 1);
            trace.report(Errors.CANNOT_BE_IMPORTED.on(referenceExpression, descriptors.iterator().next()));
            return;
        }
        if (canBeImportedDescriptors.size() > 1) {
            trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, descriptors);
        }
    }

    private boolean resolveClassNamespaceAmbiguity(@NotNull Collection<? extends DeclarationDescriptor> filteredDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope resolutionScope, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility) {
        if (filteredDescriptors.size() == 2) {
            NamespaceDescriptor namespaceDescriptor = null;
            ClassDescriptor classDescriptor = null;
            for (DeclarationDescriptor declarationDescriptor : filteredDescriptors) {
                if (declarationDescriptor instanceof NamespaceDescriptor) {
                    namespaceDescriptor = (NamespaceDescriptor)declarationDescriptor;
                    continue;
                }
                if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
                classDescriptor = (ClassDescriptor)declarationDescriptor;
            }
            if (namespaceDescriptor != null && classDescriptor != null && DescriptorUtils.getFQName(namespaceDescriptor).equals(DescriptorUtils.getFQName(classDescriptor))) {
                trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classDescriptor);
                trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
                this.checkVisibility(classDescriptor, trace, referenceExpression, scopeToCheckVisibility);
                return true;
            }
        }
        return false;
    }

    private void checkVisibility(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull BindingTrace trace, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope scopeToCheckVisibility) {
        if (!Visibilities.isVisible(descriptor, scopeToCheckVisibility.getContainingDeclaration())) {
            trace.report(Errors.INVISIBLE_REFERENCE.on(referenceExpression, descriptor, descriptor.getContainingDeclaration()));
        }
    }

    private static class SuccessfulLookupResult
    implements LookupResult {
        final Collection<? extends DeclarationDescriptor> descriptors;
        final JetScope resolutionScope;
        final boolean namespaceLevel;

        private SuccessfulLookupResult(Collection<? extends DeclarationDescriptor> descriptors, JetScope resolutionScope, boolean namespaceLevel) {
            this.descriptors = descriptors;
            this.resolutionScope = resolutionScope;
            this.namespaceLevel = namespaceLevel;
        }
    }

    private static interface LookupResult {
        public static final LookupResult EMPTY = new LookupResult(){};
    }
}

