/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.google.common.collect.SetMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.util.containers.LinkedMultiMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.MultiMap;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.CommonSuppliers;

public class OverrideResolver {
    private TopDownAnalysisContext context;
    private TopDownAnalysisParameters topDownAnalysisParameters;
    private BindingTrace trace;

    @Inject
    public void setContext(TopDownAnalysisContext context) {
        this.context = context;
    }

    @Inject
    public void setTopDownAnalysisParameters(TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process() {
        this.generateOverrides();
        this.checkVisibility();
        this.checkOverrides();
        this.checkParameterOverridesForAllClasses();
    }

    private void generateOverrides() {
        HashSet<MutableClassDescriptor> ourClasses = new HashSet<MutableClassDescriptor>();
        ourClasses.addAll(this.context.getClasses().values());
        ourClasses.addAll(this.context.getObjects().values());
        HashSet<ClassifierDescriptor> processed = new HashSet<ClassifierDescriptor>();
        for (MutableClassDescriptor clazz : ourClasses) {
            this.generateOverridesInAClass(clazz, processed, ourClasses);
        }
    }

    private void generateOverridesInAClass(@NotNull MutableClassDescriptor classDescriptor, @NotNull Set<ClassifierDescriptor> processed, @NotNull Set<MutableClassDescriptor> ourClasses) {
        if (!processed.add(classDescriptor)) {
            return;
        }
        if (!ourClasses.contains(classDescriptor)) {
            return;
        }
        for (JetType jetType : classDescriptor.getTypeConstructor().getSupertypes()) {
            ClassDescriptor superclass = (ClassDescriptor)jetType.getConstructor().getDeclarationDescriptor();
            if (!(superclass instanceof MutableClassDescriptor)) continue;
            this.generateOverridesInAClass((MutableClassDescriptor)superclass, processed, ourClasses);
        }
        this.doGenerateOverridesInAClass(classDescriptor);
    }

    private void doGenerateOverridesInAClass(final MutableClassDescriptor classDescriptor) {
        List<CallableMemberDescriptor> membersFromSupertypes = OverrideResolver.getCallableMembersFromSupertypes(classDescriptor);
        MultiMap<Name, CallableMemberDescriptor> membersFromSupertypesByName = OverrideResolver.groupDescriptorsByName(membersFromSupertypes);
        MultiMap<Name, CallableMemberDescriptor> membersFromCurrentByName = OverrideResolver.groupDescriptorsByName(classDescriptor.getDeclaredCallableMembers());
        LinkedHashSet<Name> memberNames = new LinkedHashSet<Name>();
        memberNames.addAll(membersFromSupertypesByName.keySet());
        memberNames.addAll(membersFromCurrentByName.keySet());
        for (Name memberName : memberNames) {
            Collection<CallableMemberDescriptor> fromSupertypes = membersFromSupertypesByName.get(memberName);
            Collection<CallableMemberDescriptor> fromCurrent = membersFromCurrentByName.get(memberName);
            OverrideResolver.generateOverridesInFunctionGroup(memberName, fromSupertypes, fromCurrent, classDescriptor, new DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride instanceof PropertyDescriptor) {
                        classDescriptor.getBuilder().addPropertyDescriptor((PropertyDescriptor)fakeOverride);
                    } else if (fakeOverride instanceof SimpleFunctionDescriptor) {
                        classDescriptor.getBuilder().addFunctionDescriptor((SimpleFunctionDescriptor)fakeOverride);
                    } else {
                        throw new IllegalStateException(fakeOverride.getClass().getName());
                    }
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    JetDeclaration declaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(OverrideResolver.this.trace.getBindingContext(), fromCurrent);
                    OverrideResolver.this.trace.report(Errors.CONFLICTING_OVERLOADS.on(declaration, fromCurrent, fromCurrent.getContainingDeclaration().getName().getName()));
                }
            });
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getAllCallableMembers()) {
            PsiElement element;
            JetDeclaration declaration = null;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && (element = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), memberDescriptor)) instanceof JetDeclaration) {
                declaration = (JetDeclaration)element;
            }
            this.resolveUnknownVisibilityForMember(declaration, memberDescriptor);
        }
    }

    public static void generateOverridesInFunctionGroup(@NotNull Name name, @NotNull Collection<? extends CallableMemberDescriptor> functionsFromSupertypes, @NotNull Collection<? extends CallableMemberDescriptor> functionsFromCurrent, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        ArrayList<CallableMemberDescriptor> fakeOverrideList = Lists.newArrayList();
        for (CallableMemberDescriptor callableMemberDescriptor : functionsFromSupertypes) {
            boolean overrides = false;
            boolean isVisible = Visibilities.isVisible(callableMemberDescriptor, current);
            for (CallableMemberDescriptor callableMemberDescriptor2 : functionsFromCurrent) {
                OverridingUtil.OverrideCompatibilityInfo.Result result = OverridingUtil.isOverridableBy(callableMemberDescriptor, callableMemberDescriptor2).getResult();
                if (result == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) {
                    if (isVisible) {
                        OverridingUtil.bindOverride(callableMemberDescriptor2, callableMemberDescriptor);
                    }
                    overrides = true;
                    continue;
                }
                if (result != OverridingUtil.OverrideCompatibilityInfo.Result.CONFLICT) continue;
                sink.conflict(callableMemberDescriptor, callableMemberDescriptor2);
            }
            for (CallableMemberDescriptor callableMemberDescriptor3 : fakeOverrideList) {
                if (OverridingUtil.isOverridableBy(callableMemberDescriptor, callableMemberDescriptor3).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                OverridingUtil.bindOverride(callableMemberDescriptor3, callableMemberDescriptor);
                overrides = true;
            }
            if (overrides) continue;
            CallableMemberDescriptor fakeOverride = callableMemberDescriptor.copy(current, false, !isVisible, CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
            OverridingUtil.bindOverride(fakeOverride, callableMemberDescriptor);
            fakeOverrideList.add(fakeOverride);
            sink.addToScope(fakeOverride);
        }
    }

    private static <T extends DeclarationDescriptor> MultiMap<Name, T> groupDescriptorsByName(Collection<T> properties) {
        LinkedMultiMap<Name, DeclarationDescriptor> r = new LinkedMultiMap<Name, DeclarationDescriptor>();
        for (DeclarationDescriptor property : properties) {
            r.putValue(property.getName(), property);
        }
        return r;
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromSupertypes(ClassDescriptor classDescriptor) {
        LinkedHashSet<CallableMemberDescriptor> r = Sets.newLinkedHashSet();
        for (JetType jetType : classDescriptor.getTypeConstructor().getSupertypes()) {
            r.addAll(OverrideResolver.getCallableMembersFromType(jetType.getMemberScope()));
        }
        return new ArrayList<CallableMemberDescriptor>(r);
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromType(JetScope scope) {
        ArrayList<CallableMemberDescriptor> r = Lists.newArrayList();
        for (DeclarationDescriptor decl : scope.getAllDescriptors()) {
            if (!(decl instanceof PropertyDescriptor) && !(decl instanceof SimpleFunctionDescriptor)) continue;
            r.add((CallableMemberDescriptor)decl);
        }
        return r;
    }

    private void checkOverrides() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.checkOverridesInAClass(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.checkOverridesInAClass(entry.getValue(), (JetClassOrObject)((Object)entry.getKey()));
        }
    }

    protected void checkOverridesInAClass(@NotNull MutableClassDescriptor classDescriptor, @NotNull JetClassOrObject klass) {
        block8: {
            CallableMemberDescriptor memberDescriptor;
            if (this.topDownAnalysisParameters.isAnalyzingBootstrapLibrary()) {
                return;
            }
            for (CallableMemberDescriptor member : classDescriptor.getDeclaredCallableMembers()) {
                this.checkOverrideForMember(member);
            }
            LinkedHashSet<CallableMemberDescriptor> abstractNoImpl = Sets.newLinkedHashSet();
            LinkedHashSet<CallableMemberDescriptor> manyImpl = Sets.newLinkedHashSet();
            OverrideResolver.collectMissingImplementations(classDescriptor, abstractNoImpl, manyImpl);
            PsiElement nameIdentifier = null;
            if (klass instanceof JetClass) {
                nameIdentifier = klass.getNameIdentifier();
            } else if (klass instanceof JetObjectDeclaration && (nameIdentifier = klass.getNameIdentifier()) == null) {
                nameIdentifier = ((JetObjectDeclaration)klass).getObjectKeyword();
            }
            if (nameIdentifier == null) {
                return;
            }
            Iterator i$ = manyImpl.iterator();
            if (i$.hasNext()) {
                memberDescriptor = (CallableMemberDescriptor)i$.next();
                this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(nameIdentifier, klass, memberDescriptor));
            }
            if (classDescriptor.getModality() == Modality.ABSTRACT) {
                return;
            }
            i$ = abstractNoImpl.iterator();
            if (!i$.hasNext()) break block8;
            memberDescriptor = (CallableMemberDescriptor)i$.next();
            this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on(nameIdentifier, klass, memberDescriptor));
        }
    }

    public static void collectMissingImplementations(MutableClassDescriptor classDescriptor, Set<CallableMemberDescriptor> abstractNoImpl, Set<CallableMemberDescriptor> manyImpl) {
        for (CallableMemberDescriptor descriptor : classDescriptor.getAllCallableMembers()) {
            OverrideResolver.collectMissingImplementations(descriptor, abstractNoImpl, manyImpl);
        }
    }

    private static void collectMissingImplementations(CallableMemberDescriptor descriptor, Set<CallableMemberDescriptor> abstractNoImpl, Set<CallableMemberDescriptor> manyImpl) {
        if (!descriptor.getKind().isReal()) {
            Collection<CallableMemberDescriptor> overriddenDeclarations = OverridingUtil.getOverriddenDeclarations(descriptor);
            if (overriddenDeclarations.size() == 0) {
                throw new IllegalStateException("A 'fake override' must override something");
            }
            ArrayList<CallableMemberDescriptor> nonAbstractManyImpl = Lists.newArrayList();
            Set<CallableMemberDescriptor> filteredOverriddenDeclarations = OverridingUtil.filterOverrides(Sets.newHashSet(overriddenDeclarations));
            boolean allSuperAbstract = true;
            for (CallableMemberDescriptor overridden : filteredOverriddenDeclarations) {
                if (overridden.getModality() == Modality.ABSTRACT) continue;
                nonAbstractManyImpl.add(overridden);
                allSuperAbstract = false;
            }
            if (nonAbstractManyImpl.size() > 1) {
                manyImpl.addAll(nonAbstractManyImpl);
            } else if (allSuperAbstract) {
                abstractNoImpl.addAll(overriddenDeclarations);
            }
        }
    }

    public static Multimap<CallableMemberDescriptor, CallableMemberDescriptor> collectSuperMethods(MutableClassDescriptor classDescriptor) {
        LinkedHashSet<CallableMemberDescriptor> inheritedFunctions = Sets.newLinkedHashSet();
        for (JetType supertype : classDescriptor.getSupertypes()) {
            for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                if (!(descriptor instanceof CallableMemberDescriptor)) continue;
                CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)descriptor;
                inheritedFunctions.add(memberDescriptor);
            }
        }
        Set<CallableMemberDescriptor> filteredMembers = OverridingUtil.filterOverrides(inheritedFunctions);
        SetMultimap<CallableMemberDescriptor, CallableMemberDescriptor> factoredMembers = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        for (CallableMemberDescriptor one : filteredMembers) {
            if (factoredMembers.values().contains(one)) continue;
            for (CallableMemberDescriptor another : filteredMembers) {
                factoredMembers.put(one, one);
                if (OverridingUtil.isOverridableBy(one, another).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && OverridingUtil.isOverridableBy(another, one).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                factoredMembers.put(one, another);
            }
        }
        return factoredMembers;
    }

    private void checkOverrideForMember(@NotNull CallableMemberDescriptor declared) {
        JetNamedDeclaration member = (JetNamedDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declared);
        if (member == null) {
            Boolean delegated = this.trace.get(BindingContext.DELEGATED, declared);
            if (delegated == null || !delegated.booleanValue()) {
                throw new IllegalStateException("decriptor is not resolved to declaration and it is not delegate: " + declared + ", DELEGATED: " + delegated);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        JetModifierList modifierList = member.getModifierList();
        ASTNode overrideNode = modifierList != null ? modifierList.getModifierNode(JetTokens.OVERRIDE_KEYWORD) : null;
        boolean hasOverrideModifier = overrideNode != null;
        boolean finalOverriddenError = false;
        boolean typeMismatchError = false;
        boolean kindMismatchError = false;
        for (CallableMemberDescriptor callableMemberDescriptor : declared.getOverriddenDescriptors()) {
            if (callableMemberDescriptor == null || !hasOverrideModifier) continue;
            if (!callableMemberDescriptor.getModality().isOverridable() && !finalOverriddenError) {
                this.trace.report(Errors.OVERRIDING_FINAL_MEMBER.on(overrideNode.getPsi(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                finalOverriddenError = true;
            }
            if (!OverridingUtil.isReturnTypeOkForOverride(JetTypeChecker.INSTANCE, callableMemberDescriptor, declared) && !typeMismatchError) {
                this.trace.report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, callableMemberDescriptor));
                typeMismatchError = true;
            }
            if (!this.checkPropertyKind(callableMemberDescriptor, true) || !this.checkPropertyKind(declared, false) || kindMismatchError) continue;
            this.trace.report(Errors.VAR_OVERRIDDEN_BY_VAL.on((JetProperty)member, (PropertyDescriptor)declared, (PropertyDescriptor)callableMemberDescriptor));
            kindMismatchError = true;
        }
        if (hasOverrideModifier && declared.getOverriddenDescriptors().size() == 0) {
            DeclarationDescriptor containingDeclaration = declared.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : "Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            CallableMemberDescriptor invisibleOverriddenDescriptor = this.findInvisibleOverriddenDescriptor(declared, classDescriptor);
            if (invisibleOverriddenDescriptor != null) {
                this.trace.report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on(member, declared, invisibleOverriddenDescriptor, invisibleOverriddenDescriptor.getContainingDeclaration()));
            } else {
                this.trace.report(Errors.NOTHING_TO_OVERRIDE.on(member, declared));
            }
        }
        PsiElement nameIdentifier = member.getNameIdentifier();
        if (!hasOverrideModifier && declared.getOverriddenDescriptors().size() > 0 && nameIdentifier != null) {
            CallableMemberDescriptor callableMemberDescriptor = declared.getOverriddenDescriptors().iterator().next();
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on(member, declared, callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
        }
    }

    private CallableMemberDescriptor findInvisibleOverriddenDescriptor(CallableMemberDescriptor declared, ClassDescriptor declaringClass) {
        CallableMemberDescriptor invisibleOverride = null;
        block0: for (JetType jetType : declaringClass.getTypeConstructor().getSupertypes()) {
            LinkedHashSet<CallableDescriptor> all = Sets.newLinkedHashSet();
            all.addAll(jetType.getMemberScope().getFunctions(declared.getName()));
            all.addAll(jetType.getMemberScope().getProperties(declared.getName()));
            for (CallableMemberDescriptor callableMemberDescriptor : all) {
                if (OverridingUtil.isOverridableBy(callableMemberDescriptor, declared).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                invisibleOverride = callableMemberDescriptor;
                if (!Visibilities.isVisible(callableMemberDescriptor, declared)) break block0;
                throw new IllegalStateException("Descriptor " + callableMemberDescriptor + "is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
            }
        }
        return invisibleOverride;
    }

    private void checkParameterOverridesForAllClasses() {
        ArrayList<MutableClassDescriptor> allClasses = Lists.newArrayList(this.context.getClasses().values());
        allClasses.addAll(this.context.getObjects().values());
        for (MutableClassDescriptor classDescriptor : allClasses) {
            Set<CallableMemberDescriptor> members = classDescriptor.getAllCallableMembers();
            for (CallableMemberDescriptor member : members) {
                this.checkOverridesForParameters(member);
            }
        }
    }

    private void checkOverridesForParameters(CallableMemberDescriptor declared) {
        JetModifierListOwner declaration;
        boolean fakeOverride;
        boolean bl = fakeOverride = declared.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        if (!fakeOverride && !(declaration = (JetModifierListOwner)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declared)).hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        block0: for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            JetClassOrObject classElement;
            JetParameter parameter = fakeOverride ? null : (JetParameter)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), parameterFromSubclass);
            JetClassOrObject jetClassOrObject = classElement = fakeOverride ? (JetClassOrObject)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declared.getContainingDeclaration()) : null;
            if (parameterFromSubclass.declaresDefaultValue() && !fakeOverride) {
                this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on(parameter));
            }
            boolean superWithDefault = false;
            for (ValueParameterDescriptor valueParameterDescriptor : parameterFromSubclass.getOverriddenDescriptors()) {
                if (valueParameterDescriptor.declaresDefaultValue()) {
                    if (!superWithDefault) {
                        superWithDefault = true;
                    } else {
                        if (fakeOverride) {
                            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on(classElement, parameterFromSubclass));
                            continue block0;
                        }
                        this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on(parameter, parameterFromSubclass));
                        continue block0;
                    }
                }
                if (valueParameterDescriptor.getName().equals(parameterFromSubclass.getName())) continue;
                if (fakeOverride) {
                    this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on(classElement, declared.getOverriddenDescriptors(), valueParameterDescriptor.getIndex() + 1));
                    continue;
                }
                this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on(parameter, (ClassDescriptor)valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration(), valueParameterDescriptor));
            }
        }
    }

    private boolean checkPropertyKind(CallableMemberDescriptor descriptor, boolean isVar) {
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            return propertyDescriptor.isVar() == isVar;
        }
        return false;
    }

    private void resolveUnknownVisibilityForMember(@Nullable JetDeclaration member, @NotNull CallableMemberDescriptor memberDescriptor) {
        this.resolveUnknownVisibilityForOverriddenDescriptors(memberDescriptor.getOverriddenDescriptors());
        if (memberDescriptor.getVisibility() != Visibilities.INHERITED) {
            return;
        }
        Visibility visibility = this.findMaxVisibility(memberDescriptor.getOverriddenDescriptors());
        if (visibility == null) {
            if (member != null) {
                this.trace.report(Errors.CANNOT_INFER_VISIBILITY.on(member));
            }
            visibility = Visibilities.PUBLIC;
        }
        if (memberDescriptor instanceof PropertyDescriptor) {
            ((PropertyDescriptor)memberDescriptor).setVisibility(visibility);
        } else {
            assert (memberDescriptor instanceof FunctionDescriptorImpl);
            ((FunctionDescriptorImpl)memberDescriptor).setVisibility(visibility);
        }
    }

    private void resolveUnknownVisibilityForOverriddenDescriptors(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            if (callableMemberDescriptor.getVisibility() != Visibilities.INHERITED) continue;
            PsiElement element = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), callableMemberDescriptor);
            JetDeclaration declaration = element instanceof JetDeclaration ? (JetDeclaration)element : null;
            this.resolveUnknownVisibilityForMember(declaration, callableMemberDescriptor);
        }
    }

    @Nullable
    private Visibility findMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return Visibilities.INTERNAL;
        }
        Visibility maxVisibility = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            Visibility visibility = callableMemberDescriptor.getVisibility();
            assert (visibility != Visibilities.INHERITED);
            if (maxVisibility == null) {
                maxVisibility = visibility;
                continue;
            }
            Integer compareResult = Visibilities.compare(visibility, maxVisibility);
            if (compareResult == null) {
                maxVisibility = null;
                continue;
            }
            if (compareResult <= 0) continue;
            maxVisibility = visibility;
        }
        if (maxVisibility == null) {
            return null;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            Integer compareResult = Visibilities.compare(maxVisibility, callableMemberDescriptor.getVisibility());
            if (compareResult != null && compareResult >= 0) continue;
            return null;
        }
        return maxVisibility;
    }

    private void checkVisibility() {
        for (Map.Entry<JetDeclaration, CallableMemberDescriptor> entry : this.context.getMembers().entrySet()) {
            this.checkVisibilityForMember(entry.getKey(), entry.getValue());
        }
    }

    private void checkVisibilityForMember(@NotNull JetDeclaration declaration, @NotNull CallableMemberDescriptor memberDescriptor) {
        Visibility visibility = memberDescriptor.getVisibility();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Integer compare = Visibilities.compare(visibility, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
            return;
        }
    }

    public static interface DescriptorSink {
        public void addToScope(@NotNull CallableMemberDescriptor var1);

        public void conflict(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }
}

