/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.NamespaceFactory;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class NamespaceFactoryImpl
implements NamespaceFactory {
    private ModuleDescriptor moduleDescriptor;
    private BindingTrace trace;
    private ModuleConfiguration configuration;

    @Inject
    public void setModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Inject
    public void setConfiguration(ModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    @NotNull
    public NamespaceDescriptorImpl createNamespaceDescriptorPathIfNeeded(@NotNull JetFile file, @NotNull JetScope outerScope, @NotNull RedeclarationHandler handler) {
        NamespaceDescriptorImpl namespaceDescriptor;
        NamespaceDescriptorImpl currentOwner;
        JetNamespaceHeader namespaceHeader = file.getNamespaceHeader();
        if (this.moduleDescriptor.getRootNamespaceDescriptorImpl() == null) {
            this.createRootNamespaceDescriptorIfNeeded(null, this.moduleDescriptor, null, handler);
        }
        if ((currentOwner = this.moduleDescriptor.getRootNamespaceDescriptorImpl()) == null) {
            throw new IllegalStateException("must be initialized 5 lines above");
        }
        for (JetSimpleNameExpression nameExpression : namespaceHeader.getParentNamespaceNames()) {
            Name namespaceName = JetPsiUtil.safeName(nameExpression.getReferencedName());
            NamespaceDescriptorImpl namespaceDescriptor2 = this.createNamespaceDescriptorIfNeeded(null, currentOwner, namespaceName, nameExpression, handler);
            this.trace.record(BindingContext.NAMESPACE_IS_SRC, namespaceDescriptor2, true);
            this.trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, outerScope);
            outerScope = namespaceDescriptor2.getMemberScope();
            currentOwner = namespaceDescriptor2;
        }
        if (namespaceHeader.isRoot()) {
            namespaceDescriptor = this.moduleDescriptor.getRootNamespaceDescriptorImpl();
            this.storeBindingForFileAndExpression(file, null, namespaceDescriptor);
        } else {
            Name name = namespaceHeader.getNameAsName();
            namespaceDescriptor = this.createNamespaceDescriptorIfNeeded(file, currentOwner, name, namespaceHeader.getLastPartExpression(), handler);
            this.trace.record(BindingContext.NAMESPACE_IS_SRC, namespaceDescriptor, true);
            this.trace.record(BindingContext.RESOLUTION_SCOPE, namespaceHeader, outerScope);
        }
        return namespaceDescriptor;
    }

    @Override
    @NotNull
    public NamespaceDescriptorImpl createNamespaceDescriptorPathIfNeeded(@NotNull FqName fqName) {
        NamespaceDescriptorImpl owner = null;
        for (FqName pathElement : fqName.path()) {
            if (pathElement.isRoot()) {
                owner = this.createRootNamespaceDescriptorIfNeeded(null, this.moduleDescriptor, null, RedeclarationHandler.DO_NOTHING);
                continue;
            }
            assert (owner != null) : "Should never be null as first element in the path must be root";
            owner = this.createNamespaceDescriptorIfNeeded(null, owner, pathElement.shortName(), null, RedeclarationHandler.DO_NOTHING);
        }
        assert (owner != null) : "Should never be null as first element in the path must be root";
        return owner;
    }

    private NamespaceDescriptorImpl createRootNamespaceDescriptorIfNeeded(@Nullable JetFile file, @NotNull ModuleDescriptor owner, @Nullable JetReferenceExpression expression, @NotNull RedeclarationHandler handler) {
        FqName fqName = FqName.ROOT;
        NamespaceDescriptorImpl namespaceDescriptor = owner.getRootNamespaceDescriptorImpl();
        if (namespaceDescriptor == null) {
            namespaceDescriptor = this.createNewNamespaceDescriptor(owner, FqNameUnsafe.ROOT_NAME, expression, handler, fqName);
        }
        this.storeBindingForFileAndExpression(file, expression, namespaceDescriptor);
        return namespaceDescriptor;
    }

    @NotNull
    private NamespaceDescriptorImpl createNamespaceDescriptorIfNeeded(@Nullable JetFile file, @NotNull NamespaceDescriptorImpl owner, @NotNull Name name, @Nullable JetReferenceExpression expression, @NotNull RedeclarationHandler handler) {
        FqName ownerFqName = DescriptorUtils.getFQName(owner).toSafe();
        FqName fqName = ownerFqName.child(name);
        NamespaceDescriptorImpl namespaceDescriptor = (NamespaceDescriptorImpl)owner.getMemberScope().getDeclaredNamespace(name);
        if (namespaceDescriptor == null) {
            namespaceDescriptor = this.createNewNamespaceDescriptor(owner, name, expression, handler, fqName);
        }
        this.storeBindingForFileAndExpression(file, expression, namespaceDescriptor);
        return namespaceDescriptor;
    }

    private NamespaceDescriptorImpl createNewNamespaceDescriptor(NamespaceDescriptorParent owner, Name name, PsiElement expression, RedeclarationHandler handler, FqName fqName) {
        NamespaceDescriptorImpl namespaceDescriptor = new NamespaceDescriptorImpl(owner, Collections.<AnnotationDescriptor>emptyList(), name);
        this.trace.record(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, fqName, namespaceDescriptor);
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, namespaceDescriptor, handler, "Namespace member scope");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        namespaceDescriptor.initialize(scope);
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.configuration.extendNamespaceScope(this.trace, namespaceDescriptor, scope);
        owner.addNamespace(namespaceDescriptor);
        if (expression != null) {
            this.trace.record(BindingContext.NAMESPACE, expression, namespaceDescriptor);
        }
        return namespaceDescriptor;
    }

    private void storeBindingForFileAndExpression(@Nullable JetFile file, @Nullable JetReferenceExpression expression, @NotNull NamespaceDescriptor namespaceDescriptor) {
        if (expression != null) {
            this.trace.record(BindingContext.REFERENCE_TARGET, expression, namespaceDescriptor);
        }
        if (file != null) {
            this.trace.record(BindingContext.FILE_TO_NAMESPACE, file, namespaceDescriptor);
            Collection<JetFile> files = this.trace.get(BindingContext.NAMESPACE_TO_FILES, namespaceDescriptor);
            if (files == null) {
                files = Sets.newIdentityHashSet();
            }
            files.add(file);
            this.trace.record(BindingContext.NAMESPACE_TO_FILES, namespaceDescriptor, files);
        }
    }
}

