/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class ImportsResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ModuleConfiguration configuration;
    @NotNull
    private QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private BindingTrace trace;

    @Inject
    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    @Inject
    public void setConfiguration(@NotNull ModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    @Inject
    public void setQualifiedExpressionResolver(@NotNull QualifiedExpressionResolver qualifiedExpressionResolver) {
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    public void processTypeImports(@NotNull JetScope rootScope) {
        this.processImports(true, rootScope);
    }

    public void processMembersImports(@NotNull JetScope rootScope) {
        this.processImports(false, rootScope);
    }

    private void processImports(boolean onlyClasses, @NotNull JetScope rootScope) {
        for (JetFile file : this.context.getNamespaceDescriptors().keySet()) {
            WritableScope namespaceScope = this.context.getNamespaceScopes().get(file);
            this.processImportsInFile(onlyClasses, namespaceScope, file.getImportDirectives(), rootScope);
        }
        for (JetScript script : this.context.getScripts().keySet()) {
            WritableScope scriptScope = this.context.getScriptScopes().get(script);
            this.processImportsInFile(onlyClasses, scriptScope, script.getImportDirectives(), rootScope);
        }
    }

    private void processImportsInFile(boolean classes, WritableScope scope, List<JetImportDirective> directives, JetScope rootScope) {
        ImportsResolver.processImportsInFile(classes, scope, directives, rootScope, this.configuration, this.trace, this.qualifiedExpressionResolver);
    }

    public static void processImportsInFile(boolean onlyClasses, @NotNull WritableScope namespaceScope, @NotNull List<JetImportDirective> importDirectives, @NotNull JetScope rootScope, @NotNull ModuleConfiguration configuration, @NotNull BindingTrace trace, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver) {
        Importer.DelayedImporter delayedImporter = new Importer.DelayedImporter(namespaceScope);
        if (!onlyClasses) {
            namespaceScope.clearImports();
        }
        HashMap<JetImportDirective, DeclarationDescriptor> resolvedDirectives = Maps.newHashMap();
        ArrayList<JetImportDirective> defaultImportDirectives = Lists.newArrayList();
        configuration.addDefaultImports(defaultImportDirectives);
        for (JetImportDirective defaultImportDirective : defaultImportDirectives) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace);
            qualifiedExpressionResolver.processImportReference(defaultImportDirective, rootScope, namespaceScope, delayedImporter, temporaryTrace, onlyClasses);
        }
        for (JetImportDirective importDirective : importDirectives) {
            Collection<? extends DeclarationDescriptor> descriptors = qualifiedExpressionResolver.processImportReference(importDirective, rootScope, namespaceScope, delayedImporter, trace, onlyClasses);
            if (descriptors.size() != 1) continue;
            resolvedDirectives.put(importDirective, descriptors.iterator().next());
        }
        delayedImporter.processImports();
        if (!onlyClasses) {
            for (JetImportDirective importDirective : importDirectives) {
                ImportsResolver.reportUselessImport(importDirective, namespaceScope, resolvedDirectives, trace);
            }
        }
    }

    private static void reportUselessImport(@NotNull JetImportDirective importDirective, @NotNull WritableScope namespaceScope, @NotNull Map<JetImportDirective, DeclarationDescriptor> resolvedDirectives, @NotNull BindingTrace trace) {
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null || !resolvedDirectives.containsKey(importDirective)) {
            return;
        }
        Name aliasName = JetPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            return;
        }
        DeclarationDescriptor wasResolved = resolvedDirectives.get(importDirective);
        DeclarationDescriptor isResolved = null;
        if (wasResolved instanceof ClassDescriptor) {
            isResolved = namespaceScope.getClassifier(aliasName);
        } else if (wasResolved instanceof VariableDescriptor) {
            isResolved = namespaceScope.getLocalVariable(aliasName);
        } else if (wasResolved instanceof NamespaceDescriptor) {
            isResolved = namespaceScope.getNamespace(aliasName);
        }
        if (isResolved != null && isResolved != wasResolved) {
            trace.report(Errors.USELESS_HIDDEN_IMPORT.on(importedReference));
        }
        if (!importDirective.isAllUnder() && importedReference instanceof JetSimpleNameExpression && importDirective.getAliasName() == null) {
            trace.report(Errors.USELESS_SIMPLE_IMPORT.on(importedReference));
        }
    }
}

