/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

interface Importer {
    public static final Importer DO_NOTHING = new Importer(){

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor) {
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
        }
    };

    public void addAllUnderImport(@NotNull DeclarationDescriptor var1);

    public void addAliasImport(@NotNull DeclarationDescriptor var1, @NotNull Name var2);

    public static class DelayedImporter
    extends StandardImporter {
        private final List<Pair<DeclarationDescriptor, Name>> imports = Lists.newArrayList();

        public DelayedImporter(@NotNull WritableScope namespaceScope) {
            super(namespaceScope);
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor) {
            this.imports.add(Pair.create(descriptor, null));
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            this.imports.add(Pair.create(descriptor, aliasName));
        }

        public void processImports() {
            for (Pair<DeclarationDescriptor, Name> anImport : this.imports) {
                boolean allUnderImport;
                DeclarationDescriptor descriptor = anImport.getFirst();
                Name aliasName = anImport.getSecond();
                boolean bl = allUnderImport = aliasName == null;
                if (allUnderImport) {
                    this.importAllUnderDeclaration(descriptor);
                    continue;
                }
                this.importDeclarationAlias(descriptor, aliasName);
            }
        }
    }

    public static class StandardImporter
    implements Importer {
        private final WritableScope namespaceScope;

        public StandardImporter(WritableScope namespaceScope) {
            this.namespaceScope = namespaceScope;
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor) {
            this.importAllUnderDeclaration(descriptor);
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            this.importDeclarationAlias(descriptor, aliasName);
        }

        protected void importAllUnderDeclaration(@NotNull DeclarationDescriptor descriptor) {
            if (descriptor instanceof NamespaceDescriptor) {
                this.namespaceScope.importScope(((NamespaceDescriptor)descriptor).getMemberScope());
            }
            if (descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.OBJECT) {
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
                this.namespaceScope.importScope(classDescriptor.getUnsubstitutedInnerClassesScope());
                ClassDescriptor classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
                if (classObjectDescriptor != null) {
                    this.namespaceScope.importScope(classObjectDescriptor.getUnsubstitutedInnerClassesScope());
                }
            }
        }

        protected void importDeclarationAlias(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            if (descriptor instanceof ClassifierDescriptor) {
                this.namespaceScope.importClassifierAlias(aliasName, (ClassifierDescriptor)descriptor);
            } else if (descriptor instanceof NamespaceDescriptor) {
                this.namespaceScope.importNamespaceAlias(aliasName, (NamespaceDescriptor)descriptor);
            } else if (descriptor instanceof FunctionDescriptor) {
                this.namespaceScope.importFunctionAlias(aliasName, (FunctionDescriptor)descriptor);
            } else if (descriptor instanceof VariableDescriptor) {
                this.namespaceScope.importVariableAlias(aliasName, (VariableDescriptor)descriptor);
            }
        }
    }
}

