/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class ImportPath {
    @NotNull
    private final FqName fqName;
    private final boolean isAllUnder;

    public ImportPath(@NotNull FqName fqName, boolean isAllUnder) {
        this.fqName = fqName;
        this.isAllUnder = isAllUnder;
    }

    public ImportPath(@NotNull String pathStr) {
        if (pathStr.endsWith(".*")) {
            this.isAllUnder = true;
            this.fqName = new FqName(pathStr.substring(0, pathStr.length() - 2));
        } else {
            this.isAllUnder = false;
            this.fqName = new FqName(pathStr);
        }
    }

    public String getPathStr() {
        return this.fqName.getFqName() + (this.isAllUnder ? ".*" : "");
    }

    public String toString() {
        return this.getPathStr();
    }

    @NotNull
    public FqName fqnPart() {
        return this.fqName;
    }

    public boolean isAllUnder() {
        return this.isAllUnder;
    }

    public int hashCode() {
        return 31 * this.fqName.hashCode() + (this.isAllUnder ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImportPath)) {
            return false;
        }
        ImportPath other = (ImportPath)obj;
        return this.fqName.equals(other.fqName) && this.isAllUnder == other.isAllUnder;
    }
}

