/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class DescriptorUtils {
    @NotNull
    public static <D extends CallableDescriptor> D substituteBounds(@NotNull D functionDescriptor) {
        final List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return functionDescriptor;
        }
        final HashMap<TypeConstructor, TypeParameterDescriptor> typeConstructors = Maps.newHashMap();
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            typeConstructors.put(typeParameter.getTypeConstructor(), typeParameter);
        }
        return (D)functionDescriptor.substitute(new TypeSubstitutor(TypeSubstitution.EMPTY){

            @Override
            public boolean inRange(@NotNull TypeConstructor typeConstructor) {
                return typeConstructors.containsKey(typeConstructor);
            }

            @Override
            public boolean isEmpty() {
                return typeParameters.isEmpty();
            }

            @Override
            @NotNull
            public TypeSubstitution getSubstitution() {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public JetType safeSubstitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) {
                JetType substituted = this.substitute(type, howThisTypeIsUsed);
                if (substituted == null) {
                    return ErrorUtils.createErrorType("Substitution failed");
                }
                return substituted;
            }

            @Override
            @Nullable
            public JetType substitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) {
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeConstructors.get(type.getConstructor());
                if (typeParameterDescriptor != null) {
                    switch (howThisTypeIsUsed) {
                        case INVARIANT: {
                            return type;
                        }
                        case IN_VARIANCE: {
                            throw new UnsupportedOperationException();
                        }
                        case OUT_VARIANCE: {
                            return typeParameterDescriptor.getDefaultType();
                        }
                    }
                }
                return super.substitute(type, howThisTypeIsUsed);
            }
        });
    }

    public static Modality convertModality(Modality modality, boolean makeNonAbstract) {
        if (makeNonAbstract && modality == Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        return modality;
    }

    @NotNull
    public static ReceiverDescriptor getExpectedThisObjectIfNeeded(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            return classDescriptor.getImplicitReceiver();
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            ScriptDescriptor scriptDescriptor = (ScriptDescriptor)containingDeclaration;
            return scriptDescriptor.getImplicitReceiver();
        }
        return ReceiverDescriptor.NO_RECEIVER;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate) {
        if (candidate instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent = candidate.getContainingDeclaration();
        if (!(parent instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)parent;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static FqNameUnsafe getFQName(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (descriptor instanceof ModuleDescriptor || containingDeclaration instanceof ModuleDescriptor) {
            return FqName.ROOT.toUnsafe();
        }
        if (containingDeclaration == null) {
            if (descriptor instanceof NamespaceDescriptor) {
                if (descriptor.getName().equals(Name.identifier("jet"))) {
                    return FqNameUnsafe.topLevel(Name.identifier("jet"));
                }
                if (descriptor.getName().equals(Name.special("<java_root>"))) {
                    return FqName.ROOT.toUnsafe();
                }
            }
            throw new IllegalStateException("descriptor is not module descriptor and has null containingDeclaration: " + containingDeclaration);
        }
        return DescriptorUtils.getFQName(containingDeclaration).child(descriptor.getName());
    }

    public static boolean isTopLevelFunction(@NotNull SimpleFunctionDescriptor functionDescriptor) {
        return functionDescriptor.getContainingDeclaration() instanceof NamespaceDescriptor;
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass) {
        return DescriptorUtils.getParentOfType(descriptor, aClass, true);
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass, boolean strict) {
        if (descriptor == null) {
            return null;
        }
        if (strict) {
            descriptor = descriptor.getContainingDeclaration();
        }
        while (descriptor != null) {
            if (aClass.isInstance(descriptor)) {
                return (D)descriptor;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return null;
    }

    public static boolean isAncestor(@Nullable DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor, boolean strict) {
        DeclarationDescriptor descriptor;
        if (ancestor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor = strict ? declarationDescriptor.getContainingDeclaration() : declarationDescriptor;
        while (descriptor != null) {
            if (ancestor == descriptor) {
                return true;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return false;
    }

    @Nullable
    public static VariableDescriptor filterNonExtensionProperty(Set<VariableDescriptor> variables) {
        for (VariableDescriptor variable : variables) {
            if (variable.getReceiverParameter().exists()) continue;
            return variable;
        }
        return null;
    }

    @NotNull
    public static JetType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor, @NotNull JetElement function) {
        JetType expectedType = function instanceof JetFunction ? (((JetFunction)function).getReturnTypeRef() != null || ((JetFunction)function).hasBlockBody() ? descriptor.getReturnType() : TypeUtils.NO_EXPECTED_TYPE) : (function instanceof JetSecondaryConstructor ? JetStandardClasses.getUnitType() : descriptor.getReturnType());
        return expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
    }

    public static boolean isObject(@NotNull ClassifierDescriptor classifier) {
        if (classifier instanceof ClassDescriptor) {
            ClassDescriptor clazz = (ClassDescriptor)classifier;
            return clazz.getKind() == ClassKind.OBJECT || clazz.getKind() == ClassKind.ENUM_ENTRY;
        }
        if (classifier instanceof TypeParameterDescriptor) {
            return false;
        }
        throw new IllegalStateException("unknown classifier: " + classifier);
    }

    public static boolean isSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        return DescriptorUtils.isSubtypeOfClass(subClass.getDefaultType(), superClass.getOriginal());
    }

    private static boolean isSubtypeOfClass(@NotNull JetType type, @NotNull DeclarationDescriptor superClass) {
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && superClass == descriptor.getOriginal()) {
            return true;
        }
        for (JetType jetType : type.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(jetType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static void addSuperTypes(JetType type, Set<JetType> set) {
        set.add(type);
        for (JetType jetType : type.getConstructor().getSupertypes()) {
            DescriptorUtils.addSuperTypes(jetType, set);
        }
    }

    public static boolean isTopLevelNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        return namespaceDescriptor.getContainingDeclaration() instanceof NamespaceDescriptor && namespaceDescriptor.getContainingDeclaration().getContainingDeclaration() instanceof ModuleDescriptor;
    }

    public static boolean isRootNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        return namespaceDescriptor.getContainingDeclaration() instanceof ModuleDescriptor;
    }

    @NotNull
    public static List<DeclarationDescriptor> getPathWithoutRootNsAndModule(@NotNull DeclarationDescriptor descriptor) {
        ArrayList<DeclarationDescriptor> path = Lists.newArrayList();
        DeclarationDescriptor current = descriptor;
        while (!(current instanceof NamespaceDescriptor) || !DescriptorUtils.isRootNamespace((NamespaceDescriptor)current)) {
            path.add(current);
            current = current.getContainingDeclaration();
        }
        return Lists.reverse(path);
    }

    public static boolean isClassObject(@NotNull DeclarationDescriptor descriptor) {
        ClassDescriptor classDescriptor;
        if (descriptor instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)descriptor).getKind() == ClassKind.OBJECT && classDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)classDescriptor.getContainingDeclaration();
            if (((Object)classDescriptor.getDefaultType()).equals(containingDeclaration.getClassObjectType())) {
                return true;
            }
        }
        return false;
    }
}

