/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.LocalVariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.lazy.LazyValue;
import org.jetbrains.jet.util.lazy.LazyValueWithDefault;

public class DescriptorResolver {
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public void resolveMutableClassDescriptor(@NotNull JetClass classElement, @NotNull MutableClassDescriptor descriptor, BindingTrace trace) {
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        int index = 0;
        for (JetTypeParameter typeParameter : classElement.getTypeParameters()) {
            TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(descriptor, this.annotationResolver.createAnnotationStubs(typeParameter.getModifierList(), trace), typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index);
            trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
            typeParameters.add(typeParameterDescriptor);
            ++index;
        }
        descriptor.setTypeParameterDescriptors(typeParameters);
        Modality defaultModality = descriptor.getKind() == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
        descriptor.setModality(DescriptorResolver.resolveModalityFromModifiers(classElement.getModifierList(), defaultModality));
        descriptor.setVisibility(DescriptorResolver.resolveVisibilityFromModifiers(classElement.getModifierList()));
        trace.record(BindingContext.CLASS, classElement, descriptor);
    }

    public void resolveSupertypesForMutableClassDescriptor(@NotNull JetClassOrObject jetClass, @NotNull MutableClassDescriptor descriptor, BindingTrace trace) {
        for (JetType supertype : this.resolveSupertypes(descriptor.getScopeForSupertypeResolution(), jetClass, trace)) {
            descriptor.addSupertype(supertype);
        }
    }

    public List<JetType> resolveSupertypes(@NotNull JetScope scope, @NotNull JetClassOrObject jetClass, BindingTrace trace) {
        ArrayList<JetType> result = Lists.newArrayList();
        List<JetDelegationSpecifier> delegationSpecifiers = jetClass.getDelegationSpecifiers();
        if (delegationSpecifiers.isEmpty()) {
            result.add(this.getDefaultSupertype(jetClass, trace));
        } else {
            Collection<JetType> supertypes = this.resolveDelegationSpecifiers(scope, delegationSpecifiers, this.typeResolver, trace, false);
            for (JetType supertype : supertypes) {
                result.add(supertype);
            }
        }
        return result;
    }

    private JetType getDefaultSupertype(JetClassOrObject jetClass, BindingTrace trace) {
        if (jetClass instanceof JetEnumEntry) {
            JetClassOrObject parent = PsiTreeUtil.getParentOfType((PsiElement)jetClass, JetClassOrObject.class);
            ClassDescriptor parentDescriptor = trace.getBindingContext().get(BindingContext.CLASS, parent);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(((JetEnumEntry)jetClass).getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        return JetStandardClasses.getAnyType();
    }

    public Collection<JetType> resolveDelegationSpecifiers(JetScope extensibleScope, List<JetDelegationSpecifier> delegationSpecifiers, @NotNull TypeResolver resolver, BindingTrace trace, boolean checkBounds) {
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JetType> result = Lists.newArrayList();
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                result.add(resolver.resolveType(extensibleScope, typeReference, trace, checkBounds));
                JetTypeElement typeElement = typeReference.getTypeElement();
                while (typeElement instanceof JetNullableType) {
                    JetNullableType nullableType = (JetNullableType)typeElement;
                    trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
                    typeElement = nullableType.getInnerType();
                }
                if (!(typeElement instanceof JetUserType)) continue;
                JetUserType userType = (JetUserType)typeElement;
                List<JetTypeProjection> typeArguments = userType.getTypeArguments();
                for (JetTypeProjection typeArgument : typeArguments) {
                    if (typeArgument.getProjectionKind() == JetProjectionKind.NONE) continue;
                    trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                }
                continue;
            }
            result.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result;
    }

    @NotNull
    public SimpleFunctionDescriptor resolveFunctionDescriptor(DeclarationDescriptor containingDescriptor, final JetScope scope, final JetNamedFunction function, final BindingTrace trace) {
        JetExpression bodyExpression;
        final SimpleFunctionDescriptorImpl functionDescriptor = new SimpleFunctionDescriptorImpl(containingDescriptor, this.annotationResolver.resolveAnnotations(scope, function.getModifierList(), trace), JetPsiUtil.safeName(function.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        WritableScopeImpl innerScope = new WritableScopeImpl(scope, functionDescriptor, new TraceBasedRedeclarationHandler(trace), "Function descriptor header scope");
        innerScope.addLabeledDeclaration(functionDescriptor);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.resolveTypeParameters(functionDescriptor, innerScope, function.getTypeParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.resolveGenericBounds(function, innerScope, typeParameterDescriptors, trace);
        JetType receiverType = null;
        JetTypeReference receiverTypeRef = function.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            JetScope scopeForReceiver = function.hasTypeParameterListBeforeFunctionName() ? innerScope : scope;
            receiverType = this.typeResolver.resolveType(scopeForReceiver, receiverTypeRef, trace, true);
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = this.resolveValueParameters(functionDescriptor, innerScope, function.getValueParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.READING);
        JetTypeReference returnTypeRef = function.getReturnTypeRef();
        JetType returnType = returnTypeRef != null ? this.typeResolver.resolveType(innerScope, returnTypeRef, trace, true) : (function.hasBlockBody() ? JetStandardClasses.getUnitType() : ((bodyExpression = function.getBodyExpression()) != null ? DeferredType.create(trace, (LazyValue<JetType>)new LazyValueWithDefault<JetType>(ErrorUtils.createErrorType("Recursive dependency")){

            @Override
            protected JetType compute() {
                return DescriptorResolver.this.expressionTypingServices.inferFunctionReturnType(scope, function, functionDescriptor, trace);
            }
        }) : ErrorUtils.createErrorType("No type, no body")));
        boolean hasBody = function.getBodyExpression() != null;
        Modality modality = DescriptorResolver.resolveModalityFromModifiers(function.getModifierList(), DescriptorResolver.getDefaultModality(containingDescriptor, hasBody));
        Visibility visibility = DescriptorResolver.resolveVisibilityFromModifiers(function.getModifierList());
        JetModifierList modifierList = function.getModifierList();
        boolean isInline = modifierList != null && modifierList.hasModifier(JetTokens.INLINE_KEYWORD);
        functionDescriptor.initialize(receiverType, DescriptorUtils.getExpectedThisObjectIfNeeded(containingDescriptor), typeParameterDescriptors, valueParameterDescriptors, returnType, modality, visibility, isInline);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function, functionDescriptor);
        return functionDescriptor;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.TRAIT;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    private List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, WritableScope parameterScope, List<JetParameter> valueParameters, BindingTrace trace) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        int valueParametersSize = valueParameters.size();
        for (int i = 0; i < valueParametersSize; ++i) {
            JetType type;
            JetParameter valueParameter = valueParameters.get(i);
            JetTypeReference typeReference = valueParameter.getTypeReference();
            if (typeReference == null) {
                trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on(valueParameter));
                type = ErrorUtils.createErrorType("Type annotation was missing");
            } else {
                type = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
            }
            MutableValueParameterDescriptor valueParameterDescriptor = this.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, i, type, trace);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result.add(valueParameterDescriptor);
        }
        return result;
    }

    @NotNull
    public MutableValueParameterDescriptor resolveValueParameterDescriptor(JetScope scope, DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index, JetType type, BindingTrace trace) {
        JetType varargElementType = null;
        JetType variableType = type;
        if (valueParameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            varargElementType = type;
            variableType = this.getVarargParameterType(type);
        }
        ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(declarationDescriptor, index, this.annotationResolver.resolveAnnotations(scope, valueParameter.getModifierList(), trace), JetPsiUtil.safeName(valueParameter.getName()), valueParameter.isMutable(), variableType, valueParameter.getDefaultValue() != null, varargElementType);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        return valueParameterDescriptor;
    }

    private JetType getVarargParameterType(JetType type) {
        JetType arrayType = JetStandardLibrary.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(type);
        if (arrayType != null) {
            return arrayType;
        }
        return JetStandardLibrary.getInstance().getArrayType(type);
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParameters(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, List<JetTypeParameter> typeParameters, BindingTrace trace) {
        ArrayList<TypeParameterDescriptorImpl> result = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter typeParameter = typeParameters.get(i);
            result.add(this.resolveTypeParameter(containingDescriptor, extensibleScope, typeParameter, i, trace));
        }
        return result;
    }

    private TypeParameterDescriptorImpl resolveTypeParameter(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, JetTypeParameter typeParameter, int index, BindingTrace trace) {
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, this.annotationResolver.createAnnotationStubs(typeParameter.getModifierList(), trace), typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index);
        extensibleScope.addTypeParameterDescriptor(typeParameterDescriptor);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    public void resolveGenericBounds(@NotNull JetTypeParameterListOwner declaration, JetScope scope, List<TypeParameterDescriptorImpl> parameters, BindingTrace trace) {
        ArrayList<UpperBoundCheckerTask> deferredUpperBoundCheckerTasks = Lists.newArrayList();
        List<JetTypeParameter> typeParameters = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters.size(); ++i) {
            JetTypeParameter jetTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            JetType type = this.typeResolver.resolveType(scope, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type);
            deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(extendsBound, type, false));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            Name referencedName;
            JetSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null || (referencedName = subjectTypeParameterName.getReferencedNameAsName()) == null) continue;
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            JetTypeReference boundTypeReference = constraint.getBoundTypeReference();
            JetType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope, boundTypeReference, trace, false);
                deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(boundTypeReference, bound, constraint.isClassObjectContraint()));
            }
            if (typeParameterDescriptor == null) {
                ClassifierDescriptor classifier = scope.getClassifier(referencedName);
                if (classifier != null) {
                    trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(subjectTypeParameterName, constraint, declaration));
                    trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, classifier);
                    continue;
                }
                trace.report(Errors.UNRESOLVED_REFERENCE.on(subjectTypeParameterName));
                continue;
            }
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            if (constraint.isClassObjectContraint()) {
                typeParameterDescriptor.addClassObjectBound(bound);
                continue;
            }
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters) {
            PsiElement nameIdentifier;
            JetType classObjectType;
            PsiElement nameIdentifier2;
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
            if (JetStandardClasses.isNothing(parameter.getUpperBoundsAsType()) && (nameIdentifier2 = typeParameters.get(parameter.getIndex()).getNameIdentifier()) != null) {
                trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(nameIdentifier2, parameter));
            }
            if ((classObjectType = parameter.getClassObjectType()) == null || !JetStandardClasses.isNothing(classObjectType) || (nameIdentifier = typeParameters.get(parameter.getIndex()).getNameIdentifier()) == null) continue;
            trace.report(Errors.CONFLICTING_CLASS_OBJECT_UPPER_BOUNDS.on(nameIdentifier, parameter));
        }
        for (UpperBoundCheckerTask checkerTask : deferredUpperBoundCheckerTasks) {
            DescriptorResolver.checkUpperBoundType(checkerTask.upperBound, checkerTask.upperBoundType, checkerTask.isClassObjectConstraint, trace);
        }
    }

    private static void checkUpperBoundType(JetTypeReference upperBound, JetType upperBoundType, boolean isClassObjectConstraint, BindingTrace trace) {
        if (!TypeUtils.canHaveSubtypes(JetTypeChecker.INSTANCE, upperBoundType)) {
            if (isClassObjectConstraint) {
                trace.report(Errors.FINAL_CLASS_OBJECT_UPPER_BOUND.on(upperBound, upperBoundType));
            } else {
                trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
            }
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope, @NotNull JetParameter parameter, BindingTrace trace) {
        JetType type = this.resolveParameterType(scope, parameter, trace);
        return this.resolveLocalVariableDescriptor(containingDeclaration, parameter, type, trace);
    }

    private JetType resolveParameterType(JetScope scope, JetParameter parameter, BindingTrace trace) {
        JetTypeReference typeReference = parameter.getTypeReference();
        JetType type = typeReference != null ? this.typeResolver.resolveType(scope, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type);
        }
        return type;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetParameter parameter, @NotNull JetType type, BindingTrace trace) {
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(parameter.getModifierList(), trace), JetPsiUtil.safeName(parameter.getName()), type, parameter.isMutable());
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(DeclarationDescriptor containingDeclaration, JetScope scope, JetProperty property, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        if (property.isScriptDeclaration()) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(property.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, property.isVar(), false, JetPsiUtil.safeName(property.getName()), CallableMemberDescriptor.Kind.DECLARATION);
            JetType type = this.getVariableType(scope, property, dataFlowInfo, false, trace);
            propertyDescriptor.setType(type, Collections.emptyList(), scope.getImplicitReceiver(), (JetType)null);
            trace.record(BindingContext.VARIABLE, property, propertyDescriptor);
            return propertyDescriptor;
        }
        VariableDescriptorImpl variableDescriptor = this.resolveLocalVariableDescriptorWithType(containingDeclaration, property, null, trace);
        JetType type = this.getVariableType(scope, property, dataFlowInfo, false, trace);
        variableDescriptor.setOutType(type);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptorImpl resolveLocalVariableDescriptorWithType(DeclarationDescriptor containingDeclaration, JetProperty property, JetType type, BindingTrace trace) {
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(property.getModifierList(), trace), JetPsiUtil.safeName(property.getName()), type, property.isVar());
        trace.record(BindingContext.VARIABLE, property, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveObjectDeclaration(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject objectDeclaration, @NotNull ClassDescriptor classDescriptor, BindingTrace trace) {
        boolean isProperty;
        boolean bl = isProperty = containingDeclaration instanceof NamespaceDescriptor || containingDeclaration instanceof ClassDescriptor;
        if (isProperty) {
            return this.resolveObjectDeclarationAsPropertyDescriptor(containingDeclaration, objectDeclaration, classDescriptor, trace);
        }
        return this.resolveObjectDeclarationAsLocalVariable(containingDeclaration, objectDeclaration, classDescriptor, trace);
    }

    @NotNull
    public PropertyDescriptor resolveObjectDeclarationAsPropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject objectDeclaration, @NotNull ClassDescriptor classDescriptor, BindingTrace trace) {
        JetModifierList modifierList = objectDeclaration.getModifierList();
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(modifierList, trace), Modality.FINAL, DescriptorResolver.resolveVisibilityFromModifiers(modifierList), false, true, JetPsiUtil.safeName(objectDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(classDescriptor.getDefaultType(), Collections.emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(containingDeclaration), ReceiverDescriptor.NO_RECEIVER);
        propertyDescriptor.initialize(this.createDefaultGetter(propertyDescriptor), null);
        JetObjectDeclarationName nameAsDeclaration = objectDeclaration.getNameAsDeclaration();
        if (nameAsDeclaration != null) {
            trace.record(BindingContext.OBJECT_DECLARATION, nameAsDeclaration, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    @NotNull
    private VariableDescriptor resolveObjectDeclarationAsLocalVariable(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject objectDeclaration, @NotNull ClassDescriptor classDescriptor, BindingTrace trace) {
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(objectDeclaration.getModifierList(), trace), JetPsiUtil.safeName(objectDeclaration.getName()), classDescriptor.getDefaultType(), false);
        JetObjectDeclarationName nameAsDeclaration = objectDeclaration.getNameAsDeclaration();
        if (nameAsDeclaration != null) {
            trace.record(BindingContext.VARIABLE, nameAsDeclaration, variableDescriptor);
        }
        return variableDescriptor;
    }

    public JetScope getPropertyDeclarationInnerScope(@NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull ReceiverDescriptor receiver, BindingTrace trace) {
        WritableScopeImpl result = new WritableScopeImpl(outerScope, outerScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(trace), "Property declaration inner scope");
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            result.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        if (receiver.exists()) {
            result.setImplicitReceiver(receiver);
        }
        result.changeLockLevel(WritableScope.LockLevel.READING);
        return result;
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope, JetProperty property, BindingTrace trace) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        JetScope scopeWithTypeParameters;
        JetModifierList modifierList = property.getModifierList();
        boolean isVar = property.isVar();
        boolean hasBody = DescriptorResolver.hasBody(property);
        Modality defaultModality = DescriptorResolver.getDefaultModality(containingDeclaration, hasBody);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(containingDeclaration, this.annotationResolver.resolveAnnotations(scope, modifierList, trace), DescriptorResolver.resolveModalityFromModifiers(property.getModifierList(), defaultModality), DescriptorResolver.resolveVisibilityFromModifiers(property.getModifierList()), isVar, false, JetPsiUtil.safeName(property.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        JetType receiverType = null;
        List<JetTypeParameter> typeParameters = property.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            WritableScopeImpl writableScope = new WritableScopeImpl(scope, containingDeclaration, new TraceBasedRedeclarationHandler(trace), "Scope with type parameters of a property");
            typeParameterDescriptors = this.resolveTypeParameters(containingDeclaration, writableScope, typeParameters, trace);
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.resolveGenericBounds(property, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        JetTypeReference receiverTypeRef = property.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverDescriptor receiverDescriptor = receiverType == null ? ReceiverDescriptor.NO_RECEIVER : new ExtensionReceiver(propertyDescriptor, receiverType);
        JetScope propertyScope = this.getPropertyDeclarationInnerScope(scope, typeParameterDescriptors, ReceiverDescriptor.NO_RECEIVER, trace);
        JetType type = this.getVariableType(propertyScope, property, DataFlowInfo.EMPTY, true, trace);
        propertyDescriptor.setType(type, typeParameterDescriptors, DescriptorUtils.getExpectedThisObjectIfNeeded(containingDeclaration), receiverDescriptor);
        PropertyGetterDescriptor getter = this.resolvePropertyGetterDescriptor(scopeWithTypeParameters, property, propertyDescriptor, trace);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeWithTypeParameters, property, propertyDescriptor, trace);
        propertyDescriptor.initialize(getter, setter);
        trace.record(BindingContext.VARIABLE, property, propertyDescriptor);
        return propertyDescriptor;
    }

    static boolean hasBody(JetProperty property) {
        boolean hasBody;
        boolean bl = hasBody = property.getInitializer() != null;
        if (!hasBody) {
            JetPropertyAccessor getter = property.getGetter();
            if (getter != null && getter.getBodyExpression() != null) {
                hasBody = true;
            }
            JetPropertyAccessor setter = property.getSetter();
            if (!hasBody && setter != null && setter.getBodyExpression() != null) {
                hasBody = true;
            }
        }
        return hasBody;
    }

    @NotNull
    private JetType getVariableType(final @NotNull JetScope scope, @NotNull JetProperty property, final @NotNull DataFlowInfo dataFlowInfo, boolean allowDeferred, final BindingTrace trace) {
        JetTypeReference propertyTypeRef = property.getPropertyTypeRef();
        if (propertyTypeRef == null) {
            final JetExpression initializer = property.getInitializer();
            if (initializer == null) {
                return ErrorUtils.createErrorType("No type, no body");
            }
            LazyValueWithDefault<JetType> lazyValue = new LazyValueWithDefault<JetType>(ErrorUtils.createErrorType("Recursive dependency")){

                @Override
                protected JetType compute() {
                    return DescriptorResolver.this.expressionTypingServices.safeGetType(scope, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
                }
            };
            if (allowDeferred) {
                return DeferredType.create(trace, (LazyValue<JetType>)lazyValue);
            }
            return (JetType)lazyValue.get();
        }
        return this.typeResolver.resolveType(scope, propertyTypeRef, trace, true);
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Modality defaultModality) {
        if (modifierList == null) {
            return defaultModality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        if (hasAbstractModifier) {
            return Modality.ABSTRACT;
        }
        boolean hasFinalModifier = modifierList.hasModifier(JetTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        if (hasFinalModifier) {
            return Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList) {
        Visibility defaultVisibility = modifierList != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.INTERNAL;
        return DescriptorResolver.resolveVisibilityFromModifiers(modifierList, defaultVisibility);
    }

    @NotNull
    static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
                return Visibilities.INTERNAL_PROTECTED;
            }
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull JetScope scope, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        JetPropertyAccessor setter = property.getSetter();
        PropertySetterDescriptor setterDescriptor = null;
        if (setter != null) {
            List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotations(scope, setter.getModifierList(), trace);
            JetParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptor(propertyDescriptor, annotations, DescriptorResolver.resolveModalityFromModifiers(setter.getModifierList(), propertyDescriptor.getModality()), DescriptorResolver.resolveVisibilityFromModifiers(setter.getModifierList(), propertyDescriptor.getVisibility()), setter.getBodyExpression() != null, false, CallableMemberDescriptor.Kind.DECLARATION);
            if (parameter != null) {
                JetType type;
                JetTypeReference typeReference;
                JetExpression defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(defaultValue));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type = propertyDescriptor.getType();
                } else {
                    type = this.typeResolver.resolveType(scope, typeReference, trace, true);
                    JetType inType = propertyDescriptor.getType();
                    if (inType != null && !TypeUtils.equalTypes(type, inType)) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type));
                    }
                }
                MutableValueParameterDescriptor valueParameterDescriptor = this.resolveValueParameterDescriptor(scope, setterDescriptor, parameter, 0, type, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property.isVar()) {
            setterDescriptor = this.createDefaultSetter(propertyDescriptor);
        }
        if (!property.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    private PropertySetterDescriptor createDefaultSetter(PropertyDescriptor propertyDescriptor) {
        PropertySetterDescriptor setterDescriptor = new PropertySetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), false, true, CallableMemberDescriptor.Kind.DECLARATION);
        setterDescriptor.initializeDefault();
        return setterDescriptor;
    }

    @Nullable
    private PropertyGetterDescriptor resolvePropertyGetterDescriptor(@NotNull JetScope scope, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        PropertyGetterDescriptor getterDescriptor;
        JetPropertyAccessor getter = property.getGetter();
        if (getter != null) {
            JetType outType;
            List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotations(scope, getter.getModifierList(), trace);
            JetType returnType = outType = propertyDescriptor.getType();
            JetTypeReference returnTypeReference = getter.getReturnTypeReference();
            if (returnTypeReference != null) {
                returnType = this.typeResolver.resolveType(scope, returnTypeReference, trace, true);
                if (outType != null && !TypeUtils.equalTypes(returnType, outType)) {
                    trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyDescriptor.getReturnType(), outType));
                }
            }
            getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, annotations, DescriptorResolver.resolveModalityFromModifiers(getter.getModifierList(), propertyDescriptor.getModality()), DescriptorResolver.resolveVisibilityFromModifiers(getter.getModifierList(), propertyDescriptor.getVisibility()), getter.getBodyExpression() != null, false, CallableMemberDescriptor.Kind.DECLARATION);
            getterDescriptor.initialize(returnType);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            getterDescriptor = this.createDefaultGetter(propertyDescriptor);
            getterDescriptor.initialize(propertyDescriptor.getType());
        }
        return getterDescriptor;
    }

    private PropertyGetterDescriptor createDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), false, true, CallableMemberDescriptor.Kind.DECLARATION);
        return getterDescriptor;
    }

    @NotNull
    public ConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull JetSecondaryConstructor constructor, BindingTrace trace) {
        return this.createConstructorDescriptor(scope, classDescriptor, false, constructor.getModifierList(), constructor, classDescriptor.getTypeConstructor().getParameters(), constructor.getValueParameters(), trace);
    }

    @NotNull
    private ConstructorDescriptorImpl createConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, boolean isPrimary, @Nullable JetModifierList modifierList, @NotNull JetDeclaration declarationToTrace, List<TypeParameterDescriptor> typeParameters, @NotNull List<JetParameter> valueParameters, BindingTrace trace) {
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classDescriptor, this.annotationResolver.resolveAnnotations(scope, modifierList, trace), isPrimary);
        trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        WritableScopeImpl parameterScope = new WritableScopeImpl(scope, classDescriptor, new TraceBasedRedeclarationHandler(trace), "Scope with value parameters of a constructor");
        parameterScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        return constructorDescriptor.initialize(typeParameters, this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters, trace), DescriptorResolver.resolveVisibilityFromModifiers(modifierList, Visibilities.PUBLIC));
    }

    @Nullable
    public ConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull JetClass classElement, BindingTrace trace) {
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY && !classElement.hasPrimaryConstructor()) {
            return null;
        }
        return this.createConstructorDescriptor(scope, classDescriptor, true, classElement.getPrimaryConstructorModifierList(), classElement, classDescriptor.getTypeConstructor().getParameters(), classElement.getPrimaryConstructorParameters(), trace);
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull JetScope scope, @NotNull JetParameter parameter, BindingTrace trace) {
        ASTNode abstractNode;
        JetType type = this.resolveParameterType(scope, parameter, trace);
        Name name = parameter.getNameAsName();
        boolean isMutable = parameter.isMutable();
        JetModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && (abstractNode = modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD)) != null) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(classDescriptor, this.annotationResolver.resolveAnnotations(scope, modifierList, trace), DescriptorResolver.resolveModalityFromModifiers(parameter.getModifierList(), Modality.FINAL), DescriptorResolver.resolveVisibilityFromModifiers(parameter.getModifierList()), isMutable, false, name == null ? Name.special("<no name>") : name, CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(type, Collections.emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(classDescriptor), ReceiverDescriptor.NO_RECEIVER);
        PropertyGetterDescriptor getter = this.createDefaultGetter(propertyDescriptor);
        PropertySetterDescriptor setter = this.createDefaultSetter(propertyDescriptor);
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        return propertyDescriptor;
    }

    public static void checkBounds(@NotNull JetTypeReference typeReference, @NotNull JetType type, BindingTrace trace) {
        if (ErrorUtils.isErrorType(type)) {
            return;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters = type.getConstructor().getParameters();
        List<TypeProjection> arguments = type.getArguments();
        assert (parameters.size() == arguments.size());
        List<JetTypeReference> jetTypeArguments = typeElement.getTypeArgumentsAsTypes();
        assert (jetTypeArguments.size() == arguments.size()) : typeElement.getText();
        TypeSubstitutor substitutor = TypeSubstitutor.create(type);
        for (int i = 0; i < jetTypeArguments.size(); ++i) {
            JetTypeReference jetTypeArgument = jetTypeArguments.get(i);
            if (jetTypeArgument == null) continue;
            JetType typeArgument = arguments.get(i).getType();
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    public static void checkBounds(@NotNull JetTypeReference jetTypeArgument, @NotNull JetType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor, BindingTrace trace) {
        for (JetType bound : typeParameterDescriptor.getUpperBounds()) {
            JetType substitutedBound = substitutor.safeSubstitute(bound, Variance.INVARIANT);
            if (JetTypeChecker.INSTANCE.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    final class UpperBoundCheckerTask {
        JetTypeReference upperBound;
        JetType upperBoundType;
        boolean isClassObjectConstraint;

        private UpperBoundCheckerTask(JetTypeReference upperBound, JetType upperBoundType, boolean classObjectConstraint) {
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
            this.isClassObjectConstraint = classObjectConstraint;
        }
    }
}

