/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.types.JetType;

public class DelegationResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private BindingTrace trace;

    @Inject
    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void process() {
        this.addDelegatedMembers();
    }

    private void addDelegatedMembers() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.addDelegatedMembers(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.addDelegatedMembers((JetClassOrObject)((Object)entry.getKey()), entry.getValue());
        }
    }

    private void addDelegatedMembers(JetClassOrObject jetClass, MutableClassDescriptor classDescriptor) {
        for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
            JetDelegatorByExpressionSpecifier specifier;
            JetType type;
            if (!(delegationSpecifier instanceof JetDelegatorByExpressionSpecifier) || (type = this.trace.get(BindingContext.TYPE, (specifier = (JetDelegatorByExpressionSpecifier)delegationSpecifier).getTypeReference())) == null) continue;
            for (DeclarationDescriptor declarationDescriptor : type.getMemberScope().getAllDescriptors()) {
                SimpleFunctionDescriptor functionDescriptor;
                CallableMemberDescriptor copy;
                if (declarationDescriptor instanceof PropertyDescriptor) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                    if (!propertyDescriptor.getModality().isOverridable()) continue;
                    copy = propertyDescriptor.copy(classDescriptor, true, false, CallableMemberDescriptor.Kind.DELEGATION, true);
                    classDescriptor.getBuilder().addPropertyDescriptor((PropertyDescriptor)copy);
                    this.trace.record(BindingContext.DELEGATED, copy);
                    continue;
                }
                if (!(declarationDescriptor instanceof SimpleFunctionDescriptor) || !(functionDescriptor = (SimpleFunctionDescriptor)declarationDescriptor).getModality().isOverridable()) continue;
                copy = functionDescriptor.copy(classDescriptor, true, false, CallableMemberDescriptor.Kind.DELEGATION, true);
                classDescriptor.getBuilder().addFunctionDescriptor((SimpleFunctionDescriptor)copy);
                this.trace.record(BindingContext.DELEGATED, copy);
            }
        }
    }
}

