/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.SlicedMapKey;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class DelegatingBindingTrace
implements BindingTrace {
    private final BindingContext parentContext;
    private final MutableSlicedMap map = SlicedMapImpl.create();
    private final List<Diagnostic> diagnostics = Lists.newArrayList();
    private final BindingContext bindingContext = new BindingContext(){

        @Override
        public Collection<Diagnostic> getDiagnostics() {
            ArrayList<Diagnostic> mergedDiagnostics = new ArrayList<Diagnostic>(DelegatingBindingTrace.this.diagnostics);
            mergedDiagnostics.addAll(DelegatingBindingTrace.this.parentContext.getDiagnostics());
            return mergedDiagnostics;
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            return DelegatingBindingTrace.this.get(slice, key);
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            return DelegatingBindingTrace.this.getKeys(slice);
        }
    };

    public DelegatingBindingTrace(BindingContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.map.put(slice, key, value);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        V value = this.map.get(slice, key);
        if (slice instanceof Slices.SetSlice) {
            assert (value != null);
            if (value.equals(true)) {
                return value;
            }
        } else if (value != null) {
            return value;
        }
        return this.parentContext.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> keys = this.map.getKeys(slice);
        Collection<K> fromParent = this.parentContext.getKeys(slice);
        if (keys.isEmpty()) {
            return fromParent;
        }
        if (fromParent.isEmpty()) {
            return keys;
        }
        ArrayList<K> result = Lists.newArrayList(keys);
        result.addAll(fromParent);
        return result;
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace) {
        this.addAllMyDataTo(trace, null, true);
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace, @Nullable Predicate<WritableSlice> filter, boolean commitDiagnostics) {
        for (Map.Entry entry : this.map) {
            SlicedMapKey slicedMapKey = (SlicedMapKey)entry.getKey();
            Object value = entry.getValue();
            WritableSlice slice = slicedMapKey.getSlice();
            if (filter != null && !filter.apply(slice)) continue;
            trace.record(slice, slicedMapKey.getKey(), value);
        }
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : this.diagnostics) {
            trace.report(diagnostic);
        }
    }

    public void clear() {
        this.map.clear();
        this.diagnostics.clear();
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        this.diagnostics.add(diagnostic);
    }
}

