/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class DeclarationsChecker {
    @NotNull
    private BindingTrace trace;

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        Map<JetClass, MutableClassDescriptor> classes = bodiesResolveContext.getClasses();
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : classes.entrySet()) {
            JetClass aClass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(aClass)) continue;
            this.checkClass(aClass, classDescriptor);
            this.checkModifiers(aClass.getModifierList(), classDescriptor);
        }
        Map<JetObjectDeclaration, MutableClassDescriptor> objects = bodiesResolveContext.getObjects();
        for (Map.Entry<JetObjectDeclaration, MutableClassDescriptor> entry : objects.entrySet()) {
            JetObjectDeclaration objectDeclaration = entry.getKey();
            MutableClassDescriptor objectDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(objectDeclaration)) continue;
            this.checkObject(objectDeclaration, objectDescriptor);
        }
        Map<JetNamedFunction, SimpleFunctionDescriptor> functions = bodiesResolveContext.getFunctions();
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : functions.entrySet()) {
            JetNamedFunction function = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(function)) continue;
            this.checkFunction(function, functionDescriptor);
            this.checkModifiers(function.getModifierList(), functionDescriptor);
        }
        Map<JetProperty, PropertyDescriptor> properties = bodiesResolveContext.getProperties();
        for (Map.Entry<JetProperty, PropertyDescriptor> entry : properties.entrySet()) {
            JetProperty property = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(property)) continue;
            this.checkProperty(property, propertyDescriptor);
            this.checkModifiers(property.getModifierList(), propertyDescriptor);
        }
    }

    private void checkClass(JetClass aClass, MutableClassDescriptor classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTraitModifiers(aClass);
        this.checkEnum(aClass, classDescriptor);
    }

    private void checkTraitModifiers(JetClass aClass) {
        if (!aClass.isTrait()) {
            return;
        }
        JetModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.hasModifier(JetTokens.FINAL_KEYWORD)) {
            this.trace.report(Errors.TRAIT_CAN_NOT_BE_FINAL.on(modifierList.getModifierNode(JetTokens.FINAL_KEYWORD).getPsi()));
        }
        if (modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(aClass));
        }
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_TRAIT.on(aClass));
        }
    }

    private void checkObject(JetObjectDeclaration objectDeclaration, MutableClassDescriptor classDescriptor) {
        this.checkIllegalInThisContextModifiers(objectDeclaration.getModifierList(), Sets.newHashSet(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.OVERRIDE_KEYWORD));
    }

    private void checkOpenMembers(MutableClassDescriptor classDescriptor) {
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            JetNamedDeclaration member = (JetNamedDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), memberDescriptor);
            if (member == null || classDescriptor.getModality() != Modality.FINAL || !member.hasModifier(JetTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on(member));
        }
    }

    private void checkProperty(JetProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = containingDeclaration instanceof ClassDescriptor ? (ClassDescriptor)containingDeclaration : null;
        this.checkPropertyAbstractness(property, propertyDescriptor, classDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor, classDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkDeclaredTypeInPublicMember(property, propertyDescriptor);
    }

    private void checkDeclaredTypeInPublicMember(JetNamedDeclaration member, CallableMemberDescriptor memberDescriptor) {
        boolean hasDeferredType;
        if (member instanceof JetProperty) {
            hasDeferredType = ((JetProperty)member).getPropertyTypeRef() == null && DescriptorResolver.hasBody((JetProperty)member);
        } else {
            assert (member instanceof JetFunction);
            JetFunction function = (JetFunction)member;
            boolean bl = hasDeferredType = function.getReturnTypeRef() == null && function.getBodyExpression() != null && !function.hasBlockBody();
        }
        if (memberDescriptor.getVisibility().isPublicAPI() && memberDescriptor.getOverriddenDescriptors().size() == 0 && hasDeferredType) {
            this.trace.report(Errors.PUBLIC_MEMBER_SHOULD_SPECIFY_TYPE.on(member));
        }
    }

    private void checkPropertyAbstractness(JetProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        ASTNode abstractNode;
        JetPropertyAccessor getter = property.getGetter();
        JetPropertyAccessor setter = property.getSetter();
        JetModifierList modifierList = property.getModifierList();
        ASTNode aSTNode = abstractNode = modifierList != null ? modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD) : null;
        if (abstractNode != null) {
            if (classDescriptor == null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_NOT_IN_CLASS.on(property));
                return;
            }
            if (classDescriptor.getModality() != Modality.ABSTRACT && classDescriptor.getKind() != ClassKind.ENUM_CLASS) {
                JetClass classElement = (JetClass)BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor);
                String name = property.getName();
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on(property, name != null ? name : "", classDescriptor));
                return;
            }
            if (classDescriptor.getKind() == ClassKind.TRAIT) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(property));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            JetExpression initializer;
            JetType returnType = propertyDescriptor.getReturnType();
            if (returnType instanceof DeferredType) {
                returnType = ((DeferredType)returnType).getActualType();
            }
            if ((initializer = property.getInitializer()) != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on(initializer));
            }
            if (getter != null && getter.getBodyExpression() != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on(getter));
            }
            if (setter != null && setter.getBodyExpression() != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on(setter));
            }
        }
    }

    private void checkPropertyInitializer(JetProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        boolean hasAccessorImplementation;
        JetPropertyAccessor getter = property.getGetter();
        JetPropertyAccessor setter = property.getSetter();
        boolean bl = hasAccessorImplementation = getter != null && getter.getBodyExpression() != null || setter != null && setter.getBodyExpression() != null;
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (property.getInitializer() == null && property.getPropertyTypeRef() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property));
            }
            return;
        }
        boolean inTrait = classDescriptor != null && classDescriptor.getKind() == ClassKind.TRAIT;
        JetExpression initializer = property.getInitializer();
        boolean backingFieldRequired = this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_TRAIT.on(property));
        }
        if (initializer == null) {
            boolean error = false;
            if (backingFieldRequired && !inTrait && !this.trace.getBindingContext().get(BindingContext.IS_INITIALIZED, propertyDescriptor).booleanValue()) {
                if (classDescriptor == null || hasAccessorImplementation) {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on(property));
                } else {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on(property));
                }
            }
            if (!error && property.getPropertyTypeRef() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property));
            }
            return;
        }
        if (inTrait) {
            this.trace.report(Errors.PROPERTY_INITIALIZER_IN_TRAIT.on(initializer));
        } else if (!backingFieldRequired) {
            this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on(initializer));
        }
    }

    protected void checkFunction(JetNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        this.checkDeclaredTypeInPublicMember(function, functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean inAbstractClass;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDescriptor;
            boolean inTrait = classDescriptor.getKind() == ClassKind.TRAIT;
            boolean inEnum = classDescriptor.getKind() == ClassKind.ENUM_CLASS;
            boolean bl = inAbstractClass = classDescriptor.getModality() == Modality.ABSTRACT;
            if (hasAbstractModifier && !inAbstractClass && !inTrait && !inEnum) {
                JetClass classElement = (JetClass)BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor);
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on(function, functionDescriptor.getName().getName(), classDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(function));
            }
            if (function.getBodyExpression() != null && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on(function, functionDescriptor));
            }
            if (function.getBodyExpression() == null && !hasAbstractModifier && !inTrait) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            return;
        }
        if (hasAbstractModifier) {
            this.trace.report(Errors.NON_MEMBER_ABSTRACT_FUNCTION.on(function, functionDescriptor));
        }
        if (function.getBodyExpression() == null && !hasAbstractModifier) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
    }

    private void checkAccessors(JetProperty property, PropertyDescriptor propertyDescriptor) {
        block5: {
            JetModifierList getterModifierList;
            for (JetPropertyAccessor accessor : property.getAccessors()) {
                this.checkIllegalInThisContextModifiers(accessor.getModifierList(), Sets.newHashSet(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD, JetTokens.OVERRIDE_KEYWORD));
            }
            JetPropertyAccessor getter = property.getGetter();
            PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
            JetModifierList jetModifierList = getterModifierList = getter != null ? getter.getModifierList() : null;
            if (getterModifierList == null || getterDescriptor == null) break block5;
            Map<JetKeywordToken, ASTNode> nodes = DeclarationsChecker.getNodesCorrespondingToModifiers(getterModifierList, Sets.newHashSet(JetTokens.PUBLIC_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PRIVATE_KEYWORD, JetTokens.INTERNAL_KEYWORD));
            if (getterDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY.on(node.getPsi()));
                }
            } else {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.REDUNDANT_MODIFIER_IN_GETTER.on(node.getPsi()));
                }
            }
        }
    }

    private void checkModifiers(@Nullable JetModifierList modifierList, @NotNull DeclarationDescriptor descriptor) {
        this.checkModalityModifiers(modifierList);
        this.checkVisibilityModifiers(modifierList, descriptor);
    }

    private void checkModalityModifiers(@Nullable JetModifierList modifierList) {
        if (modifierList == null) {
            return;
        }
        this.checkRedundantModifier(modifierList, Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.ABSTRACT_KEYWORD), Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.OVERRIDE_KEYWORD));
        this.checkCompatibility(modifierList, Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD), Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD));
    }

    private void checkVisibilityModifiers(@Nullable JetModifierList modifierList, @NotNull DeclarationDescriptor descriptor) {
        if (modifierList == null) {
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor && modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            this.trace.report(Errors.PACKAGE_MEMBER_CANNOT_BE_PROTECTED.on(modifierList.getModifierNode(JetTokens.PROTECTED_KEYWORD).getPsi()));
        }
        this.checkCompatibility(modifierList, Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD), Lists.newArrayList(JetTokens.PROTECTED_KEYWORD, JetTokens.INTERNAL_KEYWORD));
    }

    private void checkCompatibility(@Nullable JetModifierList modifierList, Collection<JetKeywordToken> availableModifiers, Collection<JetToken> ... availableCombinations) {
        if (modifierList == null) {
            return;
        }
        LinkedHashSet<JetKeywordToken> presentModifiers = Sets.newLinkedHashSet();
        for (JetKeywordToken modifier : availableModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            presentModifiers.add(modifier);
        }
        if (presentModifiers.size() == 1) {
            return;
        }
        for (Collection<JetToken> combination : availableCombinations) {
            if (!presentModifiers.containsAll(combination) || !combination.containsAll(presentModifiers)) continue;
            return;
        }
        for (JetKeywordToken token : presentModifiers) {
            this.trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(modifierList.getModifierNode(token).getPsi(), presentModifiers));
        }
    }

    private void checkRedundantModifier(@NotNull JetModifierList modifierList, Pair<JetKeywordToken, JetKeywordToken> ... redundantBundles) {
        for (Pair<JetKeywordToken, JetKeywordToken> tokenPair : redundantBundles) {
            JetKeywordToken redundantModifier = tokenPair.getFirst();
            JetKeywordToken sufficientModifier = tokenPair.getSecond();
            if (!modifierList.hasModifier(redundantModifier) || !modifierList.hasModifier(sufficientModifier)) continue;
            this.trace.report(Errors.REDUNDANT_MODIFIER.on(modifierList.getModifierNode(redundantModifier).getPsi(), redundantModifier, sufficientModifier));
        }
    }

    private void checkIllegalInThisContextModifiers(@Nullable JetModifierList modifierList, Collection<JetKeywordToken> illegalModifiers) {
        if (modifierList == null) {
            return;
        }
        for (JetKeywordToken modifier : illegalModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            this.trace.report(Errors.ILLEGAL_MODIFIER.on(modifierList.getModifierNode(modifier).getPsi(), modifier));
        }
    }

    @NotNull
    public static Map<JetKeywordToken, ASTNode> getNodesCorrespondingToModifiers(@NotNull JetModifierList modifierList, Collection<JetKeywordToken> possibleModifiers) {
        HashMap<JetKeywordToken, ASTNode> nodes = Maps.newHashMap();
        for (JetKeywordToken modifier : possibleModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            nodes.put(modifier, modifierList.getModifierNode(modifier));
        }
        return nodes;
    }

    private void checkEnum(JetClass aClass, ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() != ClassKind.ENUM_ENTRY) {
            return;
        }
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration().getContainingDeclaration();
        assert (declaration instanceof ClassDescriptor);
        ClassDescriptor enumClass = (ClassDescriptor)declaration;
        assert (enumClass.getKind() == ClassKind.ENUM_CLASS);
        List<JetDelegationSpecifier> delegationSpecifiers = aClass.getDelegationSpecifiers();
        ConstructorDescriptor constructor = enumClass.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null);
        if (!constructor.getValueParameters().isEmpty() && delegationSpecifiers.isEmpty()) {
            this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(aClass, enumClass));
        }
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetType type;
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
            JetType enumType = enumClass.getDefaultType();
            if (type.getConstructor().equals(enumType.getConstructor())) continue;
            this.trace.report(Errors.ENUM_ENTRY_ILLEGAL_TYPE.on(typeReference, enumClass));
        }
    }
}

