/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Function;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementBase;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class DeclarationResolver {
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private BindingTrace trace;

    @Inject
    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    @Inject
    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        this.importsResolver = importsResolver;
    }

    @Inject
    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull JetScope rootScope) {
        this.resolveConstructorHeaders();
        this.resolveAnnotationStubsOnClassesAndConstructors();
        this.resolveFunctionAndPropertyHeaders();
        this.importsResolver.processMembersImports(rootScope);
        this.checkRedeclarationsInNamespaces();
    }

    private void resolveConstructorHeaders() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            this.processPrimaryConstructor(classDescriptor, jetClass);
            for (JetSecondaryConstructor jetConstructor : jetClass.getSecondaryConstructors()) {
                this.processSecondaryConstructor(classDescriptor, jetConstructor);
            }
        }
    }

    private void resolveAnnotationStubsOnClassesAndConstructors() {
        MutableClassDescriptor descriptor;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.resolveAnnotationsForClassOrObject(this.annotationResolver, jetClass, descriptor);
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)entry.getKey();
            descriptor = entry.getValue();
            this.resolveAnnotationsForClassOrObject(this.annotationResolver, objectDeclaration, descriptor);
        }
    }

    private void resolveAnnotationsForClassOrObject(AnnotationResolver annotationResolver, JetClassOrObject jetClass, MutableClassDescriptor descriptor) {
        JetModifierList modifierList = jetClass.getModifierList();
        if (modifierList != null) {
            descriptor.getAnnotations().addAll(annotationResolver.resolveAnnotations(descriptor.getScopeForSupertypeResolution(), modifierList.getAnnotationEntries(), this.trace));
        }
    }

    private void resolveFunctionAndPropertyHeaders() {
        MutableClassDescriptor classDescriptor;
        for (Map.Entry<JetFile, WritableScope> entry : this.context.getNamespaceScopes().entrySet()) {
            JetFile namespace = entry.getKey();
            WritableScope namespaceScope = entry.getValue();
            NamespaceLikeBuilder namespaceDescriptor = this.context.getNamespaceDescriptors().get(namespace).getBuilder();
            this.resolveFunctionAndPropertyHeaders(namespace.getDeclarations(), namespaceScope, namespaceScope, namespaceScope, namespaceDescriptor);
        }
        for (Map.Entry<ElementBase, Object> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = (JetClass)entry.getKey();
            classDescriptor = (MutableClassDescriptor)entry.getValue();
            this.resolveFunctionAndPropertyHeaders(jetClass.getDeclarations(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getScopeForInitializers(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getBuilder());
        }
        for (Map.Entry<ElementBase, Object> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration object = (JetObjectDeclaration)entry.getKey();
            classDescriptor = (MutableClassDescriptor)entry.getValue();
            this.resolveFunctionAndPropertyHeaders(object.getDeclarations(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getScopeForInitializers(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getBuilder());
        }
    }

    private void resolveFunctionAndPropertyHeaders(@NotNull List<JetDeclaration> declarations, final @NotNull JetScope scopeForFunctions, final @NotNull JetScope scopeForPropertyInitializers, final @NotNull JetScope scopeForPropertyAccessors, final @NotNull NamespaceLikeBuilder namespaceLike) {
        for (JetDeclaration declaration : declarations) {
            declaration.accept(new JetVisitorVoid(){

                @Override
                public void visitNamedFunction(JetNamedFunction function) {
                    SimpleFunctionDescriptor functionDescriptor = DeclarationResolver.this.descriptorResolver.resolveFunctionDescriptor(namespaceLike.getOwnerForChildren(), scopeForFunctions, function, DeclarationResolver.this.trace);
                    namespaceLike.addFunctionDescriptor(functionDescriptor);
                    DeclarationResolver.this.context.getFunctions().put(function, functionDescriptor);
                    DeclarationResolver.this.context.getDeclaringScopes().put(function, scopeForFunctions);
                }

                @Override
                public void visitProperty(JetProperty property) {
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolvePropertyDescriptor(namespaceLike.getOwnerForChildren(), scopeForPropertyInitializers, property, DeclarationResolver.this.trace);
                    namespaceLike.addPropertyDescriptor(propertyDescriptor);
                    DeclarationResolver.this.context.getProperties().put(property, propertyDescriptor);
                    DeclarationResolver.this.context.getDeclaringScopes().put(property, scopeForPropertyInitializers);
                    if (property.getGetter() != null) {
                        DeclarationResolver.this.context.getDeclaringScopes().put(property.getGetter(), scopeForPropertyAccessors);
                    }
                    if (property.getSetter() != null) {
                        DeclarationResolver.this.context.getDeclaringScopes().put(property.getSetter(), scopeForPropertyAccessors);
                    }
                }

                @Override
                public void visitObjectDeclaration(JetObjectDeclaration declaration) {
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolveObjectDeclarationAsPropertyDescriptor(namespaceLike.getOwnerForChildren(), declaration, DeclarationResolver.this.context.getObjects().get(declaration), DeclarationResolver.this.trace);
                    namespaceLike.addPropertyDescriptor(propertyDescriptor);
                }

                @Override
                public void visitEnumEntry(JetEnumEntry enumEntry) {
                    if (enumEntry.getPrimaryConstructorParameterList() == null) {
                        MutableClassDescriptorLite classObjectDescriptor = ((MutableClassDescriptorLite)namespaceLike.getOwnerForChildren()).getClassObjectDescriptor();
                        assert (classObjectDescriptor != null);
                        PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolveObjectDeclarationAsPropertyDescriptor(classObjectDescriptor, enumEntry, DeclarationResolver.this.context.getClasses().get(enumEntry), DeclarationResolver.this.trace);
                        classObjectDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                    }
                }
            });
        }
    }

    private void processPrimaryConstructor(MutableClassDescriptor classDescriptor, JetClass klass) {
        if (classDescriptor.getKind() == ClassKind.TRAIT) {
            JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
            if (primaryConstructorParameterList != null) {
                this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(primaryConstructorParameterList));
            }
            if (!klass.hasPrimaryConstructor()) {
                return;
            }
        }
        JetScope memberScope = classDescriptor.getScopeForSupertypeResolution();
        ConstructorDescriptorImpl constructorDescriptor = this.descriptorResolver.resolvePrimaryConstructorDescriptor(memberScope, classDescriptor, klass, this.trace);
        for (JetParameter parameter : klass.getPrimaryConstructorParameters()) {
            if (parameter.getValOrVarNode() == null) continue;
            PropertyDescriptor propertyDescriptor = this.descriptorResolver.resolvePrimaryConstructorParameterToAProperty(classDescriptor, memberScope, parameter, this.trace);
            classDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
            this.context.getPrimaryConstructorParameterProperties().put(parameter, propertyDescriptor);
        }
        if (constructorDescriptor != null) {
            classDescriptor.setPrimaryConstructor(constructorDescriptor, this.trace);
        }
    }

    private void processSecondaryConstructor(MutableClassDescriptor classDescriptor, JetSecondaryConstructor constructor) {
        this.trace.report(Errors.SECONDARY_CONSTRUCTORS_ARE_NOT_SUPPORTED.on(constructor));
        if (classDescriptor.getKind() == ClassKind.TRAIT) {
            this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(constructor.getNameNode().getPsi()));
        }
        ConstructorDescriptorImpl constructorDescriptor = this.descriptorResolver.resolveSecondaryConstructorDescriptor(classDescriptor.getScopeForMemberResolution(), classDescriptor, constructor, this.trace);
        classDescriptor.addConstructor(constructorDescriptor, this.trace);
        this.context.getConstructors().put(constructor, constructorDescriptor);
        this.context.getDeclaringScopes().put(constructor, classDescriptor.getScopeForMemberLookup());
    }

    private void checkRedeclarationsInNamespaces() {
        for (NamespaceDescriptorImpl descriptor : this.context.getNamespaceDescriptors().values()) {
            Multimap<Name, DeclarationDescriptor> simpleNameDescriptors = descriptor.getMemberScope().getDeclaredDescriptorsAccessibleBySimpleName();
            for (Name name : simpleNameDescriptors.keySet()) {
                Collection<DeclarationDescriptor> descriptors = Collections2.filter(simpleNameDescriptors.get(name), new Predicate<DeclarationDescriptor>(){

                    @Override
                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        if (descriptor instanceof PropertyDescriptor) {
                            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                            return !propertyDescriptor.getReceiverParameter().exists();
                        }
                        return true;
                    }
                });
                if (descriptors.size() <= 1) continue;
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    for (PsiElement declaration : this.getDeclarationsByDescriptor(declarationDescriptor)) {
                        assert (declaration != null);
                        this.trace.report(Errors.REDECLARATION.on(declaration, declarationDescriptor.getName().getName()));
                    }
                }
            }
        }
    }

    private Collection<PsiElement> getDeclarationsByDescriptor(DeclarationDescriptor declarationDescriptor) {
        Collection<PsiElement> declarations;
        if (declarationDescriptor instanceof NamespaceDescriptor) {
            final NamespaceDescriptor namespace = (NamespaceDescriptor)declarationDescriptor;
            Collection<JetFile> files = this.trace.get(BindingContext.NAMESPACE_TO_FILES, namespace);
            if (files == null) {
                throw new IllegalStateException("declarations corresponding to " + namespace + " are not found");
            }
            declarations = Collections2.transform(files, new Function<JetFile, PsiElement>(){

                @Override
                public PsiElement apply(@Nullable JetFile file) {
                    assert (file != null) : "File is null for namespace " + namespace;
                    return file.getNamespaceHeader().getNameIdentifier();
                }
            });
        } else {
            declarations = Collections.singletonList(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declarationDescriptor));
        }
        return declarations;
    }
}

