/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.cfg.JetFlowInformationProvider;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class ControlFlowAnalyzer {
    private TopDownAnalysisParameters topDownAnalysisParameters;
    private BindingTrace trace;

    @Inject
    public void setTopDownAnalysisParameters(TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        for (JetClass jetClass : bodiesResolveContext.getClasses().keySet()) {
            if (!bodiesResolveContext.completeAnalysisNeeded(jetClass)) continue;
            this.checkClassOrObject(jetClass);
        }
        for (JetObjectDeclaration jetObjectDeclaration : bodiesResolveContext.getObjects().keySet()) {
            if (!bodiesResolveContext.completeAnalysisNeeded(jetObjectDeclaration)) continue;
            this.checkClassOrObject(jetObjectDeclaration);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            JetNamedFunction function = (JetNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(function)) continue;
            JetType expectedReturnType = !function.hasBlockBody() && !function.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(function, expectedReturnType);
        }
        for (JetSecondaryConstructor jetSecondaryConstructor : bodiesResolveContext.getConstructors().keySet()) {
            if (!bodiesResolveContext.completeAnalysisNeeded(jetSecondaryConstructor)) continue;
            this.checkFunction(jetSecondaryConstructor, JetStandardClasses.getUnitType());
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            JetProperty property = (JetProperty)entry.getKey();
            if (!bodiesResolveContext.completeAnalysisNeeded(property)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(property, propertyDescriptor);
        }
    }

    private void checkClassOrObject(JetClassOrObject klass) {
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider((JetDeclaration)((Object)klass), this.trace);
        flowInformationProvider.markUninitializedVariables(this.topDownAnalysisParameters.isDeclaredLocally());
    }

    private void checkProperty(JetProperty property, PropertyDescriptor propertyDescriptor) {
        for (JetPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null);
            this.checkFunction(accessor, accessorDescriptor.getReturnType());
        }
    }

    private void checkFunction(JetDeclarationWithBody function, @NotNull JetType expectedReturnType) {
        assert (function instanceof JetDeclaration);
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider((JetDeclaration)((Object)function), this.trace);
        flowInformationProvider.checkDefiniteReturn(expectedReturnType);
        boolean isPropertyAccessor = function instanceof JetPropertyAccessor;
        flowInformationProvider.markUninitializedVariables(this.topDownAnalysisParameters.isDeclaredLocally() || isPropertyAccessor);
        flowInformationProvider.markUnusedVariables();
        flowInformationProvider.markUnusedLiteralsInBlock();
    }
}

