/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.util.containers.Queue;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetDelegatorToThisCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.ScriptResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.util.lazy.ReenteringLazyValueComputationException;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class BodyResolver {
    @NotNull
    private BodiesResolveContext context;
    @NotNull
    private TopDownAnalysisParameters topDownAnalysisParameters;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptResolver scriptResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private CallResolver callResolver;
    @NotNull
    private ObservableBindingTrace trace;

    @Inject
    public void setTopDownAnalysisParameters(@NotNull TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    @Inject
    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setScriptResolver(@NotNull ScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setCallResolver(@NotNull CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = new ObservableBindingTrace(trace);
    }

    public void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext bodiesResolveContext) {
        this.context = bodiesResolveContext;
        this.resolveDelegationSpecifierLists();
        this.resolveClassAnnotations();
        this.resolvePropertyDeclarationBodies();
        this.resolveAnonymousInitializers();
        this.resolvePrimaryConstructorParameters();
        this.resolveSecondaryConstructorBodies();
        this.resolveFunctionBodies();
        this.scriptResolver.resolveScripts();
        if (!this.topDownAnalysisParameters.isDeclaredLocally()) {
            this.computeDeferredTypes();
        }
    }

    private void resolveDelegationSpecifierLists() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.resolveDelegationSpecifierList(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.resolveDelegationSpecifierList((JetClassOrObject)((Object)entry.getKey()), entry.getValue());
        }
    }

    private void resolveDelegationSpecifierList(JetClassOrObject jetClass, final MutableClassDescriptor descriptor) {
        if (!this.context.completeAnalysisNeeded(jetClass)) {
            return;
        }
        ConstructorDescriptor primaryConstructor = descriptor.getUnsubstitutedPrimaryConstructor();
        final JetScope scopeForConstructor = primaryConstructor == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(descriptor.getScopeForSupertypeResolution(), primaryConstructor, this.trace);
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap<JetTypeReference, JetType> supertypes = Maps.newLinkedHashMap();
        JetVisitorVoid visitor = new JetVisitorVoid(){

            private void recordSupertype(JetTypeReference typeReference, JetType supertype) {
                if (supertype == null) {
                    return;
                }
                supertypes.put(typeReference, supertype);
            }

            @Override
            public void visitDelegationByExpressionSpecifier(JetDelegatorByExpressionSpecifier specifier) {
                JetScope scope;
                JetType type;
                JetExpression delegateExpression;
                ClassDescriptor classDescriptor;
                ClassifierDescriptor declarationDescriptor;
                if (descriptor.getKind() == ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_TRAIT.on(specifier));
                }
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype);
                if (supertype != null && (declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_TRAIT.on(specifier.getTypeReference()));
                }
                if ((delegateExpression = specifier.getDelegateExpression()) != null && (type = typeInferrer.getType(scope = scopeForConstructor == null ? descriptor.getScopeForMemberResolution() : scopeForConstructor, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, BodyResolver.this.trace)) != null && supertype != null && !JetTypeChecker.INSTANCE.isSubtypeOf(type, supertype)) {
                    BodyResolver.this.trace.report(Errors.TYPE_MISMATCH.on(delegateExpression, supertype, type));
                }
            }

            @Override
            public void visitDelegationToSuperCallSpecifier(JetDelegatorToSuperCall call) {
                JetTypeReference typeReference;
                JetElement elementToMark;
                JetValueArgumentList valueArgumentList = call.getValueArgumentList();
                JetElement jetElement = elementToMark = valueArgumentList == null ? call : valueArgumentList;
                if (descriptor.getKind() == ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_TRAIT.on(elementToMark));
                }
                if ((typeReference = call.getTypeReference()) == null) {
                    return;
                }
                if (descriptor.getUnsubstitutedPrimaryConstructor() == null) {
                    assert (descriptor.getKind() == ClassKind.TRAIT);
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeCall(ReceiverDescriptor.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY);
                if (results.isSuccess()) {
                    JetType supertype = results.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype);
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                    if (classDescriptor != null && classDescriptor.getKind() == ClassKind.TRAIT) {
                        BodyResolver.this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(elementToMark));
                    }
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitDelegationToSuperClassSpecifier(JetDelegatorToSuperClass specifier) {
                JetTypeReference typeReference = specifier.getTypeReference();
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype);
                if (supertype == null) {
                    return;
                }
                ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                if (classDescriptor == null) {
                    return;
                }
                if (descriptor.getKind() != ClassKind.TRAIT && !classDescriptor.getConstructors().isEmpty() && !ErrorUtils.isError(classDescriptor.getTypeConstructor()) && classDescriptor.getKind() != ClassKind.TRAIT) {
                    boolean hasConstructorWithoutParams = false;
                    for (ConstructorDescriptor constructor : classDescriptor.getConstructors()) {
                        if (!constructor.getValueParameters().isEmpty()) continue;
                        hasConstructorWithoutParams = true;
                    }
                    if (!hasConstructorWithoutParams) {
                        BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                    } else {
                        BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED_DEFAULT.on(specifier));
                    }
                }
            }

            @Override
            public void visitDelegationToThisCall(JetDelegatorToThisCall thisCall) {
                throw new IllegalStateException("This-calls should be prohibited by the parser");
            }

            @Override
            public void visitJetElement(JetElement element) {
                throw new UnsupportedOperationException(element.getText() + " : " + element);
            }
        };
        for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
            delegationSpecifier.accept(visitor);
        }
        Set<TypeConstructor> parentEnum = Collections.emptySet();
        if (jetClass instanceof JetEnumEntry) {
            parentEnum = Collections.singleton(((ClassDescriptor)descriptor.getContainingDeclaration().getContainingDeclaration()).getTypeConstructor());
        }
        this.checkSupertypeList(descriptor, supertypes, parentEnum);
    }

    private void checkSupertypeList(@NotNull MutableClassDescriptor supertypeOwner, @NotNull Map<JetTypeReference, JetType> supertypes, Set<TypeConstructor> allowedFinalSupertypes) {
        HashSet<TypeConstructor> typeConstructors = Sets.newHashSet();
        boolean classAppeared = false;
        for (Map.Entry<JetTypeReference, JetType> entry : supertypes.entrySet()) {
            TypeConstructor constructor;
            JetTypeReference typeReference = entry.getKey();
            JetType supertype = entry.getValue();
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
            if (classDescriptor != null) {
                if (classDescriptor.getKind() != ClassKind.TRAIT) {
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_TRAIT.on(typeReference));
            }
            if (!typeConstructors.add(constructor = supertype.getConstructor())) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (!constructor.isSealed() || allowedFinalSupertypes.contains(constructor)) continue;
            this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
        }
    }

    private void resolveClassAnnotations() {
    }

    private void resolveAnonymousInitializers() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.resolveAnonymousInitializers(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.resolveAnonymousInitializers((JetClassOrObject)((Object)entry.getKey()), entry.getValue());
        }
    }

    private void resolveAnonymousInitializers(JetClassOrObject jetClassOrObject, MutableClassDescriptor classDescriptor) {
        if (!this.context.completeAnalysisNeeded(jetClassOrObject)) {
            return;
        }
        List<JetClassInitializer> anonymousInitializers = jetClassOrObject.getAnonymousInitializers();
        if (classDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            ConstructorDescriptor primaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            assert (primaryConstructor != null);
            JetScope scopeForInitializers = classDescriptor.getScopeForInitializers();
            for (JetClassInitializer anonymousInitializer : anonymousInitializers) {
                this.expressionTypingServices.getType(scopeForInitializers, anonymousInitializer.getBody(), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, this.trace);
            }
        } else {
            for (JetClassInitializer anonymousInitializer : anonymousInitializers) {
                this.trace.report(Errors.ANONYMOUS_INITIALIZER_WITHOUT_CONSTRUCTOR.on(anonymousInitializer));
            }
        }
    }

    private void resolvePrimaryConstructorParameters() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass klass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            ConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            if (unsubstitutedPrimaryConstructor == null) continue;
            this.checkDefaultParameterValues(klass.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), classDescriptor.getScopeForInitializers());
        }
    }

    private void resolveSecondaryConstructorBodies() {
        for (Map.Entry<JetSecondaryConstructor, ConstructorDescriptor> entry : this.context.getConstructors().entrySet()) {
            JetSecondaryConstructor constructor = entry.getKey();
            ConstructorDescriptor descriptor = entry.getValue();
            this.resolveSecondaryConstructorBody(constructor, descriptor);
            assert (descriptor.getReturnType() != null);
        }
    }

    private void resolveSecondaryConstructorBody(JetSecondaryConstructor declaration, final ConstructorDescriptor descriptor) {
        if (!this.context.completeAnalysisNeeded(declaration)) {
            return;
        }
        MutableClassDescriptor classDescriptor = (MutableClassDescriptor)descriptor.getContainingDeclaration();
        final JetScope scopeForSupertypeInitializers = FunctionDescriptorUtil.getFunctionInnerScope(classDescriptor.getScopeForSupertypeResolution(), descriptor, this.trace);
        JetScope scopeForConstructorBody = FunctionDescriptorUtil.getFunctionInnerScope(classDescriptor.getScopeForInitializers(), descriptor, this.trace);
        final DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
        PsiElement nameElement = declaration.getNameNode().getPsi();
        if (classDescriptor.getUnsubstitutedPrimaryConstructor() == null) {
            this.trace.report(Errors.SECONDARY_CONSTRUCTOR_BUT_NO_PRIMARY.on(nameElement));
        } else {
            List<JetDelegationSpecifier> initializers = declaration.getInitializers();
            if (initializers.isEmpty()) {
                this.trace.report(Errors.SECONDARY_CONSTRUCTOR_NO_INITIALIZER_LIST.on(nameElement));
            } else {
                initializers.get(0).accept(new JetVisitorVoid(){

                    @Override
                    public void visitDelegationToSuperCallSpecifier(JetDelegatorToSuperCall call) {
                        JetTypeReference typeReference = call.getTypeReference();
                        if (typeReference != null) {
                            BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForSupertypeInitializers, CallMaker.makeCall(ReceiverDescriptor.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo);
                        }
                    }

                    @Override
                    public void visitDelegationToThisCall(JetDelegatorToThisCall call) {
                        ClassDescriptor classDescriptor = descriptor.getContainingDeclaration();
                        BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForSupertypeInitializers, CallMaker.makeCall(ReceiverDescriptor.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo);
                    }

                    @Override
                    public void visitDelegationByExpressionSpecifier(JetDelegatorByExpressionSpecifier specifier) {
                        BodyResolver.this.trace.report(Errors.BY_IN_SECONDARY_CONSTRUCTOR.on(specifier));
                    }

                    @Override
                    public void visitDelegationToSuperClassSpecifier(JetDelegatorToSuperClass specifier) {
                        BodyResolver.this.trace.report(Errors.INITIALIZER_WITH_NO_ARGUMENTS.on(specifier));
                    }

                    @Override
                    public void visitDelegationSpecifier(JetDelegationSpecifier specifier) {
                        throw new IllegalStateException();
                    }
                });
                int initializersSize = initializers.size();
                for (int i = 1; i < initializersSize; ++i) {
                    JetDelegationSpecifier initializer = initializers.get(i);
                    this.trace.report(Errors.MANY_CALLS_TO_THIS.on(initializer));
                }
            }
        }
        JetExpression bodyExpression = declaration.getBodyExpression();
        if (bodyExpression != null) {
            this.expressionTypingServices.checkFunctionReturnType(scopeForConstructorBody, declaration, descriptor, DataFlowInfo.EMPTY, JetStandardClasses.getUnitType(), this.trace);
        }
        this.checkDefaultParameterValues(declaration.getValueParameters(), descriptor.getValueParameters(), scopeForConstructorBody);
    }

    private void resolvePropertyDeclarationBodies() {
        HashSet<JetProperty> processed = Sets.newHashSet();
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            if (!this.context.completeAnalysisNeeded(jetClass)) continue;
            MutableClassDescriptor classDescriptor = entry.getValue();
            for (JetProperty property : jetClass.getProperties()) {
                ConstructorDescriptor primaryConstructor;
                PropertyDescriptor propertyDescriptor = this.context.getProperties().get(property);
                assert (propertyDescriptor != null);
                BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
                JetExpression initializer = property.getInitializer();
                if (initializer != null && (primaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
                    JetScope declaringScopeForPropertyInitializer = this.context.getDeclaringScopes().get(property);
                    this.resolvePropertyInitializer(property, propertyDescriptor, initializer, declaringScopeForPropertyInitializer);
                }
                this.resolvePropertyAccessors(property, propertyDescriptor);
                processed.add(property);
            }
        }
        for (Map.Entry<JetTypeParameterListOwner, MemberDescriptor> entry : this.context.getProperties().entrySet()) {
            JetProperty property = (JetProperty)entry.getKey();
            if (!this.context.completeAnalysisNeeded(property) || processed.contains(property)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
            JetScope declaringScope = this.context.getDeclaringScopes().get(property);
            JetExpression initializer = property.getInitializer();
            if (initializer != null) {
                this.resolvePropertyInitializer(property, propertyDescriptor, initializer, declaringScope);
            }
            this.resolvePropertyAccessors(property, propertyDescriptor);
        }
    }

    private JetScope makeScopeForPropertyAccessor(@NotNull JetPropertyAccessor accessor, PropertyDescriptor propertyDescriptor) {
        JetScope declaringScope = this.context.getDeclaringScopes().get(accessor);
        JetScope propertyDeclarationInnerScope = this.descriptorResolver.getPropertyDeclarationInnerScope(declaringScope, propertyDescriptor.getTypeParameters(), propertyDescriptor.getReceiverParameter(), this.trace);
        WritableScopeImpl accessorScope = new WritableScopeImpl(propertyDeclarationInnerScope, declaringScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(this.trace), "Accessor scope");
        accessorScope.changeLockLevel(WritableScope.LockLevel.READING);
        return accessorScope;
    }

    private void resolvePropertyAccessors(JetProperty property, PropertyDescriptor propertyDescriptor) {
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        JetPropertyAccessor getter = property.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        if (getter != null && getterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(getter, propertyDescriptor);
            this.resolveFunctionBody(fieldAccessTrackingTrace, getter, getterDescriptor, accessorScope);
        }
        JetPropertyAccessor setter = property.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setter != null && setterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(setter, propertyDescriptor);
            this.resolveFunctionBody(fieldAccessTrackingTrace, setter, setterDescriptor, accessorScope);
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(final PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, new ObservableBindingTrace.RecordHandler<JetReferenceExpression, DeclarationDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<JetReferenceExpression, DeclarationDescriptor> slice, JetReferenceExpression expression, DeclarationDescriptor descriptor) {
                JetSimpleNameExpression simpleNameExpression;
                if (expression instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)expression).getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER && descriptor == propertyDescriptor) {
                    BodyResolver.this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                }
            }
        });
    }

    private void resolvePropertyInitializer(JetProperty property, PropertyDescriptor propertyDescriptor, JetExpression initializer, JetScope scope) {
        JetType expectedTypeForInitializer = property.getPropertyTypeRef() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        JetScope propertyDeclarationInnerScope = this.descriptorResolver.getPropertyDeclarationInnerScope(scope, propertyDescriptor.getTypeParameters(), ReceiverDescriptor.NO_RECEIVER, this.trace);
        JetType type = this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer, expectedTypeForInitializer, DataFlowInfo.EMPTY, this.trace);
    }

    private void resolveFunctionBodies() {
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : this.context.getFunctions().entrySet()) {
            JetNamedFunction declaration = entry.getKey();
            SimpleFunctionDescriptor descriptor = entry.getValue();
            BodyResolver.computeDeferredType(descriptor.getReturnType());
            JetScope declaringScope = this.context.getDeclaringScopes().get(declaration);
            assert (declaringScope != null);
            this.resolveFunctionBody(this.trace, declaration, descriptor, declaringScope);
            assert (descriptor.getReturnType() != null);
        }
    }

    private void resolveFunctionBody(@NotNull BindingTrace trace, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull JetScope declaringScope) {
        if (!this.context.completeAnalysisNeeded(function)) {
            return;
        }
        JetExpression bodyExpression = function.getBodyExpression();
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(declaringScope, functionDescriptor, trace);
        if (bodyExpression != null) {
            this.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, DataFlowInfo.EMPTY, null, trace);
        }
        List<JetParameter> valueParameters = function.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        this.checkDefaultParameterValues(valueParameters, valueParameterDescriptors, functionInnerScope);
        assert (functionDescriptor.getReturnType() != null);
    }

    private void checkDefaultParameterValues(List<JetParameter> valueParameters, List<ValueParameterDescriptor> valueParameterDescriptors, JetScope declaringScope) {
        for (int i = 0; i < valueParameters.size(); ++i) {
            JetParameter jetParameter;
            JetExpression defaultValue;
            ValueParameterDescriptor valueParameterDescriptor = valueParameterDescriptors.get(i);
            if (!valueParameterDescriptor.hasDefaultValue() || (defaultValue = (jetParameter = valueParameters.get(i)).getDefaultValue()) == null) continue;
            this.expressionTypingServices.getType(declaringScope, defaultValue, valueParameterDescriptor.getType(), DataFlowInfo.EMPTY, this.trace);
        }
    }

    private static void computeDeferredType(JetType type) {
        DeferredType deferredType;
        if (type instanceof DeferredType && !(deferredType = (DeferredType)type).isComputed()) {
            deferredType.getActualType();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes != null) {
            final Queue<DeferredType> queue = new Queue<DeferredType>(deferredTypes.size() + 1);
            this.trace.addHandler(BindingContext.DEFERRED_TYPE, new ObservableBindingTrace.RecordHandler<Box<DeferredType>, Boolean>(){

                @Override
                public void handleRecord(WritableSlice<Box<DeferredType>, Boolean> deferredTypeKeyDeferredTypeWritableSlice, Box<DeferredType> key, Boolean value) {
                    queue.addLast(key.getData());
                }
            });
            for (Box<DeferredType> deferredType : deferredTypes) {
                queue.addLast(deferredType.getData());
            }
            while (!queue.isEmpty()) {
                DeferredType deferredType = (DeferredType)queue.pullFirst();
                if (deferredType.isComputed()) continue;
                try {
                    deferredType.getActualType();
                }
                catch (ReenteringLazyValueComputationException reenteringLazyValueComputationException) {}
            }
        }
    }
}

