/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.Slices;

public class BindingContextUtils {
    private static final Slices.KeyNormalizer<DeclarationDescriptor> DECLARATION_DESCRIPTOR_NORMALIZER = new Slices.KeyNormalizer<DeclarationDescriptor>(){

        @Override
        public DeclarationDescriptor normalize(DeclarationDescriptor declarationDescriptor) {
            CallableMemberDescriptor callable;
            if (declarationDescriptor instanceof CallableMemberDescriptor && (callable = (CallableMemberDescriptor)declarationDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                throw new IllegalStateException("non-declaration descriptors should be filtered out earler: " + callable);
            }
            return declarationDescriptor.getOriginal();
        }
    };
    static final ReadOnlySlice<DeclarationDescriptor, PsiElement> DESCRIPTOR_TO_DECLARATION = Slices.sliceBuilder().setKeyNormalizer(DECLARATION_DESCRIPTOR_NORMALIZER).build();

    private BindingContextUtils() {
    }

    @Nullable
    public static PsiElement resolveToDeclarationPsiElement(@NotNull BindingContext bindingContext, @Nullable JetReferenceExpression referenceExpression) {
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
        if (declarationDescriptor == null) {
            return bindingContext.get(BindingContext.LABEL_TARGET, referenceExpression);
        }
        PsiElement element = BindingContextUtils.descriptorToDeclaration(bindingContext, declarationDescriptor);
        if (element != null) {
            return element;
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> resolveToDeclarationPsiElements(@NotNull BindingContext bindingContext, @Nullable JetReferenceExpression referenceExpression) {
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
        if (declarationDescriptor == null) {
            return Lists.newArrayList(bindingContext.get(BindingContext.LABEL_TARGET, referenceExpression));
        }
        List<PsiElement> elements = BindingContextUtils.descriptorToDeclarations(bindingContext, declarationDescriptor);
        if (elements.size() > 0) {
            return elements;
        }
        return Lists.newArrayList();
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull BindingContext bindingContext, @Nullable JetElement element, boolean onlyReference) {
        DeclarationDescriptor descriptor = null;
        if (!onlyReference && (element instanceof JetProperty || element instanceof JetParameter)) {
            descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        } else if (element instanceof JetSimpleNameExpression) {
            descriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, (JetSimpleNameExpression)element);
        } else if (element instanceof JetQualifiedExpression) {
            descriptor = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext, ((JetQualifiedExpression)element).getSelectorExpression(), onlyReference);
        }
        if (descriptor instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor;
        }
        return null;
    }

    @Nullable
    public static NamespaceDescriptor namespaceDescriptor(@NotNull BindingContext context, @NotNull JetFile source) {
        return context.get(BindingContext.FILE_TO_NAMESPACE, source);
    }

    @Nullable
    private static PsiElement doGetDescriptorToDeclaration(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        return context.get(DESCRIPTOR_TO_DECLARATION, descriptor);
    }

    @Nullable
    public static PsiElement descriptorToDeclaration(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableMemberDescriptor) {
            return BindingContextUtils.callableDescriptorToDeclaration(context, (CallableMemberDescriptor)descriptor);
        }
        if (descriptor instanceof ClassDescriptor) {
            return BindingContextUtils.classDescriptorToDeclaration(context, (ClassDescriptor)descriptor);
        }
        return BindingContextUtils.doGetDescriptorToDeclaration(context, descriptor);
    }

    @NotNull
    public static List<PsiElement> descriptorToDeclarations(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableMemberDescriptor) {
            return BindingContextUtils.callableDescriptorToDeclarations(context, (CallableMemberDescriptor)descriptor);
        }
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        if (psiElement != null) {
            return Lists.newArrayList(psiElement);
        }
        return Lists.newArrayList();
    }

    @Nullable
    public static PsiElement callableDescriptorToDeclaration(@NotNull BindingContext context, @NotNull CallableMemberDescriptor callable) {
        if (callable.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable.getOverriddenDescriptors();
            if (overriddenDescriptors.size() != 1) {
                throw new IllegalStateException("cannot find declaration: fake descriptor has more then one overridden descriptor: " + callable);
            }
            return BindingContextUtils.callableDescriptorToDeclaration(context, overriddenDescriptors.iterator().next());
        }
        return BindingContextUtils.doGetDescriptorToDeclaration(context, callable.getOriginal());
    }

    private static List<PsiElement> callableDescriptorToDeclarations(@NotNull BindingContext context, @NotNull CallableMemberDescriptor callable) {
        if (callable.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            ArrayList<PsiElement> r = new ArrayList<PsiElement>();
            Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable.getOverriddenDescriptors();
            for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
                r.addAll(BindingContextUtils.callableDescriptorToDeclarations(context, callableMemberDescriptor));
            }
            return r;
        }
        PsiElement psiElement = BindingContextUtils.doGetDescriptorToDeclaration(context, callable);
        return psiElement != null ? Lists.newArrayList(psiElement) : Lists.newArrayList();
    }

    @Nullable
    public static PsiElement classDescriptorToDeclaration(@NotNull BindingContext context, @NotNull ClassDescriptor clazz) {
        return BindingContextUtils.doGetDescriptorToDeclaration(context, clazz);
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function) {
        if (function.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            throw new IllegalArgumentException("function of kind " + (Object)((Object)function.getKind()) + " cannot have declaration");
        }
        trace.record(BindingContext.FUNCTION, psiElement, function);
    }
}

